/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.client;

import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.client.ClientConfiguration;
import de.fzj.unicore.xuudb.client.wsapi.IAdminExtInterface;
import de.fzj.unicore.xuudb.client.wsapi.IDAPAdminExtInterface;
import de.fzj.unicore.xuudb.client.wsapi.IDAPPublicExtInterface;
import de.fzj.unicore.xuudb.client.wsapi.IPublicExtInterface;
import de.fzj.unicore.xuudb.client.wsapi.impl.IAdminExtImpl;
import de.fzj.unicore.xuudb.client.wsapi.impl.IDAPAdminExtImpl;
import de.fzj.unicore.xuudb.client.wsapi.impl.IDAPPublicExtImpl;
import de.fzj.unicore.xuudb.client.wsapi.impl.IPublicExtImpl;
import de.fzj.unicore.xuudb.interfaces.IAdmin;
import de.fzj.unicore.xuudb.interfaces.IDAPAdmin;
import de.fzj.unicore.xuudb.interfaces.IDynamicAttributesPublic;
import de.fzj.unicore.xuudb.interfaces.IPublic;
import eu.unicore.security.xfireutil.client.XFireClientFactory;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.URL;
import org.apache.log4j.Logger;
import org.codehaus.xfire.xmlbeans.XmlBeansServiceFactory;

public class ServiceFactory
extends XmlBeansServiceFactory {
    private static final Logger logger = Log.getLogger((String)"unicore.xuudb.client", ServiceFactory.class);
    private IAdmin adminEndpoint;
    private IPublic publicEndpoint;
    private IDAPAdmin dapAdminEndpoint;
    private IDynamicAttributesPublic dapPublicEndpoint;

    public IDAPAdmin getDapAdminEndpoint() {
        return this.dapAdminEndpoint;
    }

    public ServiceFactory(ClientConfiguration c) throws Exception {
        this.doCreate(c);
    }

    private void doCreate(ClientConfiguration config) throws Exception {
        logger.info((Object)"Creating ServiceFactory ... ");
        ClientProperties secProperties = new ClientProperties(config.getProperties(), "xuudb.truststore.", "xuudb.credential.", "xuudb.client.");
        XFireClientFactory factory = new XFireClientFactory((IClientConfiguration)secProperties);
        URL adminEndpointURL = new URL(config.getValue("address") + "/" + "XUUDBAdmin");
        URL publicEndpointURL = new URL(config.getValue("address") + "/" + "XUUDBQuery");
        URL dapAdminEndpointURL = new URL(config.getValue("address") + "/" + "XUUDBDAPAdmin");
        URL dapPublicEndpointURL = new URL(config.getValue("address") + "/" + "XUUDBDynamicAttributesQuery");
        logger.info((Object)("Creating XUUDB Admin Endpoint at " + adminEndpointURL.toString()));
        this.adminEndpoint = (IAdmin)factory.createPlainWSProxy(IAdmin.class, adminEndpointURL.toString());
        logger.info((Object)("Creating XUUDB Query Endpoint at " + publicEndpointURL.toString()));
        this.publicEndpoint = (IPublic)factory.createPlainWSProxy(IPublic.class, publicEndpointURL.toString());
        logger.info((Object)("Creating XUUDB DAPAdmin Endpoint at " + dapAdminEndpointURL.toString()));
        this.dapAdminEndpoint = (IDAPAdmin)factory.createPlainWSProxy(IDAPAdmin.class, dapAdminEndpointURL.toString());
        logger.info((Object)("Creating XUUDB DAPPublic Endpoint at " + dapPublicEndpointURL.toString()));
        this.dapPublicEndpoint = (IDynamicAttributesPublic)factory.createPlainWSProxy(IDynamicAttributesPublic.class, dapPublicEndpointURL.toString());
        logger.info((Object)"    Done");
    }

    public IAdmin getAdminEndpoint() {
        return this.adminEndpoint;
    }

    public IPublic getPublicEndpoint() {
        return this.publicEndpoint;
    }

    public IAdminExtInterface getAdminAPI() {
        return new IAdminExtImpl(this.adminEndpoint);
    }

    public IPublicExtInterface getPublicAPI() {
        return new IPublicExtImpl(this.publicEndpoint);
    }

    public IDAPAdminExtInterface getDAPAdminAPI() {
        return new IDAPAdminExtImpl(this.dapAdminEndpoint);
    }

    public IDAPPublicExtInterface getDAPPublicAPI() {
        return new IDAPPublicExtImpl(this.dapPublicEndpoint);
    }
}

