/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.client;

import de.fzj.unicore.xuudb.AbstractConfiguration;
import de.fzj.unicore.xuudb.Log;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientConfiguration
extends AbstractConfiguration {
    private static final Logger logger = Log.getLogger((String)"unicore.configuration", ClientConfiguration.class);
    public static final String PROP_BATCH = "batch";
    public static final Map<String, PropertyMD> DEFAULTS = new HashMap<String, PropertyMD>();

    public ClientConfiguration(File config) throws IOException {
        super("xuudb.", FilePropertiesHelper.load((File)config), DEFAULTS, logger);
        this.checkConfigFile(config, logger);
    }

    public ClientConfiguration(Properties p) {
        super("xuudb.", p, DEFAULTS, logger);
    }

    @Override
    protected String createConfigUpdateHint() {
        StringBuilder newOnes = new StringBuilder();
        StringBuilder oldOnes = new StringBuilder();
        this.createCommonConfigUpdateHint(newOnes, oldOnes);
        if (oldOnes.length() > 0) {
            return "Entries to be removed from the config file:\n" + oldOnes + "\nEntries to be added:\n" + newOnes;
        }
        return "";
    }

    public boolean isBatch() {
        return this.getBooleanValue(PROP_BATCH);
    }

    static {
        DEFAULTS.put("address", new PropertyMD("http://localhost:34463"));
        DEFAULTS.put(PROP_BATCH, new PropertyMD("false"));
        DEFAULTS.put("truststore.", new PropertyMD().setCanHaveSubkeys().setHidden().setDescription("Properties with this prefix are used to configure the server's credential. See separate documentation for details."));
        DEFAULTS.put("credential.", new PropertyMD().setCanHaveSubkeys().setHidden().setDescription("Properties with this prefix are used to configure trust and certificate validation settings. See separate documentation for details."));
        DEFAULTS.put("client.", new PropertyMD().setCanHaveSubkeys().setHidden().setDescription("Properties with this prefix are used to configure advanced HTTP client settings. See separate documentation for details."));
    }
}

