/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.client;

import de.fzj.unicore.xuudb.client.ClientConfiguration;
import de.fzj.unicore.xuudb.client.ServiceFactory;
import de.fzj.unicore.xuudb.client.actions.AbstractAction;
import de.fzj.unicore.xuudb.client.actions.AddAction;
import de.fzj.unicore.xuudb.client.actions.AddDNAction;
import de.fzj.unicore.xuudb.client.actions.CheckCertAction;
import de.fzj.unicore.xuudb.client.actions.CheckDNAction;
import de.fzj.unicore.xuudb.client.actions.ConnectionManager;
import de.fzj.unicore.xuudb.client.actions.DAPFindMappingAction;
import de.fzj.unicore.xuudb.client.actions.DAPFindReverseMappingAction;
import de.fzj.unicore.xuudb.client.actions.DAPFreezeMappingAction;
import de.fzj.unicore.xuudb.client.actions.DAPGetAttributes;
import de.fzj.unicore.xuudb.client.actions.DAPListMappingAction;
import de.fzj.unicore.xuudb.client.actions.DAPListPoolsAction;
import de.fzj.unicore.xuudb.client.actions.DAPRemoveMappingAction;
import de.fzj.unicore.xuudb.client.actions.DAPRemovePoolAction;
import de.fzj.unicore.xuudb.client.actions.DAPSimulateGetAttributes;
import de.fzj.unicore.xuudb.client.actions.ExportAction;
import de.fzj.unicore.xuudb.client.actions.ImportAction;
import de.fzj.unicore.xuudb.client.actions.ListAction;
import de.fzj.unicore.xuudb.client.actions.RemoveAction;
import de.fzj.unicore.xuudb.client.actions.UpdateAction;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class CLCExecutor {
    private ConnectionManager connManager;
    private ClientConfiguration conf;
    private String configFile = null;
    private HashMap<String, AbstractAction> actions = new HashMap();
    private String[] parsedLine;
    private boolean consoleError;

    public CLCExecutor() {
    }

    public CLCExecutor(ConnectionManager m) {
        this();
        this.connManager = m;
    }

    public CLCExecutor(ConnectionManager m, String config) {
        this();
        this.connManager = m;
        this.configFile = config;
    }

    public CLCExecutor(String config) {
        this();
        this.configFile = config;
    }

    public String[] getParsedLine() {
        return this.parsedLine;
    }

    public boolean isConsoleError() {
        return this.consoleError;
    }

    public void init() throws Exception {
        ServiceFactory serviceFac = new ServiceFactory(this.conf);
        this.connManager = new ConnectionManager(serviceFac.getAdminAPI(), serviceFac.getPublicAPI(), serviceFac.getDAPAdminAPI(), serviceFac.getDAPPublicAPI());
    }

    public void registerHelpActions() {
        AbstractAction aaObj = new HelpAction(this.connManager);
        this.actions.put(aaObj.getName(), aaObj);
        aaObj = new HelpFullAction(this.connManager);
        this.actions.put(aaObj.getName(), aaObj);
    }

    private void registerAction(Class<? extends AbstractAction> aa) {
        String[] aliases;
        AbstractAction aaObj;
        try {
            Constructor<? extends AbstractAction> constructor = aa.getDeclaredConstructor(ConnectionManager.class);
            aaObj = constructor.newInstance(this.connManager);
        }
        catch (Exception e) {
            System.err.println("Buggy action: can't register action " + aa);
            e.printStackTrace();
            return;
        }
        this.actions.put(aaObj.getName(), aaObj);
        for (String alias : aliases = aaObj.getAliases()) {
            this.actions.put(alias, aaObj);
        }
    }

    public void registerAllActions() {
        this.registerAction(AddDNAction.class);
        this.registerAction(AddAction.class);
        this.registerAction(ListAction.class);
        this.registerAction(RemoveAction.class);
        this.registerAction(UpdateAction.class);
        this.registerAction(ExportAction.class);
        this.registerAction(ImportAction.class);
        this.registerAction(CheckCertAction.class);
        this.registerAction(CheckDNAction.class);
        this.registerAction(DAPListMappingAction.class);
        this.registerAction(DAPFindMappingAction.class);
        this.registerAction(DAPFindReverseMappingAction.class);
        this.registerAction(DAPFreezeMappingAction.class);
        this.registerAction(DAPRemoveMappingAction.class);
        this.registerAction(DAPRemovePoolAction.class);
        this.registerAction(DAPListPoolsAction.class);
        this.registerAction(DAPSimulateGetAttributes.class);
        this.registerAction(DAPGetAttributes.class);
    }

    public boolean parseLine(String[] tokens) throws Exception {
        if (tokens.length == 0 || tokens[0].equals("")) {
            return false;
        }
        String cmd = tokens[0];
        AbstractAction aa = this.actions.get(cmd);
        if (aa == null) {
            System.out.println("Command '" + cmd + "' not found." + " Type 'help' to get started.");
            return false;
        }
        if (tokens.length - 1 < aa.getMinArgsNumber()) {
            System.out.println("There must be at least " + aa.getMinArgsNumber() + " arguments to the '" + aa.getName() + "' command.");
            return false;
        }
        if (tokens.length - 1 > aa.getMaxArgsNumber()) {
            System.out.println("There must be no more than " + aa.getMaxArgsNumber() + " arguments to the '" + aa.getName() + "' command.");
            return false;
        }
        String[] shiftedTokens = new String[tokens.length - 1];
        System.arraycopy(tokens, 1, shiftedTokens, 0, tokens.length - 1);
        return aa.invoke(shiftedTokens, this.conf.isBatch());
    }

    public boolean processCommandLineArgs(String[] args) {
        String[] shiftedArgs;
        Boolean hasRealArgs = true;
        if (args.length == 0) {
            this.printXUUDBUsage();
            return false;
        }
        if (args[0].equalsIgnoreCase("-e")) {
            this.consoleError = true;
            shiftedArgs = new String[args.length - 1];
            System.arraycopy(args, 1, shiftedArgs, 0, args.length - 1);
            args = shiftedArgs;
        }
        if (args[0].equalsIgnoreCase("--config") && args.length > 1) {
            this.configFile = args[1];
            if (args.length > 2) {
                shiftedArgs = new String[args.length - 2];
                System.arraycopy(args, 2, shiftedArgs, 0, args.length - 2);
                args = shiftedArgs;
            } else {
                hasRealArgs = false;
            }
        }
        if (hasRealArgs.booleanValue()) {
            this.parsedLine = args;
            return true;
        }
        this.printXUUDBUsage();
        return false;
    }

    public void printXUUDBUsage() {
        System.out.println("This is a command line client which operates on a UNICORE XUUDB system.\nThe basic syntax is:\n   admin.??? [-e] [--config <configFile>] <COMMAND ...>\n\nOptions are:\n     -e   Print errors\nWithout options this help message is printed. Options order must be preserved.\n\nUse 'help' command to see the list or 'help <CMD>' to get help on every command.\n\n");
    }

    public void readConfig() {
        try {
            if (this.configFile == null) {
                this.configFile = System.getProperty("xuudb.client.conf", new File("conf", "xuudb_client.conf").getAbsolutePath());
            }
            this.conf = new ClientConfiguration(new File(this.configFile));
        }
        catch (Exception e1) {
            System.out.println("Can't read configuration: " + e1);
            System.exit(1);
        }
    }

    public HashMap<String, AbstractAction> getActions() {
        return this.actions;
    }

    private class HelpFullAction
    extends AbstractAction {
        HelpFullAction(ConnectionManager cm) {
            super(cm, "helpAll", "Provides full help for all commands.", 0);
            this.setCategory(AbstractAction.Category.other.toString());
        }

        @Override
        public boolean invoke(String[] args, boolean isBatch) {
            System.out.println("This is command line client which operates on UNICORE XUUDB system. Type 'help <CMD>' to get help on every command. Available commands are:");
            Iterator it = CLCExecutor.this.actions.values().iterator();
            ArrayList<AbstractAction> list = new ArrayList<AbstractAction>();
            while (it.hasNext()) {
                AbstractAction aa = (AbstractAction)it.next();
                if (list.contains(aa)) continue;
                list.add(aa);
            }
            Collections.sort(list);
            Collections.reverse(list);
            for (AbstractAction a : list) {
                System.out.println("\n------------------------------------\nCommand: " + a.getName() + "\n");
                System.out.println(a.getHelp());
            }
            return true;
        }
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction(ConnectionManager cm) {
            super(cm, "help", "Provides help. Use without arguments to get generic help or with command name as parameter to get help on the specified command usage.", 0, 1);
            this.setCategory(AbstractAction.Category.other.toString());
        }

        @Override
        public boolean invoke(String[] args, boolean isBatch) {
            if (args.length >= 1) {
                AbstractAction a = (AbstractAction)CLCExecutor.this.actions.get(args[0]);
                if (a == null) {
                    System.out.println("Command " + args[0] + " is not known");
                } else {
                    System.out.println("Help for command: " + args[0] + " (category: " + a.getCategory() + ")\n" + a.getHelp());
                }
            } else {
                System.out.println("This is command line client which operates on UNICORE XUUDB system. Type 'help <CMD>' to get help on every command. Available commands are:");
                Iterator it = CLCExecutor.this.actions.values().iterator();
                ArrayList<AbstractAction> list = new ArrayList<AbstractAction>();
                while (it.hasNext()) {
                    AbstractAction aa = (AbstractAction)it.next();
                    if (list.contains(aa)) continue;
                    list.add(aa);
                }
                Collections.sort(list);
                Collections.reverse(list);
                String cat = "";
                for (AbstractAction a : list) {
                    if (!cat.equals(a.getCategory())) {
                        System.out.println("\n[" + a.getCategory() + "]");
                        cat = a.getCategory();
                    }
                    System.out.print("  " + a.getName());
                    for (String alias : a.getAliases()) {
                        System.out.print(" (" + alias + ")");
                    }
                    System.out.println();
                }
            }
            return true;
        }
    }
}

