/*
 * Copyright (c) 2008 ICM Uniwersytet Warszawski All rights reserved.
 * See LICENCE file for licencing information.
 *
 * Created on Jul 20, 2008
 * Author: K. Benedyczak <golbi@mat.umk.pl>
 */

//package pl.edu.icm.uvos.webauth;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;

import javax.net.ssl.SSLContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import pl.edu.icm.samly2.SAMLConstants;
import pl.edu.icm.samly2.assertion.Assertion;
import pl.edu.icm.samly2.proto.AuthnRequest;
import pl.edu.icm.unicore.security.xfireutil.client.IAuthenticationConfiguration;

//in client side those dependencies shall be removed
import pl.edu.icm.unicore.uvos.server.VOServer;
import pl.edu.icm.unicore.uvos.util.ConfDefaults;
import pl.edu.icm.unicore.uvos.util.Configuration;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOAuthnClientPOST;

/**
 * Simple testing servlet - prepares a SAML request, embed it into and HTML form
 * according to SAML HTTP POST binding. After successful login it should be 
 * invoked again - this time with POST action, and SAML Response set. 
 * It parses the response, and displays login information received. 
 * @author golbi
 */
@SuppressWarnings("serial")
public class TestLoginServlet extends HttpServlet
{
	/**
	 * here we simply creates auth request
	 */
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
		throws ServletException, IOException
	{
		try
		{
			SAMLVOAuthnClientPOST util = new SAMLVOAuthnClientPOST(new DummyAuthConfig(), 
					new URI("http://myidurl.com"), 
					new URI(req.getRequestURL().toString()));
			AuthnRequest samlReq = 
				util.createRequest(SAMLConstants.NFORMAT_PERSISTENT);
			String xhtml = SAMLVOAuthnClientPOST.writeRequestForm(
				"https://localhost:2443/uvos-webauth-1.0/VOauthentication.do", 
				samlReq, "Arbitrary, HTMLencoded, state info");

			resp.setContentType("text/html; charset=utf-8");
			PrintWriter w = resp.getWriter();
			w.write(xhtml);
			w.flush();
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ServletException(e);
		}
	}

	/**
	 * and here we get response...
	 */
	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
		throws ServletException, IOException
	{
		String rawResponse = req.getParameter(AuthnServlet.REQ_SAML_RESPONSE);
		String relayState = req.getParameter(AuthnServlet.RELAY_STATE);
		try
		{
			SAMLVOAuthnClientPOST util = new SAMLVOAuthnClientPOST(new DummyAuthConfig(), 
					new URI("http://myidurl.com"), 
					new URI(req.getRequestURL().toString()));
			
			//TODO - likely you will want to set public key of the IdP 
			//to check the signature. If not the signature will be checked but 
			//it won't be checked who actually issued it.
			//util.setDSigPolicy(trustedPublicKey);
			
			Assertion authed = util.decodeAndProcess(rawResponse);

			PrintWriter w = resp.getWriter();
			w.write("<html><body>Received SAML response, authenticated user: <br>");
			w.write(SAMLVOAuthnClientPOST.getIdentityFromAssertion(
					authed).toString());
			w.write("<br>Relay state received is: <br>");
			w.write(relayState);
			w.write("</body></html>");
			w.flush();
			
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ServletException(e);
		}
	}
	
	/**
	 * In real client implementation you will need to provide right implementation.
	 * This one simply provides own server's keystore data. Of course it
	 * makes no sense at client side.
	 * @author golbi
	 */
	public class DummyAuthConfig implements IAuthenticationConfiguration
	{
		private Configuration cfg = VOServer.getConfiguration();
		
		public boolean doHttpAuthn()
		{
			return false;
		}

		public boolean doSSLAuthn()
		{
			return false;
		}

		public String getHttpPasswd()
		{
			return null;
		}

		public String getHttpUser()
		{
			return null;
		}

		public SSLContext getSSLContext()
		{
			return null;
		}

		public String getTruststore()
		{
			return null;
		}

		public String getTruststorePasswd()
		{
			return null;
		}

		public String getTruststoreType()
		{
			return null;
		}

		public String getKeystore()
		{
			return cfg.getAsString(ConfDefaults.KEYSTORE, 
					ConfDefaults.keystore, null);
		}

		public String getKeystoreAlias()
		{
			return cfg.getAsString(ConfDefaults.KEYSTORE_ALIAS,
					ConfDefaults.keystoreAlias, null);
		}

		public String getKeystoreKeyPasswd()
		{
			return cfg.getAsString(ConfDefaults.KEYSTORE_KEY_PASSWD,
					getKeystorePasswd(), null);
		}

		public String getKeystorePasswd()
		{
			return cfg.getAsString(ConfDefaults.KEYSTORE_PASSWD, 
					ConfDefaults.keystorePasswd, null);
		}

		public String getKeystoreType()
		{
			return cfg.getAsString(ConfDefaults.KEYSTORE_TYPE,
					ConfDefaults.keystoreType, null);
		}
		
		public DummyAuthConfig clone()
		{
			return null;
		}
	}
}
