from ucfg_updater import *
from ucfg_utils import info, error

from ucfg_main import ConfigUtilities

import os
import re

class UUpdater(UUpdaterBase):
	
	def printDescription(self, options):
		info(options, "Updates UVOS Server from pre-1.6.0 to 1.6.0 version syntax")

	def run(self, options):
		info(options, "UNICORE UVOS Server configuration syntax updater")
		cfgUtil = ConfigUtilities(options, "uvos-server")

		#uvosServer.conf
		cfgUtil.updateJavaPropertyNames('uvosServer.conf', {			
			'uvos.server.keystore' 					: 'uvos.server.credential.path',
			'uvos.server.keystorePasswd' 			: 'uvos.server.credential.password',
			'uvos.server.keystoreType' 				: 'uvos.server.credential.format',
			'uvos.server.keyPasswd' 				: 'uvos.server.credential.keyPassword',
			'uvos.server.keystoreAlias' 			: 'uvos.server.credential.keyAlias',
			'uvos.server.https.truststore' 			: 'uvos.server.truststore.keystorePath',
			'uvos.server.https.truststorePasswd'	: 'uvos.server.truststore.keystorePassword',
			'uvos.server.https.truststoreType' 		: 'uvos.server.truststore.keystoreFormat',
			'db.mapconfigFile' 						: 'uvos.server.db.mapconfigFile',
			'db.datamapPropertiesFile' 				: 'uvos.server.db.datamapPropertiesFile'
		})
		
		cfgUtil.setJavaProperties('uvosServer.conf', {
			'uvos.server.truststore.type'			: 'keystore'
		})
		
		info(options, "IMPORTANT: Security properties were updated to the new format. Note that you should review the new settings and consider MANY new available options, described in documentation.")
		info(options, "Finished update of configuration of UNICORE XUUDB")

