CREATE TABLE IDENTITY_TYPES(
	ID SERIAL PRIMARY KEY,
	VAL VARCHAR(1024)
	);
	

CREATE TABLE ATTRIBUTE_TYPES(
	ID SERIAL PRIMARY KEY,
	NAME VARCHAR(1024) NOT NULL,
	SHORT_DESC VARCHAR(256),
	DESCRIPTION VARCHAR(10240),
	CONSTRAINT attrtype_name_unique UNIQUE(NAME)
	);

CREATE TABLE ENTITIES(
	ID SERIAL PRIMARY KEY,
	PERSISTENT_ID VARCHAR(256) NOT NULL,
	NAME VARCHAR(255),
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP,
	REMOVED_ID INTEGER DEFAULT -1 NOT NULL,	
	CONSTRAINT name_unique UNIQUE (NAME, REMOVED_ID),
	CONSTRAINT persistent_id_unique UNIQUE (PERSISTENT_ID)
	);

CREATE TABLE IDENTITIES(
	ID SERIAL PRIMARY KEY,
	VAL VARCHAR(30000) NOT NULL,
	CMP VARCHAR(1024) NOT NULL,
	TYPEID INTEGER,
	ENTITY_ID INTEGER NOT NULL,
	AUTHN_DATA VARCHAR(10240),
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP,
	REMOVED_ID INTEGER DEFAULT -1 NOT NULL,	
	INACTIVE INTEGER DEFAULT 0 NOT NULL,
	FOREIGN KEY (TYPEID) REFERENCES IDENTITY_TYPES(ID),
	FOREIGN KEY (ENTITY_ID) REFERENCES ENTITIES(ID),
	CONSTRAINT identities_removed_unique UNIQUE(CMP, TYPEID, REMOVED_ID)
	);

CREATE TABLE GROUPS(
	ID SERIAL PRIMARY KEY,
	NAME VARCHAR(255),
	PARENT_ID INTEGER,
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP,
	REMOVED_ID INTEGER DEFAULT -1 NOT NULL,	
	CONSTRAINT groups_removed_unique UNIQUE (PARENT_ID, NAME, REMOVED_ID),
	FOREIGN KEY (PARENT_ID) REFERENCES GROUPS(ID) ON DELETE CASCADE
	);

CREATE TABLE GROUP_ATTRIBUTES(
	ID SERIAL PRIMARY KEY,
	VAL VARCHAR(102400),
	ATTRTYPE_ID INTEGER NOT NULL,
	GROUP_ID INTEGER,
	INACTIVE INTEGER DEFAULT 0 NOT NULL,
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP,	
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID),
	FOREIGN KEY (ATTRTYPE_ID) REFERENCES ATTRIBUTE_TYPES(ID)
	);

CREATE TABLE ENTITY_ATTRIBUTES(
	ID SERIAL PRIMARY KEY,
	ATTRTYPE_ID INTEGER NOT NULL,
	VAL VARCHAR(102400),
	ENTITY_ID INTEGER,
	GROUP_ID INTEGER,
	INACTIVE INTEGER DEFAULT 0 NOT NULL,
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP,
	FOREIGN KEY (ENTITY_ID) REFERENCES ENTITIES(ID),
	FOREIGN KEY (ATTRTYPE_ID) REFERENCES ATTRIBUTE_TYPES(ID),
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID)	
	);

CREATE TABLE GROUP_ENTITIES(
	ID SERIAL PRIMARY KEY,
	ENTITY_ID INTEGER,
	GROUP_ID INTEGER,
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP,
	REMOVED_ID INTEGER DEFAULT -1 NOT NULL,	
	CONSTRAINT group_entities_removed_unique UNIQUE (ENTITY_ID, GROUP_ID, REMOVED_ID),
	FOREIGN KEY (ENTITY_ID) REFERENCES ENTITIES(ID),
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID)		
	);

CREATE TABLE GROUP_SUBGROUPS(
	CHILD_ID INTEGER,
	GROUP_ID INTEGER,
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP,	
	PRIMARY KEY (CHILD_ID, GROUP_ID),
	FOREIGN KEY (CHILD_ID) REFERENCES GROUPS(ID),
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID)		
	);

CREATE TABLE AUTHZ_ATTRIBUTE(
	ATTR_TYPE_ID INTEGER NOT NULL,
	ATTR_VALUE VARCHAR(102400),
	GROUP_ID INTEGER,
	PERMISSION INTEGER NOT NULL,
	CONSTRAINT authzattr_unique UNIQUE (ATTR_TYPE_ID, ATTR_VALUE, GROUP_ID),
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID),
	FOREIGN KEY (ATTR_TYPE_ID) REFERENCES ATTRIBUTE_TYPES(ID)	
	);	

CREATE TABLE AUTHZ_SPECIAL(
	SPECIAL CHAR(1) NOT NULL,
	GROUP_ID INTEGER,
	PERMISSION CHAR(10) NOT NULL,
	CONSTRAINT authzspecial_unique UNIQUE (GROUP_ID, SPECIAL),
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID)
	);

CREATE TABLE APPLICATION_FORMS(
	ID SERIAL PRIMARY KEY,
	FRIENDLY_NAME VARCHAR(256),
	DESCRIPTION VARCHAR(10240),
	AGREEMENT VARCHAR(102400),
	BASE_GROUP_ID INTEGER,
	CONSTRAINTS VARCHAR(102400),

	FOREIGN KEY (BASE_GROUP_ID) REFERENCES GROUPS(ID)
	);	

CREATE TABLE APPLICATIONS(
	ID SERIAL PRIMARY KEY,
	FORM_ID INTEGER,
	ID_VAL VARCHAR(30000) NOT NULL,
	ID_TYPEID INTEGER,
	ID_AUTHN_DATA VARCHAR(10240),
	IS_CSR INTEGER,
	EMAIL_ADDRESS VARCHAR(256),
	REQUESTS VARCHAR(102400),

	STATUS VARCHAR(16),
	ADMIN_NOTES VARCHAR(10240),
	
	EQUIVALENT_ID INTEGER,

	FOREIGN KEY (ID_TYPEID) REFERENCES IDENTITY_TYPES(ID),
	FOREIGN KEY (FORM_ID) REFERENCES APPLICATION_FORMS(ID) ON DELETE CASCADE,
	FOREIGN KEY (EQUIVALENT_ID) REFERENCES IDENTITIES(ID) ON DELETE CASCADE
	);	
	
CREATE TABLE NOTIFICATIONS(
	ID SERIAL PRIMARY KEY,
	GROUP_FILTER VARCHAR(1024),
	RECIPIENTS VARCHAR(1024) NOT NULL,
	OPERATION VARCHAR(32)
);

CREATE TABLE UVOS_FLAG_(
	VAL CHAR(128)
	);

INSERT INTO UVOS_FLAG_ (VAL) VALUES ('1_2_0');