CREATE TABLE IDENTITY_TYPES(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	VAL VARCHAR(1024)
	)#
	

CREATE TABLE ATTRIBUTE_TYPES(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	NAME VARCHAR(1024) NOT NULL,
	SHORT_DESC VARCHAR(256),
	DESCRIPTION MEDIUMTEXT
	)#
	
CREATE TRIGGER TRIG_U_ATT_T
	BEFORE INSERT ON ATTRIBUTE_TYPES 
	FOR EACH ROW BEGIN 
		declare RES INTEGER;
		declare EXIT handler for SQLWARNING SET @x2 = 1; 
		select ID into RES from ATTRIBUTE_TYPES where NAME = NEW.NAME LIMIT 1; 
		if RES IS NOT NULL then SET NEW.ID = RES; end if; 
	END#

CREATE TABLE ENTITIES(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	PERSISTENT_ID VARCHAR(256) NOT NULL,
	NAME VARCHAR(255),
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP NULL DEFAULT NULL,
	REMOVED_ID INTEGER DEFAULT -1 NOT NULL,	
	CONSTRAINT name_unique UNIQUE (NAME, REMOVED_ID),
	CONSTRAINT persistent_id_unique UNIQUE (PERSISTENT_ID)
	)#

CREATE TABLE IDENTITIES(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	VAL MEDIUMTEXT NOT NULL,
	CMP VARCHAR(1024) NOT NULL,
	TYPEID INTEGER,
	ENTITY_ID INTEGER NOT NULL,
	AUTHN_DATA VARCHAR(10240),
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP NULL DEFAULT NULL,
	REMOVED_ID INTEGER DEFAULT -1 NOT NULL,	
	INACTIVE INTEGER DEFAULT 0 NOT NULL,
	FOREIGN KEY (TYPEID) REFERENCES IDENTITY_TYPES(ID),
	FOREIGN KEY (ENTITY_ID) REFERENCES ENTITIES(ID)
	)#

CREATE TRIGGER TRIG_U_IDENTITIES
	BEFORE INSERT ON IDENTITIES 
	FOR EACH ROW BEGIN 
		declare RES INTEGER;
		declare EXIT handler for SQLWARNING SET @x2 = 1; 
		select ID into RES from IDENTITIES where 
			REMOVED_ID = NEW.REMOVED_ID AND TYPEID = NEW.TYPEID AND CMP = NEW.CMP LIMIT 1; 
		if RES IS NOT NULL then SET NEW.ID = RES; end if; 
	END#

CREATE TABLE GROUPS(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	NAME VARCHAR(255),
	PARENT_ID INTEGER,
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP NULL DEFAULT NULL,
	REMOVED_ID INTEGER DEFAULT -1 NOT NULL,	
	CONSTRAINT groups_removed_unique UNIQUE (PARENT_ID, NAME, REMOVED_ID),
	FOREIGN KEY (PARENT_ID) REFERENCES GROUPS(ID) ON DELETE CASCADE
	)#

CREATE TABLE GROUP_ATTRIBUTES(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	VAL MEDIUMTEXT,
	ATTRTYPE_ID INTEGER NOT NULL,
	GROUP_ID INTEGER,
	INACTIVE INTEGER DEFAULT 0 NOT NULL,
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP NULL DEFAULT NULL,	
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID),
	FOREIGN KEY (ATTRTYPE_ID) REFERENCES ATTRIBUTE_TYPES(ID)
	)#

CREATE TABLE ENTITY_ATTRIBUTES(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	ATTRTYPE_ID INTEGER NOT NULL,
	VAL MEDIUMTEXT,
	ENTITY_ID INTEGER,
	GROUP_ID INTEGER,
	INACTIVE INTEGER DEFAULT 0 NOT NULL,
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP NULL DEFAULT NULL,
	FOREIGN KEY (ENTITY_ID) REFERENCES ENTITIES(ID),
	FOREIGN KEY (ATTRTYPE_ID) REFERENCES ATTRIBUTE_TYPES(ID),
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID)	
	)#

CREATE TABLE GROUP_ENTITIES(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	ENTITY_ID INTEGER,
	GROUP_ID INTEGER,
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP NULL DEFAULT NULL,
	REMOVED_ID INTEGER DEFAULT -1 NOT NULL,	
	CONSTRAINT group_entities_removed_unique UNIQUE (ENTITY_ID, GROUP_ID, REMOVED_ID),
	FOREIGN KEY (ENTITY_ID) REFERENCES ENTITIES(ID),
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID)		
	)#

CREATE TABLE GROUP_SUBGROUPS(
	CHILD_ID INTEGER,
	GROUP_ID INTEGER,
	CREATION_TS TIMESTAMP DEFAULT now() NOT NULL,
	REMOVAL_TS TIMESTAMP NULL DEFAULT NULL,	
	PRIMARY KEY (CHILD_ID, GROUP_ID),
	FOREIGN KEY (CHILD_ID) REFERENCES GROUPS(ID),
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID)		
	)#

CREATE TABLE AUTHZ_ATTRIBUTE(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	ATTR_TYPE_ID INTEGER NOT NULL,
	ATTR_VALUE MEDIUMTEXT,
	GROUP_ID INTEGER,
	PERMISSION INTEGER NOT NULL,
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID),
	FOREIGN KEY (ATTR_TYPE_ID) REFERENCES ATTRIBUTE_TYPES(ID)	
	)#
	
CREATE TRIGGER TRIG_U_AUTHZ_ATT
	BEFORE INSERT ON AUTHZ_ATTRIBUTE 
	FOR EACH ROW BEGIN 
		declare RES INTEGER;
		declare EXIT handler for SQLWARNING SET @x2 = 1; 
		select ID into RES from AUTHZ_ATTRIBUTE where 
			GROUP_ID = NEW.GROUP_ID AND ATTR_TYPE_ID = NEW.ATTR_TYPE_ID AND ATTR_VALUE = NEW.ATTR_VALUE LIMIT 1; 
		if RES IS NOT NULL then SET NEW.ID = RES; end if; 
	END#
	

CREATE TABLE AUTHZ_SPECIAL(
	SPECIAL CHAR(1) NOT NULL,
	GROUP_ID INTEGER,
	PERMISSION CHAR(10) NOT NULL,
	CONSTRAINT authzspecial_unique UNIQUE (GROUP_ID, SPECIAL),
	FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID)
	)#

CREATE TABLE APPLICATION_FORMS(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	FRIENDLY_NAME VARCHAR(256),
	DESCRIPTION VARCHAR(10240),
	AGREEMENT MEDIUMTEXT,
	BASE_GROUP_ID INTEGER,
	CONSTRAINTS MEDIUMTEXT,

	FOREIGN KEY (BASE_GROUP_ID) REFERENCES GROUPS(ID)
	)#

CREATE TABLE APPLICATIONS(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	FORM_ID INTEGER,
	ID_VAL MEDIUMTEXT NOT NULL,
	ID_TYPEID INTEGER,
	ID_AUTHN_DATA VARCHAR(10240),
	IS_CSR INTEGER,
	EMAIL_ADDRESS VARCHAR(256),
	REQUESTS MEDIUMTEXT,

	STATUS VARCHAR(16),
	ADMIN_NOTES VARCHAR(10240),
	
	EQUIVALENT_ID INTEGER,

	FOREIGN KEY (ID_TYPEID) REFERENCES IDENTITY_TYPES(ID),
	FOREIGN KEY (FORM_ID) REFERENCES APPLICATION_FORMS(ID) ON DELETE CASCADE,
	FOREIGN KEY (EQUIVALENT_ID) REFERENCES IDENTITIES(ID) ON DELETE CASCADE
	)#
	
CREATE TABLE NOTIFICATIONS(
	ID INTEGER PRIMARY KEY AUTO_INCREMENT,
	GROUP_FILTER VARCHAR(1024),
	RECIPIENTS VARCHAR(1024) NOT NULL,
	OPERATION VARCHAR(32)
)#

CREATE TABLE UVOS_FLAG_(
	VAL CHAR(128)
	)#

INSERT INTO UVOS_FLAG_ (VAL) VALUES ('1_2_0')#