/* remove removed_TS from unique constraints */

alter table entities drop constraint SYS_CT_53;
alter table entities add column REMOVED_ID integer default -1 not null;
update entities set REMOVED_ID = ID WHERE REMOVAL_TS IS NOT NULL;
alter table entities add constraint entities_removed_unique unique (NAME, REMOVED_ID);

alter table identities drop constraint SYS_CT_59;
alter table identities add column REMOVED_ID integer default -1 not null;
update identities set REMOVED_ID = ID WHERE REMOVAL_TS IS NOT NULL;
alter table identities add constraint identities_removed_unique unique (CMP, TYPEID, REMOVED_ID);

alter table groups drop constraint SYS_CT_67;
alter table groups add column REMOVED_ID integer default -1 not null;
update groups set REMOVED_ID = ID WHERE REMOVAL_TS IS NOT NULL;
alter table groups add constraint groups_removed_unique unique (PARENT_ID, NAME, REMOVED_ID);

alter table group_entities drop constraint SYS_CT_93;
alter table group_entities add column REMOVED_ID integer default -1 not null;
alter table group_entities add column ID IDENTITY GENERATED BY DEFAULT AS IDENTITY;
update group_entities set REMOVED_ID = ID WHERE REMOVAL_TS IS NOT NULL;
alter table group_entities add constraint group_entities_removed_unique unique (ENTITY_ID, GROUP_ID, REMOVED_ID);


/* add a new equivalent id field to applications table */

alter table applications add column EQUIVALENT_ID INTEGER;
alter table applications add CONSTRAINT applications_fk_equivalentid FOREIGN KEY (EQUIVALENT_ID) REFERENCES IDENTITIES(ID) ON DELETE CASCADE;



/* name the rest of unique constraints */

alter table ATTRIBUTE_TYPES drop constraint SYS_CT_49;
alter table ATTRIBUTE_TYPES add constraint attrtype_name_unique UNIQUE(NAME);

alter table AUTHZ_ATTRIBUTE drop constraint SYS_CT_110;
alter table AUTHZ_ATTRIBUTE add constraint authzattr_unique UNIQUE (ATTR_TYPE_ID, ATTR_VALUE, GROUP_ID);

alter table AUTHZ_SPECIAL drop constraint SYS_CT_119;
alter table AUTHZ_SPECIAL add constraint authzspecial_unique UNIQUE (GROUP_ID, SPECIAL);


/* name all FK constraints */

alter table IDENTITIES drop constraint SYS_FK_57;
alter table IDENTITIES drop constraint SYS_FK_58;
alter table IDENTITIES add constraint identities_fk_typeid FOREIGN KEY (TYPEID) REFERENCES IDENTITY_TYPES(ID);
alter table IDENTITIES add constraint identities_fk_entityid FOREIGN KEY (ENTITY_ID) REFERENCES ENTITIES(ID);

alter table GROUPS drop constraint SYS_FK_68;
alter table GROUPS add constraint groups_fk_parentid FOREIGN KEY (PARENT_ID) REFERENCES GROUPS(ID) ON DELETE CASCADE;

alter table GROUP_ATTRIBUTES drop constraint SYS_FK_74;
alter table GROUP_ATTRIBUTES drop constraint SYS_FK_75;
alter table GROUP_ATTRIBUTES add constraint groupattr_fk_groupid FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID);
alter table GROUP_ATTRIBUTES add constraint groupattr_fk_attrtypeid FOREIGN KEY (ATTRTYPE_ID) REFERENCES ATTRIBUTE_TYPES(ID);

alter table ENTITY_ATTRIBUTES drop constraint SYS_FK_82;
alter table ENTITY_ATTRIBUTES drop constraint SYS_FK_83;
alter table ENTITY_ATTRIBUTES drop constraint SYS_FK_84;
alter table ENTITY_ATTRIBUTES add CONSTRAINT entityattributes_fk_entityid FOREIGN KEY (ENTITY_ID) REFERENCES ENTITIES(ID);
alter table ENTITY_ATTRIBUTES add CONSTRAINT entityattributes_fk_attrtypeid FOREIGN KEY (ATTRTYPE_ID) REFERENCES ATTRIBUTE_TYPES(ID);
alter table ENTITY_ATTRIBUTES add CONSTRAINT entityattributes_fk_groupid FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID);

alter table GROUP_ENTITIES drop constraint SYS_FK_94;
alter table GROUP_ENTITIES drop constraint SYS_FK_95;
alter table GROUP_ENTITIES add CONSTRAINT group_entities_fk_entityid FOREIGN KEY (ENTITY_ID) REFERENCES ENTITIES(ID);
alter table GROUP_ENTITIES add CONSTRAINT group_entities_fk_groupid FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID);

alter table GROUP_SUBGROUPS drop constraint SYS_FK_102;
alter table GROUP_SUBGROUPS drop constraint SYS_FK_103;
alter table GROUP_SUBGROUPS add CONSTRAINT groupsubgroups_fk_childid FOREIGN KEY (CHILD_ID) REFERENCES GROUPS(ID);
alter table GROUP_SUBGROUPS add CONSTRAINT groupsubgroups_fk_groupid FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID);

alter table AUTHZ_ATTRIBUTE drop constraint SYS_FK_111;
alter table AUTHZ_ATTRIBUTE drop constraint SYS_FK_112;
alter table AUTHZ_ATTRIBUTE add CONSTRAINT authzattr_fk_groupid FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID);
alter table AUTHZ_ATTRIBUTE add CONSTRAINT authzattr_fk_attrtypeid FOREIGN KEY (ATTR_TYPE_ID) REFERENCES ATTRIBUTE_TYPES(ID);

alter table AUTHZ_SPECIAL drop constraint SYS_FK_120;
alter table AUTHZ_SPECIAL add CONSTRAINT authzspecial_fk_groupid FOREIGN KEY (GROUP_ID) REFERENCES GROUPS(ID);

alter table APPLICATION_FORMS drop constraint SYS_FK_125;
alter table APPLICATION_FORMS add CONSTRAINT applicationforms_fk_basegroupid FOREIGN KEY (BASE_GROUP_ID) REFERENCES GROUPS(ID);

alter table APPLICATIONS drop constraint SYS_FK_130;
alter table APPLICATIONS drop constraint SYS_FK_131;
alter table APPLICATIONS add CONSTRAINT applications_fk_idtypeid FOREIGN KEY (ID_TYPEID) REFERENCES IDENTITY_TYPES(ID);
alter table APPLICATIONS add CONSTRAINT applications_fk_formid FOREIGN KEY (FORM_ID) REFERENCES APPLICATION_FORMS(ID) ON DELETE CASCADE;

/* version */
drop table UVOS_FLAG_;
CREATE TABLE UVOS_FLAG_ (VAL CHAR(128));
INSERT INTO UVOS_FLAG_ (VAL) VALUES ('1_1_0');


/* add missing attribute name definitions */

//INSERT INTO ATTRIBUTE_TYPES (NAME, SHORT_DESC, DESCRIPTION) VALUES 
//	('urn:unicore:attrType:defaultXlogin', 'The default XLogin of the user', 'Value of this attribute, assigned to an entity specifies the XLogin value for incarnation purpouses. In general it should be group scoped, where the group should be created for every VSite with different mappings. This attribute should have only single value. If present this attribute overrides normal xlogin attribute.');
//INSERT INTO ATTRIBUTE_TYPES (NAME, SHORT_DESC, DESCRIPTION) VALUES 
//	('urn:unicore:attrType:role', 'The role(s) of the user', 'Value of this attribute, assigned to an entity specifies the UNICORE role(s) used for authorization purpouses.');
//INSERT INTO ATTRIBUTE_TYPES (NAME, SHORT_DESC, DESCRIPTION) VALUES 
//	('urn:unicore:attrType:defaultRole', 'The default role of the user', 'Value of this attribute, assigned to an entity specifies the default UNICORE role. This attribute should have only single value. It it is present it overrides normal role attribute.');

SHUTDOWN;