/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.util;

import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.jetty.HttpServerProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class UvosHttpServerProperties
extends HttpServerProperties {
    private static final Logger log = Log.getLogger((String)"unicore.configuration", UvosHttpServerProperties.class);
    @DocumentationReferencePrefix
    public static final String PREFIX = "uvos.server.httpServer.";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> defaults = new HashMap<String, PropertyMD>();

    public UvosHttpServerProperties(Properties source, UVOSServerProperties base) throws ConfigurationException {
        super(source, PREFIX, defaults);
        if (this.isSet("requireClientAuthn")) {
            log.warn((Object)("Do not use " + this.getKeyDescription("requireClientAuthn") + " setting, it will be ignored. Use " + base.getKeyDescription("https.allowAnonymous")));
        }
        if (!base.isSet("https.allowAnonymous")) {
            this.setProperty("requireClientAuthn", "false");
        } else {
            this.setProperty("requireClientAuthn", "" + (base.getBooleanValue("https.allowAnonymous") == false));
        }
    }

    static {
        defaults.putAll(HttpServerProperties.defaults);
        defaults.put("useNIO", new PropertyMD("true").setDescription("Controls whether the NIO connector be used. NIO is best suited under high-load, when lots of connections exist that are idle for long periods."));
        defaults.put("requireClientAuthn", new PropertyMD().setHidden());
    }
}

