/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.util;

import eu.unicore.security.canl.AuthnAndTrustProperties;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.util.jetty.HttpServerProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.saml.SAMLConfiguration;
import pl.edu.icm.unicore.uvos.util.UvosHttpServerProperties;

public class UVOSServerProperties
extends FilePropertiesHelper {
    private static final Logger log = Log.getLogger((String)"unicore.configuration", UVOSServerProperties.class);
    public static final String LOG_PFX = "unicore.uvos.server";
    @DocumentationReferencePrefix
    public static final String P = "uvos.server.";
    public static final String HTTPS_ENABLE = "https.enable";
    public static final String HTTPS_PORT = "https.port";
    public static final String HTTPS_HOST = "https.host";
    public static final String HTTPS_ANON = "https.allowAnonymous";
    public static final boolean httpsAnon = true;
    public static final String HTTP_ENABLE = "http.enable";
    public static final String HTTP_PORT = "http.port";
    public static final String HTTP_HOST = "http.host";
    public static final String AUTHN_ORDER = "authn.order";
    public static final String AUTHN_FAIL = "authn.failOnError";
    public static final String AUTHN_TLS_DN_FIRST = "authn.mapTLSCertToDNFirst";
    public static final String ETD = "authn.enableETD";
    public static final String SIGN_RESPONSE = "saml.signResponses";
    public static final String SIGN_ASSERTION = "saml.signAssertions";
    public static final String DEF_ATTR_ASSERTION_VALIDITY = "saml.validityPeriod";
    public static final String SAML_REQUEST_VALIDITY = "saml.requestValidityPeriod";
    public static final String ISSUER_URI = "saml.issuerURI";
    public static final String MAP_CERT_TO_DN = "saml.allowToUseCertificateAsDN";
    public static final String MAIL_CONF = "mailConfig";
    public static final String MAIL_TEMPLATES = "mailTemplates";
    public static final String WEBAPPS_DIR = "webappsDir";
    public static final String ATTRIBUTE_TYPE_FILES = "attributeTypeFiles";
    public static final String ATTRIBUTE_TYPES_UPDATE = "attributeTypeUpdate";
    public static final String REGISTER = "useExternalRegistry";
    public static final String REGISTRY_BASE = "externalRegistryUrl.";
    public static final String EMIR_REGISTRY = "emirRegistry";
    public static final String GENERATE_ATTRIBUTES_FROM_DN = "generateAttributesFromDN";
    public static final String ATTRIBUTE_FILTER_FILE = "saml.attributeFiltersConfig";
    public static final String ATTRIBUTE_FILTER_EXPOSED_ATTRIBUTES = "exposedAttribute";
    public static final String ATTRIBUTE_FILTER_EXCLUDED_ATTRIBUTES = "excludedAttribute";
    public static final String ATTRIBUTE_FILTER_ALLOWED_SCOPE_INFIX = ".scope.";
    public static final String ATTRIBUTE_FILTER_IGNORED_SCOPE_INFIX = ".scope.not.";
    public static final String DBCONFIG_FILE = "db.mapconfigFile";
    public static final String DBPROPERTIES_FILE = "db.datamapPropertiesFile";
    public static final String DBUPDATE_PROPERTIES_FILE = "db.dbUpdatePropertiesFile";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> defaults = new HashMap<String, PropertyMD>();
    private HttpServerProperties jp;
    private IAuthnAndTrustConfiguration authnTrust;
    private IClientConfiguration clientCfg;

    public UVOSServerProperties(String configFile) throws ConfigurationException, IOException {
        super(P, configFile, defaults, log);
        this.jp = new UvosHttpServerProperties(this.properties, this);
        this.authnTrust = new AuthnAndTrustProperties(this.properties, "uvos.server.truststore.", "uvos.server.credential.");
        this.clientCfg = new ClientProperties(this.properties, "uvos.server.client.", this.authnTrust);
    }

    public HttpServerProperties getJettyProperties() {
        return this.jp;
    }

    public IAuthnAndTrustConfiguration getAuthAndTrust() {
        return this.authnTrust;
    }

    public IClientConfiguration getClientConfiguration() {
        return this.clientCfg;
    }

    static {
        PropertyMD.DocumentationCategory mainCat = new PropertyMD.DocumentationCategory("General settings", "1");
        PropertyMD.DocumentationCategory httpsCat = new PropertyMD.DocumentationCategory("Secure HTTPS server settings", "2");
        PropertyMD.DocumentationCategory httpCat = new PropertyMD.DocumentationCategory("Insecure HTTP server settings", "3");
        PropertyMD.DocumentationCategory authnCat = new PropertyMD.DocumentationCategory("Client authentication settings", "4");
        PropertyMD.DocumentationCategory samlCat = new PropertyMD.DocumentationCategory("SAML subsystem settings", "5");
        PropertyMD.DocumentationCategory dbCat = new PropertyMD.DocumentationCategory("Database configuration files", "6");
        PropertyMD.DocumentationCategory otherCat = new PropertyMD.DocumentationCategory("Other", "7");
        defaults.put(ATTRIBUTE_TYPE_FILES, new PropertyMD("conf/attributeTypes/uvosCore.at, conf/attributeTypes/ldap.at").setPath().setCategory(mainCat).setDescription("A specification of files with definitions of attribute types that the server should load on startup. Comment it out if you don't want this behaviour. Note that, you can specify multiple files separated by ', ' (comma and space)."));
        defaults.put(ATTRIBUTE_TYPES_UPDATE, new PropertyMD("false").setCategory(mainCat).setDescription("If set to false then only new attribute types present in file will be added to DB. Otherwise (update=true) the types that exist in DB will have their descriptions updated."));
        defaults.put(REGISTER, new PropertyMD("false").setCategory(mainCat).setDescription("If set to true server will register its SAMLAttributeQuery service in one or more UNICORE registries (defined by properties uvos.server.externalRegistryUrl.?)."));
        defaults.put(REGISTRY_BASE, new PropertyMD().setList(true).setCategory(mainCat).setDescription("Registry address. You can define more than one using numeric subkeys."));
        defaults.put(EMIR_REGISTRY, new PropertyMD().setCategory(mainCat).setDescription("EMI Registry address in the form http(s)://host:port. If this option is left undefined then EMI registry won't be used."));
        defaults.put(MAIL_CONF, new PropertyMD("conf/mail.properties").setPath().setCategory(mainCat).setDescription("A configuration file for the mail notification subsystem."));
        defaults.put(MAIL_TEMPLATES, new PropertyMD("conf/mailTemplates.properties").setPath().setCategory(mainCat).setDescription("A file containing templates of email notification messages sent when various UVOS events occur."));
        defaults.put(WEBAPPS_DIR, new PropertyMD("./webapps").setPath().setCategory(mainCat).setDescription("Directory from which UVOS extensions in a form of web applications (war) are loaded."));
        defaults.put(GENERATE_ATTRIBUTES_FROM_DN, new PropertyMD("false").setCategory(mainCat).setDescription("If set to true, UVOS will try to parse DN of a user being added (in case of DN or X.509 Certificate identities) and automatically assign extracted attributes as global UVOS attributes of the user."));
        defaults.put(HTTPS_ANON, new PropertyMD("true").setCategory(httpsCat).setDescription("If set to true then unauthenticated client connection via HTTPS will be accepted (and, if possible, authenticated using other means like HTTP BASIC auth)."));
        defaults.put(HTTPS_ENABLE, new PropertyMD("true").setCategory(httpsCat).setDescription("Enables or disables using the HTTPS port. Note that HTTPS is the recommended transport mechanism."));
        defaults.put(HTTPS_HOST, new PropertyMD("localhost").setCategory(httpsCat).setDescription("The hostname or IP address for HTTPS connections."));
        defaults.put(HTTPS_PORT, new PropertyMD("2443").setBounds(1L, 65535L).setCategory(httpsCat).setDescription("The HTTPS port to be used."));
        defaults.put(HTTP_ENABLE, new PropertyMD("false").setCategory(httpCat).setDescription("Enables or disables the HTTPS port. It is NOT recommended to use this transport mechanism as it doesn't provide encryption."));
        defaults.put(HTTP_HOST, new PropertyMD("localhost").setCategory(httpCat).setDescription("The hostname or IP address for HTTP connections."));
        defaults.put(HTTP_PORT, new PropertyMD("2020").setBounds(1L, 65535L).setCategory(httpCat).setDescription("The HTTP port to be used."));
        defaults.put(AUTHN_FAIL, new PropertyMD("true").setCategory(authnCat).setDescription("If set to true then authentication will fail if validation of one of the PRESENT authentication data fails. Otherwise the authN process will continue, checking the next possible authentication data source."));
        defaults.put(AUTHN_ORDER, new PropertyMD("TLS HTTP").setCategory(authnCat).setDescription("Defines the order in which authentication sources should be used. Details are provided in the documentation (authentication configuration section)."));
        defaults.put(AUTHN_TLS_DN_FIRST, new PropertyMD("false").setCategory(authnCat).setDescription("If set to true and validation of some of PRESENT authentication data fails then authentication will fail. Otherwise authN process will be continued, checking the next possible authentication data source."));
        defaults.put(ETD, new PropertyMD("true").setCategory(authnCat).setDescription("Whether to enable Explicit Trust Delegation."));
        defaults.put(ATTRIBUTE_FILTER_FILE, new PropertyMD("conf/attributeFilters.properties").setPath().setCategory(samlCat).setDescription("Specifies what file is used to provide filters defining which attributes are exposed by the SAML attribute query interface."));
        defaults.put(SAML_REQUEST_VALIDITY, new PropertyMD("120").setPositive().setCategory(samlCat).setDescription("Defines maximum validity period (in seconds) of a SAML request. Requests older than this value are denied. It also controls the validity of an authentication assertion."));
        defaults.put(SIGN_ASSERTION, new PropertyMD((Enum)SAMLConfiguration.AssertionSigningPolicy.always).setCategory(samlCat).setDescription("Defines when SAML assertions, that are put in responses, should be signed. The 'ifResponseUnsigned' will result in signing only those assertions which are sent in an unsigned response. Note that several SAML profiles mandates signing assertions so it is best to set it to 'always'."));
        defaults.put(SIGN_RESPONSE, new PropertyMD((Enum)SAMLConfiguration.ResponseSigningPolicy.asRequest).setCategory(samlCat).setDescription("Defines when SAML responses should be signed. Note that it is not related to signing SAML assertions which are included in response. 'asRequest' setting will result in signing only those responses for which the corresponding request was signed."));
        defaults.put(DEF_ATTR_ASSERTION_VALIDITY, new PropertyMD("14400").setPositive().setCategory(samlCat).setDescription("Controls the maximum validity period of an attribute assertion returned to client (in seconds). It is inserted whenever query is compliant with 'SAML V2.0 Deployment Profiles for X.509 Subjects', what usually is the case."));
        defaults.put(MAP_CERT_TO_DN, new PropertyMD("true").setCategory(samlCat).setDescription("Enables or disables mapping of X509-type identities to DN-type identities in case of SAML queries. See documentation for details."));
        defaults.put(ISSUER_URI, new PropertyMD().setCategory(samlCat).setDescription("This property controls the server's URI which is inserted into SAML responses (the Issuer field). It should be a unique URI which identifies the server. The best approach is to use the server's URL . If absent the server will try to autogenerate one."));
        defaults.put(DBCONFIG_FILE, new PropertyMD("conf/db/mapconfig.xml").setPath().setCategory(dbCat).setDescription("Path of the database configuration file."));
        defaults.put(DBPROPERTIES_FILE, new PropertyMD("conf/datamap.properties").setPath().setCategory(dbCat).setDescription("Path of the file with the highly advanced database settings."));
        defaults.put(DBUPDATE_PROPERTIES_FILE, new PropertyMD("conf/db/dbUpdate/update.properties").setPath().setCategory(dbCat).setDescription("Path of the file with configuartion used during database update from the older UVOS version. Otherwise unused."));
        defaults.put("truststore.", new PropertyMD().setCanHaveSubkeys().setCategory(otherCat).setDescription("Properties starting with this prefix are used to configure server's trust settings and certificate validation. See separate documentation for details."));
        defaults.put("credential.", new PropertyMD().setCanHaveSubkeys().setCategory(otherCat).setDescription("Properties starting with this prefix are used to configure server's credential. See separate documentation for details."));
        defaults.put("httpServer.", new PropertyMD().setCanHaveSubkeys().setCategory(otherCat).setDescription("Properties starting with this prefix are used to configure Jetty HTTP server advanced settings. See separate documentation for details."));
        defaults.put("client.", new PropertyMD().setCanHaveSubkeys().setCategory(otherCat).setDescription("Properties starting with this prefix are used to configure HTTP client settings, when UVOS server performs client calls (what happens very rarely e.g. when registering in registry). See separate documentation for details."));
    }
}

