/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.util;

import eu.unicore.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import pl.edu.icm.unicore.uvos.util.FileWatcher;

public class LogFileWatcher {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", LogFileWatcher.class);

    public static void startLogConfigWatcher(ScheduledExecutorService timer) {
        final String logConfig = System.getProperty("log4j.configuration");
        if (logConfig == null) {
            log.warn((Object)"No logger configuration found");
            return;
        }
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    log.info((Object)"LOG CONFIG MODIFIED, re-configuring.");
                    PropertyConfigurator.configure((String)logConfig);
                }
            };
            File logProperties = logConfig.startsWith("file:/") ? new File(new URI(logConfig)) : new File(logConfig);
            FileWatcher fw = new FileWatcher(logProperties, r);
            timer.scheduleWithFixedDelay(fw, 5L, 5L, TimeUnit.SECONDS);
        }
        catch (FileNotFoundException fex) {
            log.warn((Object)("Log configuration file <" + logConfig + "> not found."));
        }
        catch (URISyntaxException e) {
            log.warn((Object)("Location of log configuration is not a valid URI: '" + logConfig + "'"));
        }
    }
}

