/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.util;

import antlr.TokenStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import pl.edu.icm.schemaparser.LDAPAttributeType;
import pl.edu.icm.schemaparser.generated.LdapLexer;
import pl.edu.icm.schemaparser.generated.LdapParser;

class LdapSchemaParser {
    private static final String info = "\nThis program invokes a LDAP schema parser on its standard input. After parsing the input all attribute types (object classess are ignored) are printed to standard output in a format suitable for UVOS. UVOS server can read the output (quickly) upon startup and add new attribute types to its DB.";

    LdapSchemaParser() {
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            System.out.println(info);
            System.exit(0);
        }
        try {
            LdapLexer lexer = new LdapLexer((Reader)new InputStreamReader(System.in));
            LdapParser parser = new LdapParser((TokenStream)lexer);
            List parsed = parser.startRule();
            for (LDAPAttributeType at : parsed) {
                String atSDesc;
                List names = at.getNames();
                String atName = (String)names.get(0);
                if (names.size() > 1) {
                    int longest = 1;
                    if (((String)names.get(0)).length() > ((String)names.get(1)).length()) {
                        longest = 0;
                    }
                    atName = (String)names.get((longest + 1) % 2);
                    atSDesc = (String)names.get(longest);
                } else {
                    atSDesc = at.getDesc();
                }
                String atDesc = at.getDesc() + "\\nThis attribute is equivalent to LDAP one with OID: " + at.getOid();
                System.out.println("AT\n" + atName + "\n" + atSDesc + "\n" + atDesc + "\n");
            }
        }
        catch (Exception e) {
            System.err.println("exception: " + e);
        }
    }
}

