/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.util;

import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.unicore.util.Log;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import xmlbeans.pl.edu.icm.uvos.glue2.EndpointHealthStateT;
import xmlbeans.pl.edu.icm.uvos.glue2.EndpointT;
import xmlbeans.pl.edu.icm.uvos.glue2.QualityLevelT;
import xmlbeans.pl.edu.icm.uvos.glue2.ServiceT;
import xmlbeans.pl.edu.icm.uvos.glue2.ServingStateT;

public class GLUEInfoProvider {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", GLUEInfoProvider.class);
    public static final String UVOS_HUMAN_NAME = "UNICORE Virtual Organisations Service (UVOS)";
    public static final String UVOS_SERVICE_TYPE = "unicore6.UVOSAssertionQueryService";
    public static final String EMI_VERSION_FILE = "/etc/emi-version";
    public static final String ASSERTION_QUERY_ENDPOINT = "/UVOSAssertionQueryService";
    private String baseURL;

    public GLUEInfoProvider(UVOSServerProperties conf) {
        boolean ssl = conf.getBooleanValue("https.enable");
        this.baseURL = ssl ? "https://" + conf.getValue("https.host") + ":" + conf.getValue("https.port") : "http://" + conf.getValue("http.host") + ":" + conf.getValue("http.port");
    }

    public GLUEInfoProvider(String baseUrl) {
        this.baseURL = baseUrl;
    }

    public ServiceT getServiceDesc() {
        ServiceT st = ServiceT.Factory.newInstance();
        st.setID(this.baseURL);
        st.setName(UVOS_HUMAN_NAME);
        st.setQualityLevel(QualityLevelT.PRODUCTION);
        st.setType(UVOS_SERVICE_TYPE);
        st.setEndpointArray(new EndpointT[]{this.getServiceendpointDesc()});
        return st;
    }

    public String getServiceId() {
        return this.baseURL + ASSERTION_QUERY_ENDPOINT;
    }

    private EndpointT getServiceendpointDesc() {
        EndpointT et = EndpointT.Factory.newInstance();
        et.setID(this.getServiceId());
        et.setURL(this.baseURL + ASSERTION_QUERY_ENDPOINT);
        et.setQualityLevel(QualityLevelT.PRODUCTION);
        et.setHealthState(EndpointHealthStateT.OK);
        et.setServingState(ServingStateT.PRODUCTION);
        String uVersion = this.getClass().getPackage().getSpecificationVersion();
        if (uVersion == null) {
            uVersion = "DEVELOPMENT";
        }
        et.addInterfaceVersion(uVersion);
        et.setImplementationName("UVOS");
        et.setImplementationVersion(uVersion);
        et.setInterfaceName("UVOS");
        et.setCapabilityArray(new String[]{"security.attributeauthority"});
        et.setTechnology("webservice");
        File emiFile = new File(EMI_VERSION_FILE);
        if (emiFile.exists() && emiFile.canRead()) {
            try {
                String emiVersion = FileUtils.readFileToString((File)emiFile);
                et.addOtherInfo("MiddlewareName=EMI");
                et.addOtherInfo("MiddlewareVersion=" + emiVersion);
            }
            catch (IOException ex) {
                log.warn((Object)"Can't read emi version.", (Throwable)ex);
            }
        }
        return et;
    }

    public JSONArray getEndpointDescription() throws JSONException {
        EndpointT[] endpoints;
        ServiceT glue = this.getServiceDesc();
        JSONObject serdelek = new JSONObject();
        serdelek.put(ServiceBasicAttributeNames.SERVICE_ID.toString(), (Object)glue.getID());
        serdelek.put(ServiceBasicAttributeNames.SERVICE_NAME.toString(), (Object)glue.getName());
        serdelek.put(ServiceBasicAttributeNames.SERVICE_TYPE.toString(), (Object)glue.getType());
        serdelek.put(ServiceBasicAttributeNames.SERVICE_QUALITYLEVEL.toString(), (Object)glue.getQualityLevel().toString());
        for (EndpointT endpoint : endpoints = glue.getEndpointArray()) {
            serdelek.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.toString(), (Object)endpoint.getID());
            serdelek.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.toString(), (Object)endpoint.getURL());
            JSONArray endpCap = new JSONArray();
            for (String cap : endpoint.getCapabilityArray()) {
                endpCap.put((Object)cap);
            }
            serdelek.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.toString(), (Object)endpCap);
            serdelek.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_TECHNOLOGY.toString(), (Object)endpoint.getTechnology());
            serdelek.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.toString(), (Object)endpoint.getInterfaceName());
            serdelek.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACE_VER.toString(), (Object)endpoint.getInterfaceVersionArray()[0]);
            serdelek.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IMPL_NAME.toString(), (Object)endpoint.getImplementationName());
            serdelek.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IMPL_VERSION.toString(), (Object)endpoint.getImplementationVersion());
            serdelek.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_HEALTH_STATE.toString(), (Object)endpoint.getHealthState());
            serdelek.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_SERVING_STATE.toString(), (Object)endpoint.getServingState());
        }
        JSONArray array = new JSONArray();
        array.put((Object)serdelek);
        return array;
    }
}

