/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.engine.VirtualSecurityContextImpl;
import pl.edu.icm.unicore.uvos.engine.api.UVOSManagementInterface;
import pl.edu.icm.unicore.uvos.server.ComponentContainer;
import pl.edu.icm.unicore.uvos.server.idresolver.Authenticator;
import pl.edu.icm.unicore.uvos.util.AttributeTypesLoader;

public class ExampleContentCreator {
    public static final String SAMPLE_DN1 = "CN=Example Client,OU=Example OU,O=Example O,L=Example City,ST=Example Province,C=PL";
    public static final String SAMPLE_DN2 = "CN=Example Client 2,OU=Example OU,O=Example O,L=Example City,ST=Example Province,C=PL";
    private static String dn;
    private static String cert;
    private static String njsdn;
    private static String demoClientDn;

    public static void main(String[] args) {
        try {
            String configFile = "conf/uvosServer.conf";
            if (args.length > 0) {
                configFile = args[0];
            }
            ComponentContainer container = new ComponentContainer(configFile);
            String certFile = "conf/certs/demoadmin.pem";
            if (args.length > 1) {
                certFile = args[1];
            }
            ExampleContentCreator.readCert(certFile);
            AttributeTypesLoader attributeLoader = container.getComponent(AttributeTypesLoader.class);
            attributeLoader.load();
            UVOSManagementInterface voMan = container.getComponent(UVOSManagementInterface.class);
            Authenticator.injectFakeContext(new VirtualSecurityContextImpl(Permissions.ALL_P));
            System.out.println("Creating groups");
            Group math = voMan.addGroup(null, "Math-VO");
            Group staff = voMan.addGroup(math, "Staff");
            Group admins = voMan.addGroup(staff, "Admins");
            Group scientists = voMan.addGroup(math, "Scientists");
            Group uudb = voMan.addGroup(math, "UUDB");
            Group siteA = voMan.addGroup(uudb, "SiteA");
            Group siteB = voMan.addGroup(uudb, "SiteB");
            Group qsar = voMan.addGroup(null, "QSAR-VO");
            System.out.println("Creating identities");
            Identity uExample = new Identity(IdentityType.DN, dn, "UnicoreAdmin");
            Identity uExampleCert = new Identity(IdentityType.X509CERT, cert);
            Identity uTestNJS = new Identity(IdentityType.DN, njsdn, "UnicoreTestNJS");
            Identity uDemoClient = new Identity(IdentityType.DN, demoClientDn, "UnicoreDemoClient");
            Identity sampleClient1 = new Identity(IdentityType.DN, SAMPLE_DN1);
            Identity sampleClient2 = new Identity(IdentityType.DN, SAMPLE_DN2);
            Identity eve = new Identity(IdentityType.EMAIL, "eve@example.com", "Eve");
            Identity amy = new Identity(IdentityType.EMAIL, "amy@example.com", "Amy");
            Identity amy2 = new Identity(IdentityType.EMAIL, "amy_kk@example.org", "Amy");
            Identity amyDN = new Identity(IdentityType.DN, "cn=Amy, ou=ICM, c=PL");
            Identity ben = new Identity(IdentityType.EMAIL, "ben@example.com", "Ben");
            Identity andrew = new Identity(IdentityType.DN, "cn=Andrew, ou=ICM, c=PL", "Andrew");
            Identity chris = new Identity(IdentityType.EMAIL, "chris@example.com", "Chris");
            Identity benDN = new Identity(IdentityType.DN, "cn=Ben, ou=ICM, c=PL");
            Identity tom = new Identity(IdentityType.DN, "cn=Tom, ou=ICM, c=PL", "Tom");
            voMan.addIdentity(uExample);
            voMan.addIdentity(uExampleCert, uExample);
            voMan.addIdentity(uTestNJS);
            voMan.addIdentity(uDemoClient);
            voMan.addIdentity(sampleClient1);
            voMan.addIdentity(sampleClient2);
            voMan.addIdentity(eve);
            voMan.addIdentity(amy);
            voMan.addIdentity(amyDN, amy);
            voMan.addIdentity(amy2, amy);
            voMan.addIdentity(ben);
            voMan.addIdentity(andrew);
            voMan.addIdentity(chris);
            voMan.addIdentity(benDN, ben);
            voMan.addIdentity(tom);
            System.out.println("Adding to groups");
            voMan.addToGroup(uExample, admins);
            voMan.addToGroup(eve, admins);
            voMan.addToGroup(amy, admins);
            voMan.addToGroup(ben, staff);
            voMan.addToGroup(ben, scientists);
            voMan.addToGroup(sampleClient1, scientists);
            voMan.addToGroup(andrew, scientists);
            voMan.addToGroup(chris, scientists);
            voMan.addToGroup(benDN, qsar);
            voMan.addToGroup(tom, qsar);
            voMan.addToGroup(sampleClient2, qsar);
            voMan.addToGroup(uExampleCert, qsar);
            voMan.addToGroup(uExampleCert, siteA);
            voMan.addToGroup(sampleClient1, siteA);
            voMan.addToGroup(uExampleCert, siteB);
            voMan.addToGroup(uDemoClient, siteA);
            System.out.println("Setting attributes");
            Element uExInUudb = new Element(siteA, uExample);
            voMan.setAttribute(uExInUudb, new Attribute(AttributeType.XLOGIN_AT, Collections.singletonList("nobody"), null), true);
            Element uExInUudb2 = new Element(siteB, uExample);
            voMan.setAttribute(uExInUudb2, new Attribute(AttributeType.XLOGIN_AT, Collections.singletonList("guest"), null), true);
            voMan.setAttribute(new Element(admins, null), new Attribute(AttributeType.DEF_AUTHZ_AT, Collections.singletonList("write"), null), true);
            voMan.setAttribute(new Element(null, uExample), new Attribute(AttributeType.DEF_AUTHZ_AT, Collections.singletonList("write"), null), true);
            voMan.setAttribute(new Element(null, sampleClient1), new Attribute(AttributeType.DEF_AUTHZ_AT, Collections.singletonList("identityCtl"), null), true);
            voMan.setAttribute(new Element(siteA, sampleClient1), new Attribute(AttributeType.XLOGIN_AT, Collections.singletonList("johnny"), null), true);
            voMan.setAttribute(new Element(null, sampleClient2), new Attribute(AttributeType.DEF_AUTHZ_AT, Collections.singletonList("read"), null), true);
            voMan.setAttribute(new Element(null, uTestNJS), new Attribute(AttributeType.DEF_AUTHZ_AT, Collections.singletonList("read"), null), true);
            ArrayList<String> vals = new ArrayList<String>();
            vals.add("account1");
            vals.add("account2");
            vals.add("nobody");
            vals.add("guest");
            voMan.setAttribute(new Element(siteA, uDemoClient), new Attribute(AttributeType.XLOGIN_AT, vals, null), true);
            voMan.setAttribute(new Element(siteA, uDemoClient), new Attribute(AttributeType.DEF_XLOGIN_AT, Collections.singletonList("nobody"), null), true);
            vals.clear();
            vals.add("role1");
            vals.add("role2");
            vals.add("user");
            vals.add("role3");
            voMan.setAttribute(new Element(siteA, uDemoClient), new Attribute(AttributeType.ROLE_AT, vals, null), true);
            voMan.setAttribute(new Element(siteA, uDemoClient), new Attribute(AttributeType.DEF_ROLE_AT, Collections.singletonList("user"), null), true);
            vals = new ArrayList();
            vals.add("6");
            vals.add("1980");
            vals.add("11");
            voMan.setAttribute(new Element(staff, amy), new Attribute("favouriteNumbers", vals, null), true);
            vals.clear();
            vals.add("90");
            vals.add("900");
            voMan.setAttribute(new Element(null, amy), new Attribute("favouriteNumbers", vals, null), true);
            voMan.setAttribute(new Element(admins, amy), new Attribute("favouriteNumbers", null, null), true);
            voMan.setAttribute(new Element(scientists, sampleClient1), new Attribute("favouriteNumbers", vals, null), true);
            DB db = container.getComponent(DB.class);
            db.shutdown();
        }
        catch (Exception e) {
            System.err.println("Error occured:");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readCert(String file) throws Exception {
        byte[] buf;
        FileInputStream fis = new FileInputStream(file);
        try {
            buf = new byte[fis.available()];
            fis.read(buf);
        }
        finally {
            fis.close();
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        Collection<? extends Certificate> certs = factory.generateCertificates(bais);
        X509Certificate c = (X509Certificate)certs.iterator().next();
        dn = c.getSubjectX500Principal().getName();
        cert = new String(buf);
    }

    static {
        njsdn = "EMAILADDRESS=unicore-support@lists.sf.net, C=DE, O=unicore.eu, OU=Testing, CN=UNICORE demo unicorex";
        demoClientDn = "EMAILADDRESS=unicore-support@lists.sf.net, C=DE, O=unicore.eu, OU=Testing, CN=UNICORE demo user";
    }
}

