/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.util;

import eu.unicore.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.db.DBAttributeTypes;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class AttributeTypesLoader {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", AttributeTypesLoader.class);
    private List<String> files;
    private boolean doUpdate;
    private List<AttributeType> parsedTypes;
    private DBAttributeTypes attributeTypes;
    private DB db;

    public AttributeTypesLoader(DB db, UVOSServerProperties conf, DBAttributeTypes attributeTypes) {
        this.db = db;
        this.attributeTypes = attributeTypes;
        this.doUpdate = conf.getBooleanValue("attributeTypeUpdate");
        String filesRaw = conf.getValue("attributeTypeFiles");
        String[] filesA = filesRaw.split(",( )+");
        StringBuffer filesS = new StringBuffer();
        boolean parse = false;
        this.files = new ArrayList<String>();
        for (String f : filesA) {
            if (filesS.length() > 0) {
                filesS.append(", ");
            }
            if (f.equals("")) continue;
            this.files.add(f);
            filesS.append(f);
            parse = true;
        }
        if (parse) {
            log.info((Object)("Will read attribute types from files: " + filesS + ". Existing attribute" + " types will be updated: " + this.doUpdate));
        }
        this.parsedTypes = new ArrayList<AttributeType>();
    }

    public void load() {
        for (String file : this.files) {
            File f = new File(file);
            if (f.exists() && f.canRead()) {
                try {
                    this.processFile(f);
                }
                catch (IOException e) {
                    log.warn((Object)("IO error when processing an attribute types file: " + file + ": " + e));
                }
                continue;
            }
            log.warn((Object)("The attribute type file " + file + " doesn't exists or can't be read."));
        }
        this.addToDB();
    }

    private void processFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (line.equals("AT")) {
                this.processBlock(reader);
            }
            if (!line.equals("")) continue;
        }
    }

    private void processBlock(BufferedReader reader) throws IOException {
        String atName = reader.readLine();
        String atSDesc = reader.readLine();
        String atDesc = reader.readLine();
        if (atName == null || atSDesc == null || atDesc == null) {
            throw new IOException("Unexpected end of file: AT is incomplete.");
        }
        atDesc = atDesc.replace("\\n", "\n");
        AttributeType at = new AttributeType(atName, atSDesc, atDesc);
        this.parsedTypes.add(at);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDB() {
        List<AttributeType> existing = this.attributeTypes.getAttributeTypes();
        HashSet<String> existingSet = new HashSet<String>();
        for (AttributeType at : existing) {
            existingSet.add(at.getName());
        }
        SqlSession session = this.db.getSqlSession();
        try {
            for (AttributeType at : this.parsedTypes) {
                boolean exists = existingSet.contains(at.getName());
                if (exists && !this.doUpdate) continue;
                try {
                    if (exists) {
                        this.attributeTypes.updateAttrType(at, session);
                        continue;
                    }
                    this.attributeTypes.addAttrType(at, session);
                }
                catch (InternalException e) {
                    log.warn((Object)("Can't add/update attribute type " + at + " reason: " + (Object)((Object)e)));
                }
            }
        }
        finally {
            session.commit();
            this.db.releaseSqlSession(session);
        }
    }
}

