/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.saml;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.exceptions.SAMLRequestException;
import eu.unicore.util.Log;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.saml.SAMLAttributeQueryUtil;
import pl.edu.icm.unicore.uvos.server.idresolver.Authenticator;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;

public class SAMLX509QueryProfile {
    private long defValidity;
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", SAMLX509QueryProfile.class);

    public SAMLX509QueryProfile(UVOSServerProperties conf) {
        this.defValidity = conf.getIntValue("saml.validityPeriod").intValue();
        this.defValidity *= 1000L;
    }

    public void handleX509Profile(SAMLAttributeQueryUtil samlUtil, Assertion assertion) throws SAMLProtocolException {
        Mode mode = this.checkX509Profile(samlUtil);
        log.debug((Object)("Request will be processed in accordance to the profile: " + (Object)((Object)mode)));
        this.setTimeConditions(mode, assertion);
        this.setAudienceRestriciton(mode, samlUtil, assertion);
        this.setSubjectConfirmation(mode, assertion);
        if (mode == Mode.X509_SELF_QUERY_PROFILE) {
            samlUtil.setEnforceSignAssertion(true);
        }
    }

    private Mode checkX509Profile(SAMLAttributeQueryUtil samlUtil) throws SAMLRequestException {
        X509Certificate certFromAuthN = Authenticator.getAuthNCert();
        if (certFromAuthN == null) {
            return Mode.NO_X509_PROFILE;
        }
        String authedDN = certFromAuthN.getSubjectX500Principal().getName();
        Identity subject = samlUtil.getSubjectIdentity();
        if (!subject.getType().equals((Object)IdentityType.DN)) {
            return Mode.NO_X509_PROFILE;
        }
        String subjectDN = subject.getValue();
        NameIDType issuer = samlUtil.getRequestIssuerRaw();
        String issuerFormat = issuer.getFormat();
        boolean isDNIssuer = false;
        boolean isSystemEntityIssuer = false;
        if (issuerFormat == null || issuerFormat.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity") || issuerFormat.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified")) {
            try {
                new URI(issuer.getStringValue());
                isSystemEntityIssuer = true;
            }
            catch (URISyntaxException e) {}
        } else if (issuerFormat.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName")) {
            isDNIssuer = true;
        }
        if (isSystemEntityIssuer) {
            return Mode.X509_QUERY_PROFILE;
        }
        if (!isDNIssuer) {
            return Mode.NO_X509_PROFILE;
        }
        String issuerDN = issuer.getStringValue();
        if (this.safeEqualsDN(issuerDN, subjectDN) && this.safeEqualsDN(issuerDN, authedDN)) {
            return Mode.X509_SELF_QUERY_PROFILE;
        }
        return Mode.NO_X509_PROFILE;
    }

    private boolean safeEqualsDN(String dn1, String dn2) throws SAMLRequestException {
        try {
            return X500NameUtils.equal((String)dn1, (String)dn2);
        }
        catch (IllegalArgumentException e) {
            throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipial", e.getMessage());
        }
    }

    private void setTimeConditions(Mode mode, Assertion assertion) throws SAMLProtocolException {
        if (mode == Mode.NO_X509_PROFILE) {
            return;
        }
        X509Certificate certFromAuthN = Authenticator.getAuthNCert();
        Date start = new Date();
        try {
            certFromAuthN.checkValidity(start);
        }
        catch (CertificateException e) {
            throw new SAMLProtocolException("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "The issuer's certificate is expired");
        }
        Date endCert = certFromAuthN.getNotAfter();
        Date end = new Date(this.defValidity + System.currentTimeMillis());
        if (end.after(endCert)) {
            end = endCert;
        }
        assertion.setTimeConditions(start, end);
    }

    private void setAudienceRestriciton(Mode mode, SAMLAttributeQueryUtil samlUtil, Assertion assertion) {
        if (mode != Mode.X509_QUERY_PROFILE) {
            return;
        }
        NameIDType issuer = samlUtil.getRequestIssuerRaw();
        assertion.setAudienceRestriction(new String[]{issuer.getStringValue()});
    }

    private void setSubjectConfirmation(Mode mode, Assertion assertion) throws SAMLProtocolException {
        if (mode == Mode.NO_X509_PROFILE || mode == Mode.X509_QUERY_PROFILE) {
            return;
        }
        X509Certificate certFromAuthN = Authenticator.getAuthNCert();
        try {
            assertion.setHolderOfKeyConfirmation(new X509Certificate[]{certFromAuthN});
        }
        catch (CertificateEncodingException e) {
            throw new SAMLProtocolException("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Problem occured when encoding issuer's certificate back into assertion");
        }
    }

    private static enum Mode {
        NO_X509_PROFILE,
        X509_QUERY_PROFILE,
        X509_SELF_QUERY_PROFILE;

    }
}

