/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.saml;

import eu.unicore.samly2.SAMLConstants;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.exceptions.SAMLRequestException;
import eu.unicore.samly2.proto.AssertionResponse;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.ElementNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.SecurityException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.api.UVOSQueryInterface;
import pl.edu.icm.unicore.uvos.saml.SAMLAttributeQueryUtil;
import pl.edu.icm.unicore.uvos.saml.SAMLConfiguration;
import pl.edu.icm.unicore.uvos.server.IssuerIdentityProvider;
import pl.edu.icm.unicore.uvos.server.idresolver.Authenticator;
import pl.edu.icm.unicore.uvos.server.idresolver.IdResolveException;
import pl.edu.icm.unicore.uvos.server.saml.AttributeConverter;
import pl.edu.icm.unicore.uvos.server.saml.SAMLX509QueryProfile;
import pl.edu.icm.unicore.uvos.util.AttributeFilter;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLQueryInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLXMLBeansMapper;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.protocol.AttributeQueryDocument;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;

@WebService(endpointInterface="pl.edu.icm.unicore.uvos.wsapi.SAMLQueryInterface")
public class SAMLQueryImpl
implements SAMLQueryInterface {
    private UVOSQueryInterface voQuery;
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", SAMLQueryImpl.class);
    private int reqValidity;
    private UVOSServerProperties conf;
    private IssuerIdentityProvider cryptoProvider;
    private Authenticator authenticator;
    private InternalAuthorization authz;
    private SAMLX509QueryProfile samlQueryProfile;
    private AttributeFilter attribFilter;
    private SAMLConfiguration samlConfiguration;

    public SAMLQueryImpl(UVOSQueryInterface voQuery, UVOSServerProperties conf, IssuerIdentityProvider cryptoProvider, Authenticator authenticator, InternalAuthorization authz, SAMLX509QueryProfile samlQueryProfile, AttributeFilter attribFilter, SAMLConfiguration samlConfig) {
        this.samlConfiguration = samlConfig;
        this.voQuery = voQuery;
        this.conf = conf;
        this.cryptoProvider = cryptoProvider;
        this.authenticator = authenticator;
        this.authz = authz;
        this.samlQueryProfile = samlQueryProfile;
        this.attribFilter = attribFilter;
        this.reqValidity = conf.getIntValue("saml.requestValidityPeriod");
    }

    public ResponseDocument attributeQuery(AttributeQueryDocument reqDoc) throws UVOSFault {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Processing request:\n" + reqDoc.xmlText(new XmlOptions().setSavePrettyPrint())));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Processing SAML attribute query");
        }
        SAMLAttributeQueryUtil samlUtil = new SAMLAttributeQueryUtil(reqDoc, this.cryptoProvider, this.conf, this.samlConfiguration);
        try {
            this.authenticator.resolve();
            samlUtil.parse();
            samlUtil.checkRequestValidity(this.reqValidity);
        }
        catch (IdResolveException e) {
            log.debug((Object)"UVOS engine problem while processing SAML request (authN stage )", (Throwable)((Object)e));
            throw new UVOSFault((UVOSException)e);
        }
        catch (UVOSException e) {
            log.debug((Object)("Authentication FAILED: " + (Object)((Object)e)));
            String info = "Authentication failed: " + (e.getMessage() == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getMessage());
            return samlUtil.getErrorResponse((UVOSException)((Object)new AuthenticationException()), info).getDoc();
        }
        catch (SAMLProtocolException e) {
            log.debug((Object)("Parsing the SAML request FAILED: " + (Object)((Object)e)));
            return samlUtil.getErrorResponse(e).getDoc();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsed SAML request. Issuer: " + samlUtil.getRequestIssuerRaw().getStringValue() + "\nSubject: " + samlUtil.getSubject().getXBean().getNameID().getStringValue()));
        }
        AssertionResponse resp = samlUtil.getOKResponseDocument();
        Assertion assertion = new Assertion();
        assertion.setIssuer(samlUtil.getIssuer().getXBean());
        assertion.setSubject(samlUtil.getSubject().getXBean());
        try {
            this.samlQueryProfile.handleX509Profile(samlUtil, assertion);
        }
        catch (SAMLProtocolException e) {
            log.debug((Object)("Error while applying SAML query profile for X.509 subjects: " + (Object)((Object)e)));
            return samlUtil.getErrorResponse(e).getDoc();
        }
        Element subElement = samlUtil.getSubjectElement();
        try {
            Identity effectiveId = this.authz.mapIfNeededToX509(subElement.getIdentity());
            subElement.setIdentity(effectiveId);
        }
        catch (UVOSException e2) {
            log.debug((Object)("Query subject is unknown: " + (Object)((Object)e2)));
            return samlUtil.getErrorResponse(e2).getDoc();
        }
        try {
            if (!this.authz.isActive(subElement.getIdentity())) {
                log.debug((Object)("Denying request about disabled entity " + subElement.getIdentity()));
                SAMLRequestException e = new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipial", "Query subject is unknown");
                return samlUtil.getErrorResponse((SAMLProtocolException)((Object)e)).getDoc();
            }
        }
        catch (UVOSException e1) {
            log.debug((Object)("Query subject is unknown: " + (Object)((Object)e1)));
            return samlUtil.getErrorResponse(e1).getDoc();
        }
        AttributeType[] queriedAttrs = samlUtil.getQueriedAttributes();
        AttributeConverter attrsConverter = new AttributeConverter();
        try {
            if (queriedAttrs == null || queriedAttrs.length == 0) {
                this.getAllAttributes(subElement, attrsConverter);
            } else {
                for (AttributeType attrToGet : queriedAttrs) {
                    this.getAttribute(subElement, attrToGet, attrsConverter);
                }
            }
            attrsConverter.injectAttributes(assertion);
        }
        catch (UVOSException e) {
            log.debug((Object)("Error in processing query: " + (Object)((Object)e)));
            return samlUtil.getErrorResponse(e).getDoc();
        }
        catch (SAMLRequestException e) {
            log.debug((Object)("SAML request processing failed while parsing: " + (Object)((Object)e)));
            return samlUtil.getErrorResponse((SAMLProtocolException)((Object)e)).getDoc();
        }
        catch (UnsupportedSAMLException e) {
            log.debug((Object)("SAML request processing failed as query is unsupported: " + (Object)((Object)e)));
            SAMLRequestException ex = new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", e.getMessage());
            return samlUtil.getErrorResponse((SAMLProtocolException)((Object)ex)).getDoc();
        }
        catch (SAMLParseException e) {
            log.debug((Object)("SAML request processing failed while parsing: " + (Object)((Object)e)));
            SAMLRequestException ex = new SAMLRequestException(null, e.getMessage());
            return samlUtil.getErrorResponse((SAMLProtocolException)((Object)ex)).getDoc();
        }
        boolean insertA = false;
        if (assertion.getAttributes().length != 0) {
            insertA = true;
        }
        if (insertA && samlUtil.doSignAssertion()) {
            try {
                assertion.sign(this.conf.getAuthAndTrust().getCredential().getKey(), this.conf.getAuthAndTrust().getCredential().getCertificateChain());
            }
            catch (DSigException e) {
                log.error((Object)"Signing SAML response error", (Throwable)e);
                throw new UVOSFault((UVOSException)((Object)new InternalException("Signing response problem", (Throwable)e)));
            }
        }
        if (insertA) {
            resp.addAssertion(assertion);
        }
        if (samlUtil.doSignResponse()) {
            try {
                resp.sign(this.conf.getAuthAndTrust().getCredential().getKey(), this.conf.getAuthAndTrust().getCredential().getCertificateChain());
            }
            catch (DSigException e) {
                log.error((Object)"Signing SAML assertion error", (Throwable)e);
                throw new UVOSFault((UVOSException)((Object)new InternalException("Signing response assertion problem", (Throwable)e)));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Returning response: " + resp.getDoc().xmlText(new XmlOptions().setSavePrettyPrint())));
        }
        return resp.getDoc();
    }

    private void getAllAttributes(Element whose, AttributeConverter converter) throws UVOSException, SAMLRequestException {
        List attrs = this.voQuery.getAttributes(whose, null, true, true, true);
        attrs = this.attribFilter.filter(attrs);
        converter.preInjectAttributes(attrs, null);
        List<Group> groups = this.voQuery.getAllGroups(whose.getIdentity(), true);
        if (whose.getGroup() == null) {
            if (attrs.size() == 0 && groups.size() == 0) {
                return;
            }
            converter.preInjectGroups(groups);
        } else {
            Group scope = whose.getGroup();
            String scopeStr = scope.toString();
            for (int i = groups.size() - 1; i >= 0; --i) {
                Group g = groups.get(i);
                if (g.isChild(scope) || g.toString().equals(scopeStr)) continue;
                groups.remove(i);
            }
            if (attrs.size() == 0 && groups.size() == 0) {
                return;
            }
            converter.preInjectGroups(groups);
        }
    }

    private void getAttribute(Element whose, AttributeType attrQ, AttributeConverter converter) throws SAMLRequestException, UVOSException, UnsupportedSAMLException, SAMLParseException {
        String attrName = attrQ.getName();
        XmlCursor cur = attrQ.newCursor();
        String requestedAttributeWideScope = cur.getAttributeText(SAMLConstants.ATTRIBUTE_SCOPE_XMLATTRIBUTE);
        String requestedScopingType = cur.getAttributeText(SAMLConstants.SCOPE_TYPE_XMLATTRIBUTE);
        cur.dispose();
        if (attrName == null) {
            throw new SAMLRequestException(null, "Attribute name can't be empty");
        }
        List<Attribute> attributes = this.getNamedAttribute(whose, attrName);
        this.filterAttributes(attributes, attrQ, requestedScopingType, requestedAttributeWideScope);
        converter.preInjectAttributes(attributes, requestedScopingType);
    }

    private List<Attribute> getNamedAttribute(Element whose, String name) throws SecurityException, InternalException, InvalidValueException, ElementNotKnownException {
        if (name.equals("urn:SAML:voprofile:group")) {
            List<Group> groups = this.voQuery.getAllGroups(whose.getIdentity(), true);
            ArrayList<String> groupNames = new ArrayList<String>();
            for (Group g : groups) {
                groupNames.add(g.toString());
            }
            ArrayList<Attribute> ret = new ArrayList<Attribute>();
            ret.add(new Attribute(AttributeConverter.GROUP_AT, groupNames, null));
            return ret;
        }
        return this.voQuery.getAttributes(whose, name, true, true, true);
    }

    private void filterAttributes(List<Attribute> unfiltered, AttributeType attrQ, String requestedScoping, String requestedScope) throws UnsupportedSAMLException, SAMLParseException {
        XmlObject[] valuesSpec = attrQ.getAttributeValueArray();
        if (valuesSpec == null || valuesSpec.length == 0 || unfiltered.size() == 0) {
            this.filterAttributesByScopeOnly(unfiltered, attrQ, requestedScoping, requestedScope);
            return;
        }
        List converted = SAMLXMLBeansMapper.map2APIAttributes((AttributeType)attrQ);
        for (int i = 0; i < unfiltered.size(); ++i) {
            Attribute checked = unfiltered.get(i);
            boolean found = false;
            for (Attribute okAttr : converted) {
                if (!this.areOfSameScope(okAttr, checked, requestedScoping)) continue;
                if (!this.filterAttributeValues(checked, okAttr)) break;
                found = true;
                break;
            }
            if (found) continue;
            unfiltered.remove(i);
            --i;
        }
    }

    private void filterAttributesByScopeOnly(List<Attribute> unfiltered, AttributeType attrQ, String requestedScoping, String requestedScope) throws UnsupportedSAMLException, SAMLParseException {
        if (requestedScope == null) {
            return;
        }
        List converted = SAMLXMLBeansMapper.map2APIAttributes((AttributeType)attrQ);
        for (int i = 0; i < unfiltered.size(); ++i) {
            Attribute checked = unfiltered.get(i);
            boolean found = false;
            for (Attribute okAttr : converted) {
                if (!this.areOfSameScope(okAttr, checked, requestedScoping)) continue;
                found = true;
                break;
            }
            if (found) continue;
            unfiltered.remove(i);
            --i;
        }
    }

    private boolean filterAttributeValues(Attribute a, Attribute filter) {
        List aVals = a.getValues();
        List filterVals = filter.getValues();
        if (filterVals.size() == 0) {
            return true;
        }
        for (int i = 0; i < aVals.size(); ++i) {
            if (filterVals.contains(aVals.get(i))) continue;
            aVals.remove(i);
            --i;
        }
        return aVals.size() != 0;
    }

    private boolean areOfSameScope(Attribute base, Attribute a2, String requestedScoping) {
        if (requestedScoping == null && base.getScope() == null) {
            return true;
        }
        String bSc = base.getScope();
        String a2Sc = a2.getScope();
        if (bSc == null) {
            bSc = "/";
        }
        if (a2Sc == null) {
            a2Sc = "/";
        }
        return bSc.equals(a2Sc);
    }
}

