/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.saml;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.exceptions.SAMLRequestException;
import eu.unicore.samly2.proto.NameIDMappingResponse;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.util.Log;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.api.UVOSQueryInterface;
import pl.edu.icm.unicore.uvos.saml.SAMLConfiguration;
import pl.edu.icm.unicore.uvos.saml.SAMLNameMappingUtil;
import pl.edu.icm.unicore.uvos.server.IssuerIdentityProvider;
import pl.edu.icm.unicore.uvos.server.idresolver.Authenticator;
import pl.edu.icm.unicore.uvos.server.idresolver.IdResolveException;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLNameIdMappingInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingRequestDocument;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingResponseDocument;
import xmlbeans.pl.edu.icm.samlvo.namemapext.AlternativeNameIDEntryType;
import xmlbeans.pl.edu.icm.samlvo.namemapext.AlternativeNameIDsDocument;
import xmlbeans.pl.edu.icm.samlvo.namemapext.AlternativeNameIDsType;

@WebService(endpointInterface="pl.edu.icm.unicore.uvos.wsapi.SAMLNameIdMappingInterface")
public class SAMLNameIdMappingImpl
implements SAMLNameIdMappingInterface {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", SAMLNameIdMappingImpl.class);
    private UVOSQueryInterface voQuery;
    private int reqValidity;
    private UVOSServerProperties conf;
    private IssuerIdentityProvider cryptoProvider;
    private Authenticator authenticator;
    private InternalAuthorization authz;
    private SAMLConfiguration samlConfiguration;

    public SAMLNameIdMappingImpl(UVOSQueryInterface voQuery, UVOSServerProperties conf, IssuerIdentityProvider cryptoProvider, Authenticator authenticator, InternalAuthorization authz, SAMLConfiguration samlConfig) {
        this.samlConfiguration = samlConfig;
        this.voQuery = voQuery;
        this.conf = conf;
        this.cryptoProvider = cryptoProvider;
        this.authenticator = authenticator;
        this.authz = authz;
        this.reqValidity = conf.getIntValue("saml.requestValidityPeriod");
    }

    public NameIDMappingResponseDocument mapNameId(NameIDMappingRequestDocument reqDoc) throws UVOSFault {
        NameIDMappingResponse resp;
        List<Identity> equivalents;
        SAMLNameMappingUtil samlUtil = new SAMLNameMappingUtil(reqDoc, this.cryptoProvider, this.conf, this.samlConfiguration);
        try {
            this.authenticator.resolve();
            samlUtil.parse();
            samlUtil.checkRequestValidity(this.reqValidity);
        }
        catch (IdResolveException e) {
            log.debug((Object)"UVOS engine problem while processing SAML request (authN stage )", (Throwable)((Object)e));
            throw new UVOSFault((UVOSException)e);
        }
        catch (UVOSException e) {
            log.debug((Object)("Authentication FAILED: " + (Object)((Object)e)));
            String info = "Authentication failed: " + (e.getMessage() == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getMessage());
            return samlUtil.getErrorResponse((UVOSException)((Object)new AuthenticationException()), info).getDoc();
        }
        catch (SAMLProtocolException e1) {
            log.debug((Object)("Parsing the SAML request FAILED: " + (Object)((Object)e1)));
            return samlUtil.getErrorResponse(e1).getDoc();
        }
        String format = samlUtil.getRequestedFormat();
        Identity originalId = samlUtil.getOriginalIdentity();
        try {
            if (!this.authz.isActive(originalId)) {
                SAMLRequestException e = new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipial", "Query subject is unknown");
                return samlUtil.getErrorResponse((SAMLProtocolException)((Object)e)).getDoc();
            }
        }
        catch (UVOSException e1) {
            log.debug((Object)("Query subject is unknown: " + (Object)((Object)e1)));
            return samlUtil.getErrorResponse(e1).getDoc();
        }
        try {
            equivalents = this.voQuery.getAllEquivalents(originalId);
        }
        catch (InternalException e) {
            log.debug((Object)("SAML request processing failed (in engine code) : " + (Object)((Object)e)));
            throw new UVOSFault((UVOSException)((Object)e));
        }
        catch (UVOSException e) {
            log.debug((Object)("SAML request processing failed (in engine code) : " + (Object)((Object)e)));
            return samlUtil.getErrorResponse(e).getDoc();
        }
        this.removeSelf(equivalents, originalId);
        if (equivalents.size() == 0) {
            return samlUtil.getErrorResponse((SAMLProtocolException)((Object)new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", "No matching alternative names available."))).getDoc();
        }
        if (format.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified")) {
            resp = samlUtil.getOKResponse(this.identity2SAML(equivalents.get(0)));
            this.addAllToExt(equivalents, resp);
        } else {
            this.filterMatching(equivalents, format);
            if (equivalents.size() == 0) {
                return samlUtil.getErrorResponse((SAMLProtocolException)((Object)new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", "No matching alternative names available."))).getDoc();
            }
            resp = samlUtil.getOKResponse(this.identity2SAML(equivalents.get(0)));
        }
        if (samlUtil.doSignResponse()) {
            try {
                resp.sign(this.conf.getAuthAndTrust().getCredential().getKey(), this.conf.getAuthAndTrust().getCredential().getCertificateChain());
            }
            catch (DSigException e) {
                log.error((Object)"Signing SAML assertion error", (Throwable)e);
                throw new UVOSFault((UVOSException)((Object)new InternalException("Signing response assertion problem", (Throwable)e)));
            }
        }
        return resp.getDoc();
    }

    private NameIDType identity2SAML(Identity id, NameIDType samlName) {
        samlName.setFormat(id.getType().toString());
        samlName.setStringValue(id.getValue());
        return samlName;
    }

    private NameID identity2SAML(Identity id) {
        return new NameID(id.getValue(), id.getType().toString());
    }

    private void removeSelf(List<Identity> list, Identity orig) {
        String oF = orig.getType().toString();
        String oV = orig.getValue();
        for (int i = 0; i < list.size(); ++i) {
            Identity id = list.get(i);
            if (!id.getType().toString().equals(oF) || !id.getValue().equals(oV)) continue;
            list.remove(i);
            return;
        }
    }

    private void filterMatching(List<Identity> list, String format) {
        for (int i = 0; i < list.size(); ++i) {
            Identity id = list.get(i);
            if (id.getType().toString().equals(format)) continue;
            list.remove(i);
            --i;
        }
    }

    private void addAllToExt(List<Identity> list, NameIDMappingResponse resp) {
        AlternativeNameIDsDocument extDoc = AlternativeNameIDsDocument.Factory.newInstance();
        AlternativeNameIDsType altName = extDoc.addNewAlternativeNameIDs();
        for (Identity id : list) {
            AlternativeNameIDEntryType entry = altName.addNewMappedNameID();
            NameIDType samlName = entry.addNewNameID();
            this.identity2SAML(id, samlName);
        }
        resp.setExtensions((XmlObject)extDoc);
    }
}

