/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.saml;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.elements.Subject;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.exceptions.SAMLRequestException;
import eu.unicore.samly2.proto.AssertionResponse;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.util.Log;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.engine.api.UVOSAuthZInterface;
import pl.edu.icm.unicore.uvos.idhelpers.X509IdentityHelper;
import pl.edu.icm.unicore.uvos.saml.SAMLAuthnUtil;
import pl.edu.icm.unicore.uvos.saml.SAMLConfiguration;
import pl.edu.icm.unicore.uvos.saml.SAMLErrorException;
import pl.edu.icm.unicore.uvos.server.IssuerIdentityProvider;
import pl.edu.icm.unicore.uvos.server.idresolver.Authenticator;
import pl.edu.icm.unicore.uvos.server.idresolver.IdResolveException;
import pl.edu.icm.unicore.uvos.server.saml.ReplayAttackChecker;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLAuthnInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import xmlbeans.org.oasis.saml2.assertion.AuthnContextType;
import xmlbeans.org.oasis.saml2.assertion.SubjectConfirmationDataType;
import xmlbeans.org.oasis.saml2.assertion.SubjectConfirmationType;
import xmlbeans.org.oasis.saml2.protocol.AuthnRequestDocument;
import xmlbeans.org.oasis.saml2.protocol.AuthnRequestType;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;

public class SAMLAuthImpl
implements SAMLAuthnInterface {
    public static final String SAML_AC_UNSPEC = "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified";
    private UVOSAuthZInterface voAuthz;
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", SAMLAuthImpl.class);
    private int reqValidity;
    private boolean allowX509AsDN;
    private UVOSServerProperties conf;
    private IssuerIdentityProvider cryptoProvider;
    private Authenticator authenticator;
    private ReplayAttackChecker repChecker;
    private SAMLConfiguration samlConfiguration;

    public SAMLAuthImpl(UVOSAuthZInterface voAuthz, UVOSServerProperties conf, IssuerIdentityProvider cryptoProvider, Authenticator authenticator, ReplayAttackChecker repChecker, SAMLConfiguration samlConfig) {
        this.samlConfiguration = samlConfig;
        this.voAuthz = voAuthz;
        this.conf = conf;
        this.cryptoProvider = cryptoProvider;
        this.authenticator = authenticator;
        this.repChecker = repChecker;
        this.reqValidity = conf.getIntValue("saml.requestValidityPeriod");
        this.allowX509AsDN = conf.getBooleanValue("saml.allowToUseCertificateAsDN");
    }

    public ResponseDocument authnRequest(AuthnRequestDocument reqDoc) throws UVOSFault {
        SAMLAuthnUtil samlCtx;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received request: " + reqDoc.xmlText(new XmlOptions().setSavePrettyPrint())));
        }
        Calendar authTime = Calendar.getInstance();
        SAMLAuthnUtil samlUtil = new SAMLAuthnUtil(reqDoc, this.cryptoProvider, this.conf, this.samlConfiguration);
        try {
            this.authenticator.resolve();
        }
        catch (IdResolveException e) {
            log.debug((Object)"UVOS engine problem while processing SAML request (authN stage )", (Throwable)((Object)e));
            throw new UVOSFault((UVOSException)e);
        }
        catch (UVOSException e) {
            log.debug((Object)("Authentication FAILED: " + (Object)((Object)e)));
            String info = "Authentication failed: " + (e.getMessage() == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getMessage());
            return samlUtil.getErrorResponse((UVOSException)((Object)new AuthenticationException()), info).getDoc();
        }
        AuthnContextType authContext = this.setupAuthnContext();
        try {
            samlCtx = this.preprocessAuthnRequest(reqDoc);
        }
        catch (SAMLErrorException e) {
            return e.getResponse();
        }
        return this.processAuthnRequest(samlCtx, authContext, authTime);
    }

    public AuthnContextType setupAuthnContext() {
        AuthnContextType ret = AuthnContextType.Factory.newInstance();
        ret.setAuthnContextClassRef(SAML_AC_UNSPEC);
        return ret;
    }

    public SAMLAuthnUtil preprocessAuthnRequest(AuthnRequestDocument reqDoc) throws SAMLErrorException {
        SAMLAuthnUtil samlUtil = new SAMLAuthnUtil(reqDoc, this.cryptoProvider, this.conf, this.samlConfiguration);
        try {
            samlUtil.parse();
            samlUtil.checkRequestValidity(this.reqValidity);
            if (!samlUtil.isRequestCorrectlySigned()) {
                log.info((Object)("Got request with invalid signature: " + reqDoc.xmlText()));
                throw new SAMLErrorException(samlUtil.getErrorResponse((SAMLProtocolException)new SAMLRequestException(null, "Request signature is invalid")).getDoc());
            }
        }
        catch (SAMLProtocolException e) {
            log.debug((Object)("Parsing the SAML request FAILED: " + (Object)((Object)e)));
            throw new SAMLErrorException(samlUtil.getErrorResponse(e).getDoc());
        }
        catch (DSigException e) {
            log.info((Object)("Signature verification problem: " + (Object)((Object)e)));
            throw new SAMLErrorException(samlUtil.getErrorResponse((SAMLProtocolException)new SAMLRequestException(null, "Signature can't be verified: " + e.getMessage())).getDoc());
        }
        try {
            this.checkUnsupportedConstraints(reqDoc);
        }
        catch (SAMLProtocolException e) {
            log.debug((Object)("Ignoring unsupported authn request: " + e.getMessage()));
            throw new SAMLErrorException(samlUtil.getErrorResponse(e).getDoc());
        }
        try {
            this.repChecker.checkAndAdd(samlUtil.getReqId(), System.currentTimeMillis());
        }
        catch (Exception e2) {
            String msg = "Request is denied: " + e2.getMessage();
            log.info((Object)msg);
            throw new SAMLErrorException(samlUtil.getErrorResponse((SAMLProtocolException)new SAMLRequestException(null, msg)).getDoc());
        }
        return samlUtil;
    }

    public ResponseDocument processAuthnRequest(SAMLAuthnUtil samlUtil, AuthnContextType authContext, Calendar authTime) throws UVOSFault {
        Subject authenticatedOne;
        List<Identity> equivs;
        String format = samlUtil.getRequestedFormat();
        try {
            equivs = this.voAuthz.getMyIdentities();
        }
        catch (UVOSException e1) {
            return samlUtil.getErrorResponse(e1).getDoc();
        }
        if (equivs.size() == 0) {
            String msg = "getAllEquivalents returned empty list";
            log.error((Object)msg);
            throw new UVOSFault((UVOSException)((Object)new InternalException(msg)));
        }
        try {
            authenticatedOne = this.findUser(format, equivs);
        }
        catch (SAMLProtocolException e) {
            return samlUtil.getErrorResponse(e).getDoc();
        }
        SubjectConfirmationType subConf = SubjectConfirmationType.Factory.newInstance();
        subConf.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationDataType confData = subConf.addNewSubjectConfirmationData();
        confData.setInResponseTo(samlUtil.getReqId());
        confData.setRecipient(samlUtil.getConsumerURL());
        Calendar validity = Calendar.getInstance();
        validity.setTimeInMillis(authTime.getTimeInMillis());
        validity.add(13, this.reqValidity);
        confData.setNotOnOrAfter(validity);
        authenticatedOne.setSubjectConfirmation(new SubjectConfirmationType[]{subConf});
        AssertionResponse resp = samlUtil.getOKResponseDocument();
        Assertion assertion = new Assertion();
        assertion.setIssuer(samlUtil.getIssuer().getXBean());
        assertion.setSubject(authenticatedOne.getXBean());
        assertion.addAuthStatement(authTime, authContext);
        assertion.setAudienceRestriction(new String[]{samlUtil.getIssuerName()});
        try {
            assertion.sign(this.conf.getAuthAndTrust().getCredential().getKey(), this.conf.getAuthAndTrust().getCredential().getCertificateChain());
        }
        catch (DSigException e) {
            log.error((Object)"Signing SAML response error", (Throwable)e);
            throw new UVOSFault((UVOSException)((Object)new InternalException("Signing response problem", (Throwable)e)));
        }
        resp.addAssertion(assertion);
        return resp.getDoc();
    }

    private Subject findUser(String format, List<Identity> equivs) throws SAMLProtocolException {
        if (format.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent") || format.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified")) {
            String persId = equivs.get(0).getPersistentEntityId();
            return new Subject(persId, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        }
        if (format.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName") || format.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress") || format.equals(IdentityType.X509CERT.getName())) {
            for (Identity i : equivs) {
                if (!i.getType().getName().equals(format)) continue;
                return new Subject(i.getValue(), format);
            }
            if (this.allowX509AsDN && format.equals(IdentityType.DN)) {
                for (Identity i : equivs) {
                    X509Certificate cert;
                    if (!i.getType().equals((Object)IdentityType.X509CERT)) continue;
                    try {
                        cert = new X509IdentityHelper(i).getCertificate();
                    }
                    catch (InvalidValueException e) {
                        log.error((Object)("BUG - there is an unparsable certificate in DB: " + i.getValue()));
                        continue;
                    }
                    String cn = cert.getSubjectX500Principal().getName();
                    return new Subject(cn, format);
                }
            }
            throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipial", "There is no identity in the requested format for the authenticated principial.");
        }
        throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", format + " is not supported by this service.");
    }

    private void checkUnsupportedConstraints(AuthnRequestDocument reqDoc) throws SAMLProtocolException {
        AuthnRequestType req = reqDoc.getAuthnRequest();
        if (req.getSubject() != null) {
            throw new SAMLProtocolException("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "This implementation doesn't support authn requests with Subject set.");
        }
        if (req.getRequestedAuthnContext() != null) {
            throw new SAMLProtocolException("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "This implementation doesn't support authn requests with RequestedAuthnContext set.");
        }
        if (req.isSetAssertionConsumerServiceIndex()) {
            throw new SAMLProtocolException("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "This implementation doesn't support authn requests with AssertionConsumerServiceIndex set.");
        }
        if (req.isSetAttributeConsumingServiceIndex()) {
            throw new SAMLProtocolException("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "This implementation doesn't support authn requests with AttributeConsumingServiceIndex set.");
        }
    }
}

