/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.saml;

import eu.unicore.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class ReplayAttackChecker {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", ReplayAttackChecker.class);
    private Map<String, Long> usedMap;
    private long holdingTime;
    private long lastCleanupTime;

    public ReplayAttackChecker(UVOSServerProperties conf) {
        this.holdingTime = conf.getIntValue("saml.requestValidityPeriod") * 10;
        this.usedMap = new HashMap<String, Long>();
        this.lastCleanupTime = System.currentTimeMillis();
        log.info((Object)("Request IDs will be kept for at least " + this.holdingTime + "s"));
        this.holdingTime *= 1000L;
    }

    public synchronized void checkAndAdd(String id, long ts) throws Exception {
        if (this.usedMap.containsKey(id)) {
            throw new Exception("The request id was already seen.");
        }
        this.usedMap.put(id, ts);
        if (System.currentTimeMillis() - this.lastCleanupTime > this.holdingTime) {
            this.doCleanup();
        }
    }

    private void doCleanup() {
        Iterator<Map.Entry<String, Long>> entries = this.usedMap.entrySet().iterator();
        long now = System.currentTimeMillis();
        int cleaned = 0;
        while (entries.hasNext()) {
            Map.Entry<String, Long> entry = entries.next();
            if (now - entry.getValue() <= this.holdingTime) continue;
            entries.remove();
            ++cleaned;
        }
        this.lastCleanupTime = now;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cleaned up recent ids: " + cleaned + " cleaned, " + this.usedMap.size() + " retained."));
        }
    }
}

