/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.saml;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AttributeFilterPattern {
    private Pattern namePattern;
    private List<Pattern> allowedScopes;
    private List<Pattern> ignoredScopes;

    public AttributeFilterPattern(String regex) throws PatternSyntaxException {
        this.namePattern = Pattern.compile("^" + regex + "$");
        this.allowedScopes = new ArrayList<Pattern>();
        this.ignoredScopes = new ArrayList<Pattern>();
    }

    public void addAllowedScope(String regex) throws PatternSyntaxException {
        this.allowedScopes.add(Pattern.compile("^" + regex + "$"));
    }

    public void addForbiddenScope(String regex) throws PatternSyntaxException {
        this.ignoredScopes.add(Pattern.compile("^" + regex + "$"));
    }

    public boolean doesApply(String scope) {
        if (scope == null) {
            scope = "";
        }
        for (Pattern pattern : this.ignoredScopes) {
            if (!pattern.matcher(scope).matches()) continue;
            return false;
        }
        if (this.allowedScopes.isEmpty()) {
            return true;
        }
        for (Pattern pattern : this.allowedScopes) {
            if (!pattern.matcher(scope).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean doesNameMatch(String name) {
        return this.namePattern.matcher(name).matches();
    }

    public boolean doesApplyAndMatch(String name, String scope) {
        return this.doesNameMatch(name) && this.doesApply(scope);
    }

    public String toString() {
        return this.namePattern + ", allowed scopes:" + this.allowedScopes + ", excluded scopes:" + this.ignoredScopes;
    }
}

