/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.saml;

import eu.unicore.util.Log;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.server.saml.AttributeFilterPattern;
import pl.edu.icm.unicore.uvos.util.AttributeFilter;
import pl.edu.icm.unicore.uvos.util.FileWatcher;
import pl.edu.icm.unicore.uvos.util.ThreadScheduler;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class AttributeFilterImpl
implements AttributeFilter {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", AttributeFilterImpl.class);
    private FilePropertiesHelper conf;
    private final String configFile;
    private List<AttributeFilterPattern> excluded = new ArrayList<AttributeFilterPattern>();
    private List<AttributeFilterPattern> included = new ArrayList<AttributeFilterPattern>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private int delay;
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();

    public AttributeFilterImpl(UVOSServerProperties baseConf, ThreadScheduler scheduler) throws IOException {
        this(baseConf.getValue("saml.attributeFiltersConfig"), 5000, scheduler);
    }

    public AttributeFilterImpl(String configFile, int recheckDelay, ThreadScheduler scheduler) throws IOException {
        this.configFile = configFile;
        this.delay = recheckDelay;
        this.readConfiguration();
        this.startConfigWatcher(scheduler.getScheduledExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfiguration() throws IOException {
        this.lock.writeLock().lock();
        try {
            this.conf = new FilePropertiesHelper("", this.configFile, META, log);
            this.excluded.clear();
            this.included.clear();
            int x = 1;
            while (this.addRule(x, "excludedAttribute", true)) {
                ++x;
            }
            x = 1;
            while (this.addRule(x, "exposedAttribute", false)) {
                ++x;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void startConfigWatcher(ScheduledExecutorService timer) {
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    log.info((Object)"ATTRIBUTE FILTER CONFIGURATION MODIFIED, re-configuring.");
                    try {
                        AttributeFilterImpl.this.readConfiguration();
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to reload the attribute release policy", (Throwable)e);
                    }
                }
            };
            FileWatcher fw = new FileWatcher(new File(this.configFile), r);
            timer.scheduleWithFixedDelay(fw, this.delay, this.delay, TimeUnit.MILLISECONDS);
        }
        catch (FileNotFoundException fex) {
            log.warn((Object)("Attribute filter configuration file <" + this.configFile + "> not found."));
        }
    }

    private boolean addRule(int x, String cfgPfx, boolean mode) {
        String lkey;
        String regex2;
        AttributeFilterPattern afp;
        String key = cfgPfx + "." + x;
        String regex = this.conf.getValue(key);
        if (regex == null) {
            return false;
        }
        try {
            afp = new AttributeFilterPattern(regex);
        }
        catch (PatternSyntaxException ex) {
            log.error((Object)("Invalid regular expression: '" + regex + "', will be ignored"));
            return true;
        }
        log.debug((Object)((mode ? "Hiding" : "Exposing") + " attributes matching '" + regex + "'"));
        int y = 1;
        while ((regex2 = this.conf.getValue(lkey = key + ".scope." + y)) != null) {
            try {
                afp.addAllowedScope(regex2);
                log.debug((Object)(" included for '" + regex2 + "' scope"));
            }
            catch (PatternSyntaxException ex) {
                log.error((Object)("Invalid regular expression for property " + lkey + ": '" + regex2 + "', will be ignored"));
            }
            ++y;
        }
        y = 1;
        while ((regex2 = this.conf.getValue(lkey = key + ".scope.not." + y)) != null) {
            try {
                afp.addForbiddenScope(regex2);
                log.debug((Object)(" excluded for '" + regex2 + "' scope"));
            }
            catch (PatternSyntaxException ex) {
                log.error((Object)("Invalid regular expression for property " + lkey + ": '" + regex2 + "', will be ignored"));
            }
            ++y;
        }
        if (mode) {
            this.excluded.add(afp);
        } else {
            this.included.add(afp);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> filter(List<Attribute> attribs) {
        this.lock.readLock().lock();
        try {
            if (this.included.isEmpty() && this.excluded.isEmpty()) {
                log.trace((Object)"No attribute filters defined, returning an original attribute list");
                List<Attribute> list = attribs;
                return list;
            }
            ArrayList<Attribute> res = new ArrayList<Attribute>(attribs.size());
            block4: for (Attribute a : attribs) {
                String name = a.getName();
                String scope = a.getScope();
                for (AttributeFilterPattern excludingPattern : this.excluded) {
                    if (!excludingPattern.doesApplyAndMatch(name, scope)) continue;
                    log.debug((Object)("Attribute " + a + " filtered by an excluding pattern " + excludingPattern));
                    continue block4;
                }
                if (this.included.isEmpty()) {
                    log.trace((Object)("Attribute " + a + " accepted due to no defined inclusion rules"));
                    res.add(a);
                    continue;
                }
                for (AttributeFilterPattern includingPattern : this.included) {
                    if (!includingPattern.doesApplyAndMatch(name, scope)) continue;
                    log.debug((Object)("Attribute " + a + " accepted by an including pattern " + includingPattern));
                    res.add(a);
                    continue block4;
                }
                log.debug((Object)("Attribute " + a + " filtered as it is not matching any including pattern."));
            }
            ArrayList<Attribute> arrayList = res;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean allowsEverything() {
        return this.excluded.size() == 0 && this.included.size() == 0;
    }

    static {
        META.put("exposedAttribute", new PropertyMD().setCanHaveSubkeys());
        META.put("excludedAttribute", new PropertyMD().setCanHaveSubkeys());
    }
}

