/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.saml;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.exceptions.SAMLRequestException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Group;

public class AttributeConverter {
    public static final AttributeType GROUP_AT = new AttributeType("urn:SAML:voprofile:group", "Group membership", "Attribtue bearer is a memebr of the groups listed as this attribute values.");
    public static final String XACML_DT = "http://www.w3.org/2001/XMLSchema#string";
    private HashMap<String, AttributesBag> preparedAttrs = new HashMap();

    public void preInjectGroups(List<Group> groups) {
        if (groups.size() == 0) {
            return;
        }
        AttributesBag curVal = this.preparedAttrs.get("urn:SAML:voprofile:group");
        if (curVal == null) {
            curVal = new AttributesBag(XACML_DT, "urn:SAML:voprofile:NonScopedValue");
            this.preparedAttrs.put("urn:SAML:voprofile:group", curVal);
        }
        Attribute a = new Attribute(GROUP_AT, null, null);
        for (Group group : groups) {
            a.addValue(group.toString());
        }
        curVal.attributes.add(a);
    }

    public void preInjectAttributes(List<Attribute> attr, String requestedScopeType) throws SAMLRequestException {
        if (attr.size() == 0) {
            return;
        }
        HashMap<String, AttributesBag> tmpAttrs = new HashMap<String, AttributesBag>();
        for (Attribute a : attr) {
            String xacmlDT;
            String name = a.getName().toString();
            AttributesBag curVal = this.preparedAttrs.get(name);
            if (curVal != null) {
                throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:InvalidAttrNameOrValue", "Invalid query: attribute must be specified only once according to SAML specification");
            }
            curVal = (AttributesBag)tmpAttrs.get(name);
            String current = curVal == null ? null : curVal.scopeType;
            String scopingType = this.establishscopingType(requestedScopeType, a, current);
            String string = xacmlDT = scopingType.equals("urn:SAML:voprofile:ScopedValue") ? "urn:SAML:voprofile:ScopedAttribute" : XACML_DT;
            if (curVal == null) {
                curVal = new AttributesBag(xacmlDT, scopingType);
                tmpAttrs.put(name, curVal);
            } else {
                curVal.scopeType = scopingType;
                curVal.xacmlDT = xacmlDT;
            }
            curVal.attributes.add(a);
        }
        this.preparedAttrs.putAll(tmpAttrs);
    }

    public void injectAttributes(Assertion assertion) {
        if (this.preparedAttrs.size() == 0) {
            return;
        }
        for (Map.Entry<String, AttributesBag> entry : this.preparedAttrs.entrySet()) {
            String xacmlType = entry.getValue().xacmlDT;
            String scopingType = entry.getValue().scopeType;
            SAMLAttribute samlA = new SAMLAttribute(entry.getKey(), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
            String shortDesc = entry.getValue().attributes.get(0).getType().getShortDescription();
            if (shortDesc != null) {
                samlA.setFriendlyName(shortDesc);
            }
            samlA.setXACMLDataType(xacmlType);
            if (scopingType != "urn:SAML:voprofile:NonScopedValue") {
                samlA.setScopingType(scopingType);
            }
            for (Attribute a : entry.getValue().attributes) {
                this.addAttribute(samlA, a, scopingType);
            }
            assertion.addAttribute(samlA);
        }
    }

    private void addAttribute(SAMLAttribute samlA, Attribute a, String scopingType) {
        List vals = a.getValues();
        if (scopingType.equals("urn:SAML:voprofile:SimpleScopedString")) {
            String scope = a.getScope();
            scope = scope == null ? "@/" : "@" + scope;
            for (String val : vals) {
                samlA.addStringAttributeValue(val + scope);
            }
            if (vals.size() == 0) {
                samlA.addStringAttributeValue(scope);
            }
        } else if (scopingType.equals("urn:SAML:voprofile:ScopedValue")) {
            String scope = a.getScope();
            for (String val : vals) {
                samlA.addScopedStringAttributeValue(val, scope == null ? "/" : scope);
            }
            if (vals.size() == 0) {
                samlA.addScopedStringAttributeValue(null, scope == null ? "/" : scope);
            }
        } else {
            if (a.getScope() != null) {
                return;
            }
            for (String val : vals) {
                samlA.addStringAttributeValue(val);
            }
        }
    }

    private String establishscopingType(String requested, Attribute newAttribute, String current) throws SAMLRequestException {
        if (requested != null) {
            if (!(requested.equals("urn:SAML:voprofile:ScopedValue") || requested.equals("urn:SAML:voprofile:SimpleScopedString") || requested.equals("urn:SAML:voprofile:NonScopedValue"))) {
                throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:InvalidAttrNameOrValue", "Unsupported ");
            }
            return requested;
        }
        boolean isScopeDefined = false;
        if (newAttribute.getScope() != null) {
            isScopeDefined = true;
        }
        if (isScopeDefined) {
            return "urn:SAML:voprofile:ScopedValue";
        }
        return current == null ? "urn:SAML:voprofile:NonScopedValue" : current;
    }

    private static class AttributesBag {
        String xacmlDT;
        String scopeType;
        List<Attribute> attributes;

        public AttributesBag(String xacml, String scopeType) {
            this.xacmlDT = xacml;
            this.scopeType = scopeType;
            this.attributes = new ArrayList<Attribute>();
        }
    }
}

