/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.idresolver;

import eu.unicore.security.SecurityTokens;
import eu.unicore.util.Log;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.SecurityContext;
import pl.edu.icm.unicore.uvos.idhelpers.X509IdentityHelper;
import pl.edu.icm.unicore.uvos.server.idresolver.AbstractResolver;
import pl.edu.icm.unicore.uvos.server.idresolver.IdUnresolvedException;

public class TLSResolver
extends AbstractResolver {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", TLSResolver.class);
    private boolean tlsDNFirst;

    public TLSResolver(boolean tlsDNFirst, InternalAuthorization voAuthz) {
        super(voAuthz);
        this.tlsDNFirst = tlsDNFirst;
    }

    @Override
    public SecurityContext resolve(SecurityTokens input) throws IdUnresolvedException, UVOSException {
        Identity id = this.tlsDNFirst ? this.resolveDN(input) : this.resolveFullCert(input);
        if (id == null) {
            return null;
        }
        try {
            return this.authenticate(id, "TLS");
        }
        catch (IdUnresolvedException e) {
            id = this.tlsDNFirst ? this.resolveFullCert(input) : this.resolveDN(input);
            return this.authenticate(id, "TLS");
        }
    }

    private Identity resolveFullCert(SecurityTokens input) {
        X509Certificate cert = input.getEffectiveUserCertificate();
        if (cert == null) {
            return null;
        }
        try {
            return X509IdentityHelper.convertCert((X509Certificate)cert);
        }
        catch (IOException e) {
            log.error((Object)"Error during creation of identity from certificate", (Throwable)e);
            return null;
        }
    }

    private Identity resolveDN(SecurityTokens input) {
        X500Principal subject = input.getEffectiveUserName();
        if (subject == null) {
            return null;
        }
        String id = subject.getName();
        Identity idRet = new Identity(IdentityType.DN, id, null);
        return idRet;
    }
}

