/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.idresolver;

import eu.unicore.security.SecurityTokens;
import eu.unicore.util.Log;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.service.invoker.AbstractInvoker;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.SecurityContext;
import pl.edu.icm.unicore.uvos.server.idresolver.IResolver;
import pl.edu.icm.unicore.uvos.server.idresolver.IdResolveException;
import pl.edu.icm.unicore.uvos.server.idresolver.IdUnresolvedException;
import pl.edu.icm.unicore.uvos.server.idresolver.LoginResolver;
import pl.edu.icm.unicore.uvos.server.idresolver.TLSResolver;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class Authenticator {
    private static ThreadLocal<SecurityContext> authnContext = new ThreadLocal();
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", Authenticator.class);
    private List<IResolver> resolvers = new ArrayList<IResolver>();
    protected InternalAuthorization voAuthz;
    private boolean failOnInvalid;
    private boolean tlsDNFirst;

    public Authenticator(UVOSServerProperties conf, InternalAuthorization voAuthz) {
        this.voAuthz = voAuthz;
        this.failOnInvalid = conf.getBooleanValue("authn.failOnError");
        String rawOrder = conf.getValue("authn.order");
        this.parseOrder(rawOrder);
        if (this.resolvers.size() == 0) {
            log.error((Object)("No valid authN possibility found. Will use default: " + UVOSServerProperties.defaults.get("authn.order")));
            this.parseOrder(UVOSServerProperties.defaults.get("authn.order").getDefault());
        }
        this.tlsDNFirst = conf.getBooleanValue("authn.mapTLSCertToDNFirst");
    }

    public void authenticate() throws AuthenticationException {
        try {
            this.resolve();
        }
        catch (IdResolveException e) {
            log.error((Object)e.toString());
            throw new AuthenticationException("Internal error in authN stack: " + (Object)((Object)e));
        }
        catch (IdUnresolvedException e) {
            throw new AuthenticationException(e.getMessage());
        }
        catch (UVOSException e) {
            log.error((Object)"General authentication problem", (Throwable)e);
            throw new AuthenticationException(e.toString());
        }
    }

    public static X509Certificate getAuthNCert() {
        MessageContext ctx = AbstractInvoker.getContext();
        SecurityTokens tokens = (SecurityTokens)ctx.getProperty(SecurityTokens.KEY);
        if (tokens != null) {
            return tokens.getEffectiveUserCertificate();
        }
        return null;
    }

    private void parseOrder(String rawOrder) {
        String[] orderS;
        for (String authSrc : orderS = rawOrder.split(" ")) {
            if (authSrc.equals("TLS")) {
                this.resolvers.add(new TLSResolver(this.tlsDNFirst, this.voAuthz));
                continue;
            }
            if (authSrc.equals("HTTP")) {
                this.resolvers.add(new LoginResolver(this.voAuthz));
                continue;
            }
            log.warn((Object)("Unknown authN possibility '" + authSrc + "' - IGNORED"));
        }
    }

    public void resolve() throws IdResolveException, IdUnresolvedException, UVOSException {
        MessageContext ctx = AbstractInvoker.getContext();
        SecurityTokens tokens = (SecurityTokens)ctx.getProperty(SecurityTokens.KEY);
        if (tokens == null) {
            throw new IdResolveException("Client not authenticated, error in security handlers configuration");
        }
        for (IResolver resolver : this.resolvers) {
            SecurityContext caller;
            try {
                caller = resolver.resolve(tokens);
            }
            catch (IdUnresolvedException e) {
                if (!this.failOnInvalid) continue;
                throw e;
            }
            if (caller == null) continue;
            authnContext.set(caller);
            return;
        }
        throw new IdUnresolvedException("Client not authenticated");
    }

    public static SecurityContext getCurrentContext() throws InternalException {
        SecurityContext ctx = authnContext.get();
        if (ctx == null) {
            log.fatal((Object)"SecurityContext is not set, so authentication was not performed.");
            Thread.dumpStack();
            throw new InternalException("Authentication problem.");
        }
        return ctx;
    }

    public static void injectFakeContext(SecurityContext ctx) {
        authnContext.set(ctx);
    }
}

