/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server.idresolver;

import eu.unicore.util.Log;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.SecurityContext;
import pl.edu.icm.unicore.uvos.server.idresolver.IResolver;
import pl.edu.icm.unicore.uvos.server.idresolver.IdUnresolvedException;

public abstract class AbstractResolver
implements IResolver {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", AbstractResolver.class);
    protected InternalAuthorization voAuthz;

    public AbstractResolver(InternalAuthorization voAuthz) {
        this.voAuthz = voAuthz;
    }

    protected SecurityContext authenticate(Identity r, String name) throws IdUnresolvedException, InternalException, InvalidValueException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Trying to authenticate identity resolved to: " + r));
        }
        try {
            SecurityContext ret = this.voAuthz.establishSecurityContext(r);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully established security context for " + r.prettyString()));
            }
            return ret;
        }
        catch (AuthenticationException e) {
            throw new IdUnresolvedException("Wrong credentials (on: " + name + ") for identity: " + r.prettyString());
        }
        catch (IdentityNotKnownException e) {
            throw new IdUnresolvedException("Unknown identity (on: " + name + "): " + r.prettyString());
        }
    }
}

