/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server;

import eu.unicore.util.Log;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.engine.api.UVOSQueryInterface;
import pl.edu.icm.unicore.uvos.server.idresolver.Authenticator;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSQueryInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.XMLBeansMapper;
import xmlbeans.pl.edu.icm.uvos.internal.AttributesListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.ElementDocument;
import xmlbeans.pl.edu.icm.uvos.internal.ElementsListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.GroupDocument;
import xmlbeans.pl.edu.icm.uvos.internal.GroupsListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.IdentitiesListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.IdentityDocument;

@WebService(endpointInterface="pl.edu.icm.unicore.uvos.wsapi.WSQueryInterface")
public class WSQueryImpl
implements WSQueryInterface {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", WSQueryImpl.class);
    private UVOSQueryInterface voQuery;
    private Authenticator authenticator;

    public WSQueryImpl(UVOSQueryInterface voQuery, Authenticator auth) throws InternalException {
        this.voQuery = voQuery;
        this.authenticator = auth;
    }

    public boolean areEquivalent(IdentityDocument arg0, IdentityDocument arg1) throws UVOSFault {
        try {
            log.debug((Object)"areEquivalent invoked");
            this.authenticator.authenticate();
            return this.voQuery.areEquivalent(XMLBeansMapper.map2APIIdentity((IdentityDocument)arg0), XMLBeansMapper.map2APIIdentity((IdentityDocument)arg1));
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking areEquivalent: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public AttributesListDocument getAttributes(ElementDocument owner, String attribute, boolean arg1, boolean includeScoped, boolean includeImplied) throws UVOSFault {
        try {
            log.debug((Object)"getAttributes invoked");
            this.authenticator.authenticate();
            List<Attribute> raw = null;
            raw = this.voQuery.getAttributes(XMLBeansMapper.map2APIElement((ElementDocument)owner), attribute, arg1, includeScoped, includeImplied);
            return XMLBeansMapper.map2XMLAttributesList(raw);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getAttributes: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public IdentitiesListDocument getAllEquivalents(IdentityDocument arg0) throws UVOSFault {
        try {
            log.debug((Object)"getAllEquivalents invoked");
            this.authenticator.authenticate();
            List<Identity> raw = null;
            raw = this.voQuery.getAllEquivalents(XMLBeansMapper.map2APIIdentity((IdentityDocument)arg0));
            return XMLBeansMapper.map2XMLIdentitiesList(raw);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getAllEquivalents: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public GroupsListDocument getAllGroups(IdentityDocument arg0, boolean implied) throws UVOSFault {
        try {
            log.debug((Object)"getAllGroups invoked");
            this.authenticator.authenticate();
            List<Group> raw = null;
            raw = this.voQuery.getAllGroups(XMLBeansMapper.map2APIIdentity((IdentityDocument)arg0), implied);
            return XMLBeansMapper.map2XMLList(raw);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getAllGroups: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public IdentitiesListDocument getAllIdentities() throws UVOSFault {
        try {
            log.debug((Object)"getAllIdentities invoked");
            this.authenticator.authenticate();
            List<Identity> raw = null;
            raw = this.voQuery.getAllIdentities();
            return XMLBeansMapper.map2XMLIdentitiesList(raw);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getAllIdentities: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public ElementsListDocument getGroupContent(GroupDocument arg0) throws UVOSFault {
        try {
            log.debug((Object)"getGroupContent invoked");
            this.authenticator.authenticate();
            List<Element> raw = null;
            raw = this.voQuery.getGroupContent(XMLBeansMapper.map2APIGroup((GroupDocument)arg0));
            return XMLBeansMapper.map2XMLElementsList(raw);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getGroupContent: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public boolean isMember(IdentityDocument arg0, GroupDocument arg1, boolean arg2) throws UVOSFault {
        try {
            log.debug((Object)"isMember invoked");
            this.authenticator.authenticate();
            return this.voQuery.isMember(XMLBeansMapper.map2APIIdentity((IdentityDocument)arg0), XMLBeansMapper.map2APIGroup((GroupDocument)arg1), arg2);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking isMember: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }
}

