/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server;

import eu.unicore.util.Log;
import java.util.Calendar;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.engine.api.UVOSManagementInterface;
import pl.edu.icm.unicore.uvos.server.idresolver.Authenticator;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSManagementInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.XMLBeansMapper;
import xmlbeans.pl.edu.icm.uvos.internal.AttributeDocument;
import xmlbeans.pl.edu.icm.uvos.internal.AttributeXType;
import xmlbeans.pl.edu.icm.uvos.internal.AttributesListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.AttributesListType;
import xmlbeans.pl.edu.icm.uvos.internal.ElementDocument;
import xmlbeans.pl.edu.icm.uvos.internal.GroupDocument;
import xmlbeans.pl.edu.icm.uvos.internal.IdentityDocument;
import xmlbeans.pl.edu.icm.uvos.internal.NamesListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.NamesListType;
import xmlbeans.pl.edu.icm.uvos.internal.NotificationListDocument;

@WebService(endpointInterface="pl.edu.icm.unicore.uvos.wsapi.WSManagementInterface")
public class WSManagementImpl
implements WSManagementInterface {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", WSManagementImpl.class);
    private UVOSManagementInterface voMan;
    private Authenticator authenticator;

    public WSManagementImpl(UVOSManagementInterface voMan, Authenticator auth) throws InternalException {
        this.voMan = voMan;
        this.authenticator = auth;
    }

    public GroupDocument addGroup(GroupDocument parent, String name) throws UVOSFault {
        try {
            log.debug((Object)"AddGroup invoked");
            this.authenticator.authenticate();
            Group mparent = XMLBeansMapper.map2APIGroup((GroupDocument)parent);
            Group newG = this.voMan.addGroup(mparent, name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added group: " + newG));
            }
            return XMLBeansMapper.map2XMLGroupDoc((Group)newG);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking addGroup: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void removeGroup(GroupDocument toRemove, boolean recursive) throws UVOSFault {
        try {
            log.debug((Object)"RemoveGroup invoked");
            this.authenticator.authenticate();
            Group g = XMLBeansMapper.map2APIGroup((GroupDocument)toRemove);
            this.voMan.removeGroup(g, recursive);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed group " + g));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking removeGroup: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public GroupDocument copyGroup(GroupDocument toCopy, GroupDocument newParent, String newName, boolean deleteOrig) throws UVOSFault {
        try {
            log.debug((Object)"CopyGroup invoked");
            this.authenticator.authenticate();
            Group src = XMLBeansMapper.map2APIGroup((GroupDocument)toCopy);
            Group dst = XMLBeansMapper.map2APIGroup((GroupDocument)newParent);
            Group moved = this.voMan.copyGroup(src, dst, newName, deleteOrig);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Copied group " + src + " to " + dst));
            }
            return XMLBeansMapper.map2XMLGroupDoc((Group)moved);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking copyGroup: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void addIdentity(IdentityDocument toAdd) throws UVOSFault {
        try {
            log.debug((Object)"AddIdentity invoked");
            this.authenticator.authenticate();
            Identity id = XMLBeansMapper.map2APIIdentity((IdentityDocument)toAdd);
            this.voMan.addIdentity(id);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added identity " + id.prettyString()));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking addIdentity: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void addIdentity(IdentityDocument toAdd, IdentityDocument equivalentIdentity) throws UVOSFault {
        try {
            log.debug((Object)"AddIdentity (with equiv) invoked");
            this.authenticator.authenticate();
            Identity id = XMLBeansMapper.map2APIIdentity((IdentityDocument)toAdd);
            Identity eq = XMLBeansMapper.map2APIIdentity((IdentityDocument)equivalentIdentity);
            this.voMan.addIdentity(id, eq);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added identity " + id.prettyString() + " as equivalent to the " + eq.prettyString()));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking addIdentity: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void removeIdentity(IdentityDocument toRemove) throws UVOSFault {
        try {
            log.debug((Object)"RemoveIdentity invoked");
            this.authenticator.authenticate();
            Identity id = XMLBeansMapper.map2APIIdentity((IdentityDocument)toRemove);
            this.voMan.removeIdentity(id);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed identity " + id.prettyString()));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking removeIdentity: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void setAttribute(ElementDocument whom, AttributeDocument toAdd, boolean update) throws UVOSFault {
        try {
            log.debug((Object)"SetAttribute invoked");
            this.authenticator.authenticate();
            Element el = XMLBeansMapper.map2APIElement((ElementDocument)whom);
            Attribute at = XMLBeansMapper.map2APIAttribute((AttributeDocument)toAdd);
            this.voMan.setAttribute(el, at, update);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set " + el.prettyString() + " attribute " + at));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking setAttribute: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
        catch (XmlException e) {
            log.info((Object)("Error invoking setAttribute: " + (Object)((Object)e)));
            throw new UVOSFault((UVOSException)((Object)new InvalidValueException(e.getMessage())));
        }
    }

    public void removeAttribute(ElementDocument whom, String toRemove) throws UVOSFault {
        try {
            log.debug((Object)"RemoveAttribute invoked");
            this.authenticator.authenticate();
            Element el = XMLBeansMapper.map2APIElement((ElementDocument)whom);
            this.voMan.removeAttribute(el, toRemove);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed " + el.prettyString() + " attribute " + toRemove));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking removeAttribute: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void addToGroup(IdentityDocument toAdd, GroupDocument group) throws UVOSFault {
        try {
            log.debug((Object)"AddToGroup invoked");
            this.authenticator.authenticate();
            Identity id = XMLBeansMapper.map2APIIdentity((IdentityDocument)toAdd);
            Group g = XMLBeansMapper.map2APIGroup((GroupDocument)group);
            this.voMan.addToGroup(id, g);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added " + id.prettyString() + " to group " + g));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking addToGroup: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void removeFromGroup(IdentityDocument toRemove, GroupDocument group) throws UVOSFault {
        try {
            log.debug((Object)"RemoveFromGroup invoked");
            this.authenticator.authenticate();
            Identity id = XMLBeansMapper.map2APIIdentity((IdentityDocument)toRemove);
            Group g = XMLBeansMapper.map2APIGroup((GroupDocument)group);
            this.voMan.removeFromGroup(id, g);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed " + id.prettyString() + " from group " + g));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking removeFromGroup: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void setIdentityLabel(IdentityDocument toChange, String label) throws UVOSFault {
        try {
            log.debug((Object)"SetIdentityLabel invoked");
            this.authenticator.authenticate();
            Identity id = XMLBeansMapper.map2APIIdentity((IdentityDocument)toChange);
            this.voMan.setIdentityLabel(id, label);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Identity " + id.prettyString() + " label was changed to " + label));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking setIdentityLabel: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public AttributesListDocument getAttributeTypes() throws UVOSFault {
        try {
            log.debug((Object)"GetAttributeTypes invoked");
            this.authenticator.authenticate();
            List<AttributeType> rawRet = this.voMan.getAttributeTypes();
            AttributesListDocument retDoc = AttributesListDocument.Factory.newInstance();
            AttributesListType ret = retDoc.addNewAttributesList();
            for (AttributeType idT : rawRet) {
                AttributeXType vv = ret.addNewElement();
                vv.setName(idT.toString());
                vv.setDescription(idT.getDescription());
                vv.setShortDescription(idT.getShortDescription());
            }
            return retDoc;
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getAttributeTypes: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public NamesListDocument getIdentityTypes() throws UVOSFault {
        try {
            log.debug((Object)"GetIdentityTypes invoked");
            this.authenticator.authenticate();
            List<IdentityType> rawRet = this.voMan.getIdentityTypes();
            NamesListDocument retDoc = NamesListDocument.Factory.newInstance();
            NamesListType ret = retDoc.addNewNamesList();
            for (IdentityType idT : rawRet) {
                ret.addElement(idT.toString());
            }
            return retDoc;
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getIdentityTypes: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void disableAttribute(ElementDocument whose, String toDisable, String valueToDisable) throws UVOSFault {
        try {
            log.debug((Object)"DisableAttribute invoked");
            this.authenticator.authenticate();
            Element el = XMLBeansMapper.map2APIElement((ElementDocument)whose);
            this.voMan.disableAttribute(el, toDisable, valueToDisable);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Disabled " + el.prettyString() + " attribute named " + toDisable + " value " + valueToDisable));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking disableAttribute: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void enableAttribute(ElementDocument whose, String toEnable, String valueToEnable) throws UVOSFault {
        try {
            log.debug((Object)"EnableAttribute invoked");
            this.authenticator.authenticate();
            Element el = XMLBeansMapper.map2APIElement((ElementDocument)whose);
            this.voMan.enableAttribute(el, toEnable, valueToEnable);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Disabled " + el.prettyString() + " attribute named " + toEnable + " value " + valueToEnable));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking enableAttribute: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public AttributesListDocument getDisabledAttributes(ElementDocument whose) throws UVOSFault {
        try {
            log.debug((Object)"GetDisabledAttributes invoked");
            this.authenticator.authenticate();
            List<Attribute> rawRet = this.voMan.getDisabledAttributes(XMLBeansMapper.map2APIElement((ElementDocument)whose));
            return XMLBeansMapper.map2XMLAttributesList(rawRet);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getDisabledAttributes: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void purgeHistoricalData(Calendar arg0) throws UVOSFault {
        try {
            log.debug((Object)"PurgeHistoricalData invoked");
            this.authenticator.authenticate();
            this.voMan.purgeHistoricalData(XMLBeansMapper.c2d((Calendar)arg0));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Historical data older than " + arg0.toString() + " was deleted."));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking purgeHistoricalData: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void updateAttributeTypes(AttributesListDocument toUpdate, boolean clear) throws UVOSFault {
        try {
            log.debug((Object)"UpadteAttributeTypes invoked");
            this.authenticator.authenticate();
            this.voMan.updateAttributeTypes(XMLBeansMapper.map2APIAttributeTypesList((AttributesListDocument)toUpdate), clear);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking updateAttributeTypes: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void setIdentityStatus(IdentityDocument toUpdate, boolean how) throws UVOSFault {
        try {
            log.debug((Object)"SetIdentityStatus invoked");
            this.authenticator.authenticate();
            Identity id = XMLBeansMapper.map2APIIdentity((IdentityDocument)toUpdate);
            this.voMan.setIdentityStatus(id, how);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Identity " + id.prettyString() + " status is now " + (how ? "ENABLED" : "DISABLED")));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking setIdentityStatus: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void addNotification(String action, String receipents, String groupFilter) throws UVOSFault {
        try {
            log.debug((Object)"AddNotification invoked");
            this.authenticator.authenticate();
            this.voMan.addNotification(action, receipents, groupFilter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added notififcation for action " + action + " with group filter " + groupFilter + " which will be send to " + receipents));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking addNotification: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public NotificationListDocument getNotifications(String action, String groupFilter) throws UVOSFault {
        try {
            log.debug((Object)"GetNotifications invoked");
            this.authenticator.authenticate();
            return XMLBeansMapper.map2XMLNotificationsList(this.voMan.getNotifications(action, groupFilter));
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getNotifications: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void removeNotification(int id) throws UVOSFault {
        try {
            log.debug((Object)"RemoveNotification invoked");
            this.authenticator.authenticate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed notification id " + id));
            }
            this.voMan.removeNotification(id);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking removeNotification: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }
}

