/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server;

import eu.unicore.util.Log;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import pl.edu.icm.unicore.uvos.api.AttributePermission;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.PermissionDesignator;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.engine.api.UVOSAuthZInterface;
import pl.edu.icm.unicore.uvos.server.idresolver.Authenticator;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSAuthZInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.XMLBeansMapper;
import xmlbeans.pl.edu.icm.uvos.internal.AttributePermissionXType;
import xmlbeans.pl.edu.icm.uvos.internal.AttributePermissionsListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.AttributePermissionsListType;
import xmlbeans.pl.edu.icm.uvos.internal.GroupDocument;
import xmlbeans.pl.edu.icm.uvos.internal.IdentitiesListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.IdentityDocument;
import xmlbeans.pl.edu.icm.uvos.internal.PermissionsDesignatorDocument;
import xmlbeans.pl.edu.icm.uvos.internal.PermissionsDesignatorXType;
import xmlbeans.pl.edu.icm.uvos.internal.PermissionsDocument;
import xmlbeans.pl.edu.icm.uvos.internal.PermissionsXType;

@WebService(endpointInterface="pl.edu.icm.unicore.uvos.wsapi.WSAuthZInterface")
public class WSAuthZImpl
implements WSAuthZInterface {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", WSAuthZImpl.class);
    private UVOSAuthZInterface voAuthz;
    private Authenticator authenticator;

    public WSAuthZImpl(UVOSAuthZInterface voAuthz, Authenticator auth) throws InternalException {
        this.voAuthz = voAuthz;
        this.authenticator = auth;
    }

    public PermissionsDocument checkPermissions(GroupDocument arg0, IdentityDocument arg1) throws UVOSFault {
        try {
            log.debug((Object)"checkPermissions invoked");
            this.authenticator.authenticate();
            return XMLBeansMapper.map2XMLPermissionsDoc((Permissions)this.voAuthz.checkPermissions(XMLBeansMapper.map2APIGroup((GroupDocument)arg0), XMLBeansMapper.map2APIIdentity((IdentityDocument)arg1)));
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking checkPermissions: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public AttributePermissionsListDocument getGroupAuthZ(GroupDocument arg0, boolean arg1) throws UVOSFault {
        try {
            log.debug((Object)"getGroupAuthZ invoked");
            this.authenticator.authenticate();
            List<AttributePermission> raw = this.voAuthz.getGroupAuthZ(XMLBeansMapper.map2APIGroup((GroupDocument)arg0), arg1);
            AttributePermissionsListDocument retDoc = AttributePermissionsListDocument.Factory.newInstance();
            AttributePermissionsListType ret = retDoc.addNewAttributePermissionsList();
            AttributePermissionXType[] array = new AttributePermissionXType[raw.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = XMLBeansMapper.map2XMLAttrPerm((AttributePermission)raw.get(i));
            }
            ret.setElementArray(array);
            return retDoc;
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getGroupAuthZ: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void modifyAuthenticationData(IdentityDocument arg0, String arg1) throws UVOSFault {
        try {
            log.debug((Object)"modifyAuthenticationData invoked");
            this.authenticator.authenticate();
            Identity id = XMLBeansMapper.map2APIIdentity((IdentityDocument)arg0);
            this.voAuthz.modifyAuthenticationData(id, arg1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Modified authentication data of " + id.prettyString()));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking modifyAuthenticationData: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void modifyPermissions(GroupDocument arg0, PermissionsDesignatorDocument arg1, PermissionsDocument arg2) throws UVOSFault {
        try {
            log.debug((Object)"modifyPermissions invoked");
            this.authenticator.authenticate();
            Group g = XMLBeansMapper.map2APIGroup((GroupDocument)arg0);
            PermissionDesignator pd = XMLBeansMapper.map2APIDesignator((PermissionsDesignatorXType)arg1.getPermissionsDesignator());
            Permissions perm = XMLBeansMapper.map2APIPermissions((PermissionsXType)arg2.getPermissions());
            this.voAuthz.modifyPermissions(g, pd, perm);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Modified group " + g + " permissions; designator " + pd + " permissions set to " + perm));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking modifyPermissions: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
        catch (XmlException e) {
            log.info((Object)("Error invoking modifyPermissions: " + e.getMessage()));
            throw new UVOSFault((UVOSException)((Object)new InvalidValueException(e.getMessage())));
        }
    }

    public IdentitiesListDocument getMyIdentities() throws UVOSFault {
        try {
            log.debug((Object)"getMyIdentities invoked");
            this.authenticator.authenticate();
            return XMLBeansMapper.map2XMLIdentitiesList(this.voAuthz.getMyIdentities());
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getMyIdentities: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }
}

