/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server;

import eu.unicore.util.Log;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import pl.edu.icm.unicore.uvos.api.ApplicationActions;
import pl.edu.icm.unicore.uvos.api.VOApplication;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.api.exceptions.VOApplicationException;
import pl.edu.icm.unicore.uvos.engine.api.VOApplicationInterface;
import pl.edu.icm.unicore.uvos.server.idresolver.Authenticator;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSApplicationsInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.XMLBeansMapper;
import xmlbeans.pl.edu.icm.uvos.internal.app.ProcessVOApplicationDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.ProcessVOApplicationType;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationFormDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationFormListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationListDocument;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationType;

@WebService(endpointInterface="pl.edu.icm.unicore.uvos.wsapi.WSApplicationsInterface")
public class WSApplicationsImpl
implements WSApplicationsInterface {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", WSApplicationsImpl.class);
    private VOApplicationInterface voApps;
    private Authenticator authenticator;

    public WSApplicationsImpl(VOApplicationInterface voApps, Authenticator authenticator) throws InternalException {
        this.voApps = voApps;
        this.authenticator = authenticator;
    }

    public VOApplicationFormListDocument getApplicationForms() throws UVOSFault {
        try {
            log.debug((Object)"getApplicationForms invoked");
            this.authenticator.authenticate();
            return XMLBeansMapper.map2XMLVOApplicationFormList(this.voApps.getApplicationForms());
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getApplicationForms: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
        catch (XmlException e) {
            log.info((Object)"Error invoking getApplicationForms: Unparseable constraints");
            throw new UVOSFault((UVOSException)new VOApplicationException("Unparseable constraints"));
        }
    }

    public void removeApplicationForm(int id) throws UVOSFault {
        try {
            log.debug((Object)"removeApplicationForm invoked");
            this.authenticator.authenticate();
            this.voApps.removeApplicationForm(id);
            log.debug((Object)("Removed application form with id " + id));
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking removeApplicationForm: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void updateApplicationForm(VOApplicationFormDocument applicationDef, boolean update) throws UVOSFault {
        try {
            log.debug((Object)"updateApplicationForm invoked");
            this.authenticator.authenticate();
            this.voApps.updateApplicationForm(XMLBeansMapper.map2APIVOApplicationForm((VOApplicationFormDocument)applicationDef), update);
            if (log.isDebugEnabled()) {
                log.debug((Object)((update ? "Updated" : "Created") + " application form " + applicationDef.xmlText()));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking updateApplicationForm: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public void submitApplication(VOApplicationDocument application) throws UVOSFault {
        try {
            log.debug((Object)"submitApplication invoked");
            this.authenticator.authenticate();
            this.voApps.submitApplication(XMLBeansMapper.map2APIVOApplication((VOApplicationDocument)application));
            if (log.isDebugEnabled()) {
                log.debug((Object)("A new application was submitted: " + application.xmlText()));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking submitApplication: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }

    public VOApplicationListDocument getApplications(Integer formId, String status) throws UVOSFault {
        try {
            log.debug((Object)"getApplications invoked");
            this.authenticator.authenticate();
            List<VOApplication> ret = this.voApps.getApplications(formId, status);
            return XMLBeansMapper.map2XMLVOApplicationList(ret);
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking getApplications: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
        catch (XmlException e) {
            log.info((Object)"Error invoking getApplications: Unparseable request details");
            throw new UVOSFault((UVOSException)new VOApplicationException("Unparseable request details"));
        }
    }

    public void processApplication(ProcessVOApplicationDocument orderDoc) throws UVOSFault {
        ProcessVOApplicationType order = orderDoc.getProcessVOApplication();
        try {
            log.debug((Object)"processApplication invoked");
            this.authenticator.authenticate();
            this.voApps.processApplication(order.getApplicationId(), ApplicationActions.valueOf((String)order.getAction().toString()), order.getNotes(), order.getSendConfirmation(), order.getUpdatedApplication() == null ? null : XMLBeansMapper.map2APIVOApplication((VOApplicationType)order.getUpdatedApplication()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processed application " + order.getApplicationId() + ": action is " + order.getAction().toString() + ", note is " + order.getNotes()));
            }
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking processApplication: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
        catch (IllegalArgumentException e) {
            String msg = "Action is invalid: " + order.getAction().toString();
            log.info((Object)("Error invoking processApplication: " + msg));
            throw new UVOSFault((UVOSException)new VOApplicationException(msg));
        }
    }

    public void csrProcessedNotification(String csr, boolean accepted, String certificate, boolean sendNotification) throws UVOSFault {
        try {
            log.debug((Object)"csrProcessedNotification invoked");
            this.authenticator.authenticate();
            this.voApps.csrProcessedNotification(csr, accepted, certificate, sendNotification);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Proccessed a CSR application. CSR was " + (accepted ? "accepted" : "rejected")));
            }
            log.trace((Object)("Certificate issued to CSR is\n" + certificate));
        }
        catch (UVOSException e) {
            log.info((Object)("Error invoking csrProcessedNotification: " + (Object)((Object)e)));
            throw new UVOSFault(e);
        }
    }
}

