/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.unicore.security.xfireutil.AuthInHandler;
import eu.unicore.security.xfireutil.ETDInHandler;
import eu.unicore.util.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.invoker.BeanInvoker;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderFactory;
import org.codehaus.xfire.xmlbeans.XmlBeansTypeRegistry;
import org.codehaus.xfire.xmlbeans.XmlBeansWSDLBuilderFactory;
import org.picocontainer.PicoContainer;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.registration.EMIRHandler;
import pl.edu.icm.unicore.uvos.registration.RegistrationHandler;
import pl.edu.icm.unicore.uvos.server.ComponentContainer;
import pl.edu.icm.unicore.uvos.server.JettyServer;
import pl.edu.icm.unicore.uvos.util.AttributeTypesLoader;
import pl.edu.icm.unicore.uvos.util.LogFileWatcher;
import pl.edu.icm.unicore.uvos.util.ThreadScheduler;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.CISInfoProvider;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLAuthnInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLNameIdMappingInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLQueryInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSApplicationsInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSAuthZInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSManagementInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSQueryHistoryInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.WSQueryInterface;

public class VOServer {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", VOServer.class);
    public static final String CONFIGURATION_FILE = "conf/uvosServer.conf";
    private ThreadScheduler serverScheduler;
    private UVOSServerProperties c;
    private XFire xfire;
    private AnnotationServiceFactory asf;
    private SAMLQueryInterface samlQuery;
    private SAMLNameIdMappingInterface samlNameIdMapping;
    private SAMLAuthnInterface samlAuthn;
    private WSManagementInterface wsManagement;
    private WSAuthZInterface wsAuthZ;
    private WSQueryInterface wsQuery;
    private WSQueryHistoryInterface wsQueryHistory;
    private WSApplicationsInterface wsApplications;
    private CISInfoProvider wsGLUEInfoProvider;
    private EMIRHandler emirHandler;
    private DB db;
    private JettyServer jetty;

    public UVOSServerProperties getConfiguration() {
        return this.c;
    }

    public VOServer(UVOSServerProperties config, SAMLQueryInterface samlQuery, SAMLNameIdMappingInterface samlNameIdMapping, SAMLAuthnInterface samlAuthn, WSManagementInterface wsManagement, WSAuthZInterface wsAuthZ, WSQueryInterface wsQuery, WSQueryHistoryInterface wsQueryHistory, WSApplicationsInterface wsApplications, CISInfoProvider wsGLUEInfoProvider, EMIRHandler emirHandler, DB db, ThreadScheduler timer) throws FileNotFoundException, IOException {
        this.c = config;
        this.samlQuery = samlQuery;
        this.samlNameIdMapping = samlNameIdMapping;
        this.samlAuthn = samlAuthn;
        this.wsManagement = wsManagement;
        this.wsAuthZ = wsAuthZ;
        this.wsQuery = wsQuery;
        this.wsQueryHistory = wsQueryHistory;
        this.wsApplications = wsApplications;
        this.wsGLUEInfoProvider = wsGLUEInfoProvider;
        this.emirHandler = emirHandler;
        this.db = db;
        this.serverScheduler = timer;
    }

    protected VOServer(UVOSServerProperties config) throws FileNotFoundException, IOException {
        this.c = config;
    }

    public void startup(PicoContainer pico) throws Exception {
        LogFileWatcher.startLogConfigWatcher(this.serverScheduler.getScheduledExecutor());
        AttributeTypesLoader attributeLoader = (AttributeTypesLoader)pico.getComponent(AttributeTypesLoader.class);
        attributeLoader.load();
        log.info((Object)"Initializing web service engine...");
        this.initXFire();
        log.info((Object)"Configuring services...");
        this.configureServices();
        log.info((Object)"Starting HTTP server...");
        this.startJetty(pico);
        this.addToRegistries();
    }

    private void configureServices() throws InternalException {
        this.configureService(SAMLQueryInterface.class, this.samlQuery);
        this.configureService(SAMLNameIdMappingInterface.class, this.samlNameIdMapping);
        this.configureService(SAMLAuthnInterface.class, this.samlAuthn);
        this.configureService(WSManagementInterface.class, this.wsManagement);
        this.configureService(WSAuthZInterface.class, this.wsAuthZ);
        this.configureService(WSQueryInterface.class, this.wsQuery);
        this.configureService(WSQueryHistoryInterface.class, this.wsQueryHistory);
        this.configureService(WSApplicationsInterface.class, this.wsApplications);
        this.configureService(CISInfoProvider.class, this.wsGLUEInfoProvider);
    }

    private void configureService(Class<?> iface, Object impl) {
        Service service = this.asf.create(iface);
        service.setProperty("xmlbeans-namespace-hack", (Object)"true");
        service.setInvoker((Invoker)new BeanInvoker(impl));
        this.xfire.getServiceRegistry().register(service);
        service.addInHandler((Handler)new AuthInHandler(false, true, true, null));
        if (this.c.getBooleanValue("authn.enableETD").booleanValue()) {
            service.addInHandler((Handler)new ETDInHandler(null, (X509CertChainValidator)this.c.getAuthAndTrust().getValidator()));
        }
    }

    private void initXFire() {
        this.xfire = XFireFactory.newInstance().getXFire();
        this.asf = new AnnotationServiceFactory();
        AegisBindingProvider provider = new AegisBindingProvider((TypeMappingRegistry)new XmlBeansTypeRegistry());
        this.asf.setBindingProvider((BindingProvider)provider);
        this.asf.setWsdlBuilderFactory((WSDLBuilderFactory)new XmlBeansWSDLBuilderFactory());
    }

    private void startJetty(PicoContainer pico) throws Exception {
        this.jetty = new JettyServer(this.c, pico);
        this.jetty.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                VOServer.this.shutdown();
            }
        });
    }

    public void doShutdown() throws Exception {
        this.db.shutdown();
        this.jetty.stop();
    }

    void shutdown() {
        try {
            DateFormat df = DateFormat.getDateTimeInstance(2, 1);
            System.out.println(df.format(new Date()) + ": Stopping UVOS Web Server");
            log.info((Object)"\n**************************\nStopping UVOS Web Server\n**************************");
            this.doShutdown();
            log.info((Object)"\n**************************\nStopped UVOS Web Server\n**************************");
        }
        catch (Exception e) {
            System.err.println("Severe error when cleaning up UVOS Web Server:");
            e.printStackTrace();
        }
    }

    private void addToRegistries() {
        String v;
        this.emirHandler.start();
        boolean doRegister = this.c.getBooleanValue("useExternalRegistry");
        if (!doRegister) {
            return;
        }
        log.info((Object)"Configuring registration in UNICORE registries");
        ArrayList<String> registries = new ArrayList<String>();
        String key = "externalRegistryUrl.";
        int i = 1;
        while ((v = this.c.getValue(key + "." + i)) != null) {
            registries.add(v);
            ++i;
        }
        if (registries.size() == 0) {
            log.warn((Object)"Registration in external registry is turned ON but no registry address is configured. Define 'externalRegistryUrl..1' property.");
            return;
        }
        RegistrationHandler regHandler = new RegistrationHandler(registries, this.c, this.serverScheduler);
        regHandler.start();
    }

    static VOServer initializeDI(String[] args) throws Exception {
        DateFormat df = DateFormat.getDateTimeInstance(2, 1);
        System.out.println(df.format(new Date()) + ": Starting UVOS Web Server");
        log.info((Object)"\n**************************\nStarting UVOS Web Server\n**************************");
        String configFile = CONFIGURATION_FILE;
        if (args.length > 0) {
            configFile = args[0];
        }
        log.debug((Object)("Using configuration file: " + configFile));
        ComponentContainer container = new ComponentContainer(configFile);
        VOServer serverInstance = container.getComponent(VOServer.class);
        serverInstance.startup(container.getContainer());
        log.info((Object)"\n**************************\nUVOS Web Server is STARTED\n**************************");
        System.out.println(df.format(new Date()) + ": Started UVOS Web Server");
        return serverInstance;
    }

    public static void main(String[] args) {
        try {
            VOServer.initializeDI(args);
        }
        catch (Throwable e) {
            System.err.println("Severe error when starting UVOS Web Server:");
            e.printStackTrace();
            log.fatal((Object)"Severe error when starting UVOS Web Server", e);
            System.exit(-1);
            throw new RuntimeException("Dummy, can't happen");
        }
    }
}

