/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server;

import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.jetty.JettyServerBase;
import java.io.File;
import java.net.URL;
import org.codehaus.xfire.transport.http.XFireServlet;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.picocontainer.PicoContainer;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class JettyServer
extends JettyServerBase {
    public static final String UVOS_SERVER_CONTAINER_REFERENCE = "uvos.container.ref";
    private String webappsDir;
    private String webappsTmpDir;
    private PicoContainer picoReference;

    public JettyServer(UVOSServerProperties conf, PicoContainer pico) throws Exception {
        super(JettyServer.createURLs(conf), conf.getAuthAndTrust(), conf.getJettyProperties(), null);
        this.picoReference = pico;
        this.webappsDir = conf.getValue("webappsDir");
        this.webappsTmpDir = System.getProperty("java.io.tmpdir") + File.separator + "uvos-webappstmp";
        File f = new File(this.webappsTmpDir);
        if (!f.exists()) {
            f.mkdir();
        }
        this.initServer();
    }

    private static URL[] createURLs(UVOSServerProperties conf) throws Exception {
        boolean plain = conf.getBooleanValue("http.enable");
        boolean ssl = conf.getBooleanValue("https.enable");
        if (!plain && !ssl) {
            throw new Exception("No one connector is enabled");
        }
        URL[] ret = plain && ssl ? new URL[2] : new URL[1];
        int i = 0;
        if (plain) {
            ret[i++] = new URL("http://" + conf.getValue("http.host") + ":" + conf.getValue("http.port"));
        }
        if (ssl) {
            ret[i++] = new URL("https://" + conf.getValue("https.host") + ":" + conf.getValue("https.port"));
        }
        return ret;
    }

    protected Handler createRootHandler() throws ConfigurationException {
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.getServer(), "/", 1);
        root.addServlet(XFireServlet.class, "/*");
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{contexts, root, new DefaultHandler(), requestLogHandler});
        WebAppProvider provider = new WebAppProvider();
        provider.setParentLoaderPriority(false);
        provider.setExtractWars(true);
        provider.setMonitoredDirName(this.webappsDir);
        provider.setTempDir(new File(this.webappsTmpDir));
        provider.setScanInterval(10);
        DeploymentManager deployManager = new DeploymentManager();
        deployManager.addAppProvider((AppProvider)provider);
        deployManager.setContexts(contexts);
        deployManager.setContextAttribute(UVOS_SERVER_CONTAINER_REFERENCE, (Object)this.picoReference);
        this.getServer().addBean((Object)deployManager);
        return handlers;
    }
}

