/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.server;

import eu.unicore.util.Log;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.server.IssuerIdentityProvider;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class IssuerIdentityProviderImpl
implements IssuerIdentityProvider {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", IssuerIdentityProviderImpl.class);
    private String issuerURI;

    public IssuerIdentityProviderImpl(UVOSServerProperties config) throws Exception {
        this.issuerURI = this.establishServerURI(config);
    }

    @Override
    public String getIssuerURI() {
        return this.issuerURI;
    }

    private String establishServerURI(UVOSServerProperties config) {
        String fqdn;
        String uri = config.getValue("saml.issuerURI");
        if (uri == null) {
            log.info((Object)"No uvos.server.saml.issuerURI is set. Will try to guess it.");
        } else {
            try {
                new URI(uri);
                return uri;
            }
            catch (URISyntaxException e) {
                log.info((Object)("saml.issuerURI is set but is invalid (isn't a URI): " + e.getMessage() + ". Will try to guess it."));
            }
        }
        boolean ssl = config.getBooleanValue("https.enable");
        try {
            InetAddress addr = InetAddress.getLocalHost();
            fqdn = addr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Can't determine host domain name and the issuer URI isn't specified. Will do the best to produce the the URL butit may be incorrect.");
            fqdn = ssl ? config.getValue("https.host") : config.getValue("http.host");
        }
        int port = -1;
        port = ssl ? config.getIntValue("https.port").intValue() : config.getIntValue("http.port").intValue();
        uri = "http://" + fqdn + ":" + port;
        log.info((Object)("Will use autogenerated server's URI: " + uri));
        return uri;
    }
}

