/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.saml;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.exceptions.SAMLRequestException;
import eu.unicore.samly2.proto.AbstractSAMLMessage;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.util.Log;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.SecurityException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.saml.SAMLConfiguration;
import pl.edu.icm.unicore.uvos.server.IssuerIdentityProvider;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;
import xmlbeans.org.oasis.saml2.protocol.RequestAbstractType;

public abstract class SAMLUtil {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", SAMLUtil.class);
    public static final String ID_PREFIX = "uvosSaml";
    protected SAMLConfiguration samlConfiguration;
    protected RequestAbstractType request;
    protected IssuerIdentityProvider secProvier;
    protected Calendar issueInstant;

    public SAMLUtil(RequestAbstractType req, IssuerIdentityProvider secProvider, UVOSServerProperties conf, SAMLConfiguration samlConfig) {
        this.samlConfiguration = samlConfig;
        this.request = req;
        this.secProvier = secProvider;
        this.issueInstant = req.getIssueInstant();
    }

    public SAMLUtil(IssuerIdentityProvider secProvider, UVOSServerProperties conf) {
        this.secProvier = secProvider;
    }

    public NameIDType getRequestIssuerRaw() {
        return this.request.getIssuer();
    }

    public Identity getRequestIssuer() throws SAMLRequestException {
        NameIDType xmlIssuer = this.request.getIssuer();
        return this.mapNameID(xmlIssuer);
    }

    public NameID getIssuer() {
        return SAMLUtil.getIssuer(this.secProvier);
    }

    public static NameID getIssuer(IssuerIdentityProvider sec) {
        String uri = sec.getIssuerURI();
        return new NameID(uri, "urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
    }

    public void checkRequestValidity(int validityPeriod) throws SAMLProtocolException {
        if (this.issueInstant == null) {
            throw new SAMLProtocolException("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "No issueInstant attribute");
        }
        Calendar cur = Calendar.getInstance();
        cur.setLenient(true);
        cur.add(13, -validityPeriod);
        if (this.issueInstant.before(cur)) {
            throw new SAMLProtocolException("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "Request is too old");
        }
    }

    public abstract X509Certificate[] getIssuerIdentityFromSignature() throws DSigException;

    public abstract void parse() throws SAMLProtocolException;

    protected X509Certificate[] getIssuerIdentityFromSignature(AbstractSAMLMessage query) throws DSigException {
        if (!query.isSigned()) {
            return null;
        }
        X509Certificate[] issuerCC = query.getIssuerFromSignature();
        if (issuerCC == null) {
            return null;
        }
        if (!query.isCorrectlySigned(issuerCC[0].getPublicKey())) {
            throw new DSigException("Invalid signature");
        }
        return issuerCC;
    }

    protected SAMLProtocolException convert2SAMLError(UVOSException e, String msg, boolean useExDetail) throws UVOSFault {
        String code;
        String subcode = null;
        String message = null;
        if (msg != null) {
            message = msg;
        }
        if (msg == null && useExDetail) {
            message = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
        }
        if (e instanceof IdentityNotKnownException) {
            code = "urn:oasis:names:tc:SAML:2.0:status:Requester";
            subcode = "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipial";
        } else if (e instanceof AuthenticationException) {
            code = "urn:oasis:names:tc:SAML:2.0:status:Requester";
            subcode = "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed";
        } else if (e instanceof InvalidValueException) {
            code = "urn:oasis:names:tc:SAML:2.0:status:Requester";
            subcode = "urn:oasis:names:tc:SAML:2.0:status:InvalidAttrNameOrValue";
        } else {
            if (e instanceof InternalException) {
                throw new UVOSFault((UVOSException)((InternalException)e));
            }
            if (e instanceof SecurityException) {
                code = "urn:oasis:names:tc:SAML:2.0:status:Requester";
                subcode = "urn:oasis:names:tc:SAML:2.0:status:RequestDenied";
            } else {
                log.warn((Object)("Producing SAML error for unknown exception: " + e.getClass()));
                code = "urn:oasis:names:tc:SAML:2.0:status:Responder";
            }
        }
        SAMLProtocolException ret = new SAMLProtocolException(code, subcode, message);
        return ret;
    }

    protected Identity mapSubject(SubjectType subject) throws SAMLRequestException {
        NameIDType nameId = subject.getNameID();
        if (nameId == null) {
            if (subject.getEncryptedID() != null || subject.getBaseID() != null) {
                throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", "Only NameId subjects are supported");
            }
            throw new SAMLRequestException(null, "Empty subject is invalid");
        }
        return this.mapNameID(nameId);
    }

    protected Identity mapNameID(NameIDType nameId) throws SAMLRequestException {
        String nameValue;
        String format = nameId.getFormat();
        if (format == null) {
            format = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        if ((nameValue = nameId.getStringValue()) == null) {
            throw new SAMLRequestException(null, "Empty nameId is invalid");
        }
        IdentityType idType = null;
        if (format.equals(IdentityType.DN.toString())) {
            idType = IdentityType.DN;
        } else if (format.equals(IdentityType.EMAIL.toString())) {
            idType = IdentityType.EMAIL;
        } else if (format.equals(IdentityType.X509CERT.toString())) {
            idType = IdentityType.X509CERT;
        } else {
            throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipial", "Unknown nameId format: " + format);
        }
        Identity ret = new Identity(idType, nameValue, null);
        return ret;
    }

    public Calendar getIssueInstant() {
        return this.issueInstant;
    }
}

