/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.saml;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.elements.NameIDPolicy;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.proto.AbstractSAMLMessage;
import eu.unicore.samly2.proto.NameIDMappingRequest;
import eu.unicore.samly2.proto.NameIDMappingResponse;
import eu.unicore.security.dsig.DSigException;
import java.security.cert.X509Certificate;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.saml.SAMLConfiguration;
import pl.edu.icm.unicore.uvos.saml.SAMLUtil;
import pl.edu.icm.unicore.uvos.server.IssuerIdentityProvider;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingRequestDocument;
import xmlbeans.org.oasis.saml2.protocol.RequestAbstractType;

public class SAMLNameMappingUtil
extends SAMLUtil {
    private NameIDMappingRequestDocument requestDoc;
    private NameIDMappingRequest req;
    private String requestedFormat;
    private Identity originalIdentity;

    public SAMLNameMappingUtil(NameIDMappingRequestDocument request, IssuerIdentityProvider secProvider, UVOSServerProperties conf, SAMLConfiguration samlConfig) {
        super((RequestAbstractType)request.getNameIDMappingRequest(), secProvider, conf, samlConfig);
        this.requestDoc = request;
    }

    @Override
    public void parse() throws SAMLProtocolException {
        this.req = new NameIDMappingRequest(this.requestDoc);
        NameIDPolicy policy = this.req.getPolicy();
        this.requestedFormat = policy.getXBean().getFormat();
        if (this.requestedFormat == null) {
            this.requestedFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        this.originalIdentity = this.mapNameID(this.req.getNameToMap().getXBean());
    }

    public Identity getOriginalIdentity() {
        return this.originalIdentity;
    }

    public String getRequestedFormat() {
        return this.requestedFormat;
    }

    public NameIDMappingResponse getOKResponse(NameID mapped) {
        return new NameIDMappingResponse(this.getIssuer(), this.req.getID(), mapped);
    }

    public NameIDMappingResponse getErrorResponse(SAMLProtocolException e) {
        return new NameIDMappingResponse(this.getIssuer(), this.req.getID(), e);
    }

    public NameIDMappingResponse getErrorResponse(UVOSException e, String message) throws UVOSFault {
        return this.getErrorResponse(this.convert2SAMLError(e, message, false));
    }

    public NameIDMappingResponse getErrorResponse(UVOSException e) throws UVOSFault {
        return this.getErrorResponse(this.convert2SAMLError(e, null, true));
    }

    @Override
    public X509Certificate[] getIssuerIdentityFromSignature() throws DSigException {
        return this.getIssuerIdentityFromSignature((AbstractSAMLMessage)this.req);
    }

    public boolean doSignResponse() {
        if (this.samlConfiguration.isSignRespAlways()) {
            return true;
        }
        if (this.samlConfiguration.isSignRespNever()) {
            return false;
        }
        return this.req.isSigned();
    }
}

