/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.saml;

import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class SAMLConfiguration {
    private boolean signRespNever;
    private boolean signRespAlways;
    private boolean signIfRespUnsigned;
    private boolean signAssertNever;
    private boolean signAssertAlways;

    private void init(UVOSServerProperties conf) {
        ResponseSigningPolicy repPolicy = (ResponseSigningPolicy)conf.getEnumValue("saml.signResponses", ResponseSigningPolicy.class);
        this.signRespNever = false;
        this.signRespAlways = false;
        if (repPolicy == ResponseSigningPolicy.always) {
            this.signRespAlways = true;
        } else if (repPolicy == ResponseSigningPolicy.never) {
            this.signRespNever = true;
        }
        AssertionSigningPolicy assertionPolicy = (AssertionSigningPolicy)conf.getEnumValue("saml.signAssertions", AssertionSigningPolicy.class);
        this.signIfRespUnsigned = false;
        this.signAssertNever = false;
        this.signAssertAlways = false;
        if (assertionPolicy == AssertionSigningPolicy.always) {
            this.signAssertAlways = true;
        } else if (assertionPolicy == AssertionSigningPolicy.never) {
            this.signAssertNever = true;
        } else if (assertionPolicy == AssertionSigningPolicy.ifResponseUnsigned) {
            this.signIfRespUnsigned = true;
        }
    }

    public SAMLConfiguration(UVOSServerProperties conf) {
        this.init(conf);
    }

    public boolean isSignRespNever() {
        return this.signRespNever;
    }

    public boolean isSignRespAlways() {
        return this.signRespAlways;
    }

    public boolean isSignIfRespUnsigned() {
        return this.signIfRespUnsigned;
    }

    public boolean isSignAssertNever() {
        return this.signAssertNever;
    }

    public boolean isSignAssertAlways() {
        return this.signAssertAlways;
    }

    public static enum AssertionSigningPolicy {
        always,
        never,
        ifResponseUnsigned,
        asRequest;

    }

    public static enum ResponseSigningPolicy {
        always,
        never,
        asRequest;

    }
}

