/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.saml;

import eu.unicore.samly2.SAMLUtils;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.exceptions.SAMLRequestException;
import eu.unicore.samly2.proto.AbstractRequest;
import eu.unicore.samly2.proto.AssertionResponse;
import eu.unicore.samly2.proto.AuthnRequest;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.dsig.DigSignatureUtil;
import java.security.cert.X509Certificate;
import java.util.Collections;
import org.w3c.dom.Document;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.saml.SAMLConfiguration;
import pl.edu.icm.unicore.uvos.saml.SAMLUtil;
import pl.edu.icm.unicore.uvos.server.IssuerIdentityProvider;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.AuthnRequestDocument;
import xmlbeans.org.oasis.saml2.protocol.AuthnRequestType;
import xmlbeans.org.oasis.saml2.protocol.NameIDPolicyType;
import xmlbeans.org.oasis.saml2.protocol.RequestAbstractType;
import xmlbeans.org.w3.x2000.x09.xmldsig.SignatureType;

public class SAMLAuthnUtil
extends SAMLUtil {
    private AuthnRequestDocument requestDoc;
    private AuthnRequestType request;
    private String requestedFormat;
    private String issuerName;
    private String reqId;
    private String consumerURL;

    public SAMLAuthnUtil(AuthnRequestDocument requestDoc, IssuerIdentityProvider secProvider, UVOSServerProperties conf, SAMLConfiguration samlConfig) {
        super((RequestAbstractType)requestDoc.getAuthnRequest(), secProvider, conf, samlConfig);
        this.requestDoc = requestDoc;
    }

    @Override
    public void parse() throws SAMLProtocolException {
        NameIDType issuer;
        new AuthnRequest(this.requestDoc);
        this.request = this.requestDoc.getAuthnRequest();
        NameIDPolicyType nameIDPolicy = this.request.getNameIDPolicy();
        this.requestedFormat = nameIDPolicy == null ? null : nameIDPolicy.getFormat();
        if (this.requestedFormat == null) {
            this.requestedFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        if ((issuer = this.request.getIssuer()) == null) {
            throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", "SAML Authentication request MUST contain an Issuer element.");
        }
        String format = issuer.getFormat();
        if (format != null && !format.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", "SAML Authentication request Issuer MUST be of type urn:oasis:names:tc:SAML:2.0:nameid-format:entity (which is a default type).");
        }
        this.issuerName = issuer.getStringValue();
        if (this.issuerName == null) {
            throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", "SAML Authentication request Issuer MUST not be empty.");
        }
        this.reqId = this.request.getID();
        if (this.reqId == null) {
            throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", "SAML Authentication request MUST contain ID.");
        }
        this.consumerURL = this.request.getAssertionConsumerServiceURL();
        if (this.consumerURL == null) {
            throw new SAMLRequestException("urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", "This implementation requires that consumerServiceURL is in SAML Authentication.");
        }
    }

    public String getReqId() {
        return this.reqId;
    }

    public AuthnRequestDocument getRequestDoc() {
        return this.requestDoc;
    }

    public boolean isRequestSigned() {
        return this.request.getSignature() != null && !this.request.getSignature().isNil();
    }

    public boolean isRequestCorrectlySigned() throws DSigException {
        if (!this.isRequestSigned()) {
            return false;
        }
        DigSignatureUtil sign = new DigSignatureUtil();
        X509Certificate[] issuerC = SAMLUtils.getIssuerFromSignature((SignatureType)this.request.getSignature());
        if (issuerC == null || issuerC.length == 0) {
            throw new DSigException("Issuer certificate is not present in signature.");
        }
        Document doc = (Document)this.requestDoc.getDomNode();
        return sign.verifyEnvelopedSignature(doc, Collections.singletonList(doc.getDocumentElement()), AbstractRequest.PROTOCOL_ID_QNAME, issuerC[0].getPublicKey());
    }

    public AssertionResponse getOKResponseDocument() {
        return new AssertionResponse(this.getIssuer(), this.request.getID());
    }

    public AssertionResponse getErrorResponse(UVOSException e) throws UVOSFault {
        return this.getErrorResponse(this.convert2SAMLError(e, null, true));
    }

    public AssertionResponse getErrorResponse(UVOSException e, String message) throws UVOSFault {
        return this.getErrorResponse(this.convert2SAMLError(e, message, false));
    }

    public AssertionResponse getErrorResponse(SAMLProtocolException e) {
        String id = null;
        if (this.request == null) {
            if (this.requestDoc != null && this.requestDoc.getAuthnRequest() != null && this.requestDoc.getAuthnRequest().getID() != null) {
                id = this.requestDoc.getAuthnRequest().getID();
            }
        } else {
            id = this.request.getID();
        }
        return new AssertionResponse(this.getIssuer(), id, e);
    }

    @Override
    public X509Certificate[] getIssuerIdentityFromSignature() throws DSigException {
        throw new DSigException("Not implemented for Autn protocol");
    }

    public String getRequestedFormat() {
        return this.requestedFormat;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getConsumerURL() {
        return this.consumerURL;
    }
}

