/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.saml;

import eu.unicore.samly2.elements.Subject;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.proto.AbstractSAMLMessage;
import eu.unicore.samly2.proto.AssertionResponse;
import eu.unicore.samly2.proto.AttributeQuery;
import eu.unicore.security.dsig.DSigException;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.saml.SAMLConfiguration;
import pl.edu.icm.unicore.uvos.saml.SAMLUtil;
import pl.edu.icm.unicore.uvos.server.IssuerIdentityProvider;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UVOSFault;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;
import xmlbeans.org.oasis.saml2.protocol.AttributeQueryDocument;
import xmlbeans.org.oasis.saml2.protocol.ExtensionsType;
import xmlbeans.org.oasis.saml2.protocol.RequestAbstractType;
import xmlbeans.pl.edu.icm.samlvo.attrext.RequestedGroupScopeDocument;
import xmlbeans.pl.edu.icm.samlvo.attrext.RequestedGroupScopeType;

public class SAMLAttributeQueryUtil
extends SAMLUtil {
    private AttributeQueryDocument queryDoc;
    private AttributeQuery query;
    private Identity identity;
    private Element element;
    private boolean enforceAssertionSign = false;

    public SAMLAttributeQueryUtil(AttributeQueryDocument queryDoc, IssuerIdentityProvider secProvider, UVOSServerProperties conf, SAMLConfiguration samlConfig) {
        super((RequestAbstractType)queryDoc.getAttributeQuery(), secProvider, conf, samlConfig);
        this.queryDoc = queryDoc;
    }

    @Override
    public void parse() throws SAMLProtocolException {
        this.query = new AttributeQuery(this.queryDoc);
        SubjectType subject = this.query.getSubject().getXBean();
        this.identity = this.mapSubject(subject);
        this.element = new Element(null, this.identity);
        ExtensionsType exts = this.query.getExtensions();
        if (exts == null) {
            return;
        }
        XmlCursor cur = exts.newCursor();
        if (!cur.toChild(RequestedGroupScopeDocument.type.getDocumentElementName())) {
            return;
        }
        XmlObject scopeRaw = cur.getObject();
        cur.dispose();
        if (!(scopeRaw instanceof RequestedGroupScopeType)) {
            return;
        }
        RequestedGroupScopeType scopeXml = (RequestedGroupScopeType)scopeRaw;
        String[] scopes = scopeXml.getGroupArray();
        if (scopes == null || scopes.length == 0) {
            return;
        }
        this.element = new Element(new Group(scopes[0]), this.identity);
    }

    public Identity getSubjectIdentity() {
        return this.identity;
    }

    public Element getSubjectElement() {
        return this.element;
    }

    public Subject getSubject() {
        return this.query.getSubject();
    }

    public boolean doSignResponse() {
        if (this.samlConfiguration.isSignRespAlways()) {
            return true;
        }
        if (this.samlConfiguration.isSignRespNever()) {
            return false;
        }
        return this.query.isSigned();
    }

    public void setEnforceSignAssertion(boolean how) {
        this.enforceAssertionSign = how;
    }

    public boolean doSignAssertion() {
        if (this.samlConfiguration.isSignAssertAlways() || this.enforceAssertionSign) {
            return true;
        }
        if (this.samlConfiguration.isSignAssertNever()) {
            return false;
        }
        if (this.samlConfiguration.isSignIfRespUnsigned()) {
            return !this.doSignResponse();
        }
        return this.query.isSigned();
    }

    @Override
    public X509Certificate[] getIssuerIdentityFromSignature() throws DSigException {
        return this.getIssuerIdentityFromSignature((AbstractSAMLMessage)this.query);
    }

    public AttributeType[] getQueriedAttributes() {
        return this.query.getAttributes();
    }

    public AssertionResponse getOKResponseDocument() {
        return new AssertionResponse(this.getIssuer(), this.query.getID());
    }

    public AssertionResponse getErrorResponse(UVOSException e) throws UVOSFault {
        return this.getErrorResponse(this.convert2SAMLError(e, null, true));
    }

    public AssertionResponse getErrorResponse(UVOSException e, String message) throws UVOSFault {
        return this.getErrorResponse(this.convert2SAMLError(e, message, false));
    }

    public AssertionResponse getErrorResponse(SAMLProtocolException e) {
        String id = null;
        if (this.query == null) {
            if (this.queryDoc != null && this.queryDoc.getAttributeQuery() != null && this.queryDoc.getAttributeQuery().getID() != null) {
                id = this.queryDoc.getAttributeQuery().getID();
            }
        } else {
            id = this.query.getID();
        }
        return new AssertionResponse(this.getIssuer(), id, e);
    }
}

