/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.registration;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.unicore.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import pl.edu.icm.unicore.uvos.util.GLUEInfoProvider;

public class UVOSEMIRClient {
    private static final Logger logger = Log.getLogger((String)"unicore.uvos.server", EMIRClient.class);
    private EMIRClient client;
    private GLUEInfoProvider infoProvider;

    public UVOSEMIRClient(EMIRClient client, GLUEInfoProvider infoProvider) {
        this.client = client;
        this.infoProvider = infoProvider;
    }

    public Date readd() {
        try {
            JSONArray desc = this.infoProvider.getEndpointDescription();
            WebResource serviceAdmin = this.client.getClientResource().path("/serviceadmin");
            ClientResponse res = (ClientResponse)serviceAdmin.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(ClientResponse.class, (Object)desc);
            if (res.getClientResponseStatus() != ClientResponse.Status.OK) {
                throw new Exception("Unable to register service to EMIR: " + res.getClientResponseStatus());
            }
            logger.info((Object)("Successfully registered service at EMI registry " + this.client.getClientResource().getURI()));
            JSONArray ret = (JSONArray)res.getEntity(JSONArray.class);
            if (ret.length() != 1) {
                throw new Exception("EMIR returned response array of != 1 size: " + ret.toString());
            }
            JSONObject registered = ret.getJSONObject(0);
            JSONObject expireOn = registered.getJSONObject(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.toString());
            return this.getDate(expireOn);
        }
        catch (Exception e) {
            logger.error((Object)("Can't add service to EMI registry " + this.client.getClientResource().getURI()), (Throwable)e);
            Calendar minTT = Calendar.getInstance();
            minTT.add(12, 10);
            return new Date(minTT.getTimeInMillis());
        }
    }

    private Date getDate(JSONObject json) throws JSONException, ParseException {
        String strDate = json.getString("$date");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.parse(strDate);
    }
}

