/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.registration;

import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.oasisOpen.docs.wsrf.sg2.AddResponseDocument;
import org.w3.x2005.x08.addressing.AttributedURIType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;
import org.w3.x2005.x08.addressing.MetadataType;
import pl.edu.icm.unicore.uvos.registration.RegistryClient;
import pl.edu.icm.unicore.uvos.util.ThreadScheduler;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLQueryInterface;

public class RegistrationHandler {
    public static final QName INTERFACE_NAME = new QName("http://www.w3.org/2005/08/addressing/metadata", "InterfaceName");
    private static final Logger logger = Log.getLogger((String)"unicore.uvos.server", RegistrationHandler.class);
    private List<RegistryClient> clients = new ArrayList<RegistryClient>();
    private EndpointReferenceType serviceEPR = EndpointReferenceType.Factory.newInstance();
    private ScheduledExecutorService scheduler;

    public RegistrationHandler(List<String> registries, UVOSServerProperties conf, ThreadScheduler thScheduler) {
        AttributedURIType addr = this.serviceEPR.addNewAddress();
        WebService samlQueryWS = SAMLQueryInterface.class.getAnnotation(WebService.class);
        String samlQueryServiceName = samlQueryWS.serviceName();
        boolean httpsEnable = conf.getBooleanValue("https.enable");
        if (!httpsEnable) {
            logger.warn((Object)"Not adding service to registry as HTTPS connector is disabled.");
            return;
        }
        String host = conf.getValue("https.host");
        String port = conf.getValue("https.port");
        addr.setStringValue("https://" + host + ":" + port + "/" + samlQueryServiceName);
        RegistrationHandler.addPortType(this.serviceEPR, new QName(samlQueryWS.targetNamespace(), samlQueryServiceName));
        for (String reg : registries) {
            try {
                this.clients.add(new RegistryClient(reg, conf));
            }
            catch (Exception e) {
                logger.error((Object)("Can't create client for registry " + reg), (Throwable)e);
            }
        }
        this.scheduler = thScheduler.getScheduledExecutor();
    }

    public void start() {
        Adder adder = new Adder();
        this.scheduler.schedule(adder, 1L, TimeUnit.SECONDS);
    }

    public static void addPortType(EndpointReferenceType epr, QName portType) {
        MetadataType meta = epr.getMetadata();
        if (meta == null) {
            meta = epr.addNewMetadata();
        }
        XmlCursor n = meta.newCursor();
        n.toFirstContentToken();
        n.beginElement(INTERFACE_NAME);
        n.insertNamespace("x", portType.getNamespaceURI());
        n.insertChars("x:" + portType.getLocalPart());
        n.dispose();
    }

    public class Adder
    implements Runnable {
        @Override
        public void run() {
            Calendar next = this.readd();
            Calendar now = Calendar.getInstance();
            long wait = (next.getTimeInMillis() - now.getTimeInMillis()) / 2L;
            logger.debug((Object)("Delay for registry update is: " + wait));
            RegistrationHandler.this.scheduler.schedule(this, wait, TimeUnit.MILLISECONDS);
        }

        private Calendar readd() {
            Calendar minTT = null;
            for (RegistryClient client : RegistrationHandler.this.clients) {
                try {
                    AddResponseDocument resp = client.addRegistryEntry(RegistrationHandler.this.serviceEPR);
                    logger.info((Object)("Successfully registered service at registry " + client.getEPR().getAddress().getStringValue()));
                    Calendar tt = resp.getAddResponse().getTerminationTime();
                    if (tt == null || minTT != null && !tt.before(minTT)) continue;
                    minTT = tt;
                }
                catch (Exception e) {
                    logger.error((Object)("Can't add service to registry " + client.getEPR().getAddress().getStringValue()), (Throwable)e);
                }
            }
            if (minTT == null) {
                minTT = Calendar.getInstance();
                minTT.add(12, 5);
            }
            return minTT;
        }
    }
}

