/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.registration;

import eu.emi.emir.client.EMIRClient;
import eu.unicore.util.Log;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.registration.UVOSEMIRClient;
import pl.edu.icm.unicore.uvos.util.GLUEInfoProvider;
import pl.edu.icm.unicore.uvos.util.ThreadScheduler;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class EMIRHandler {
    private static final Logger logger = Log.getLogger((String)"unicore.uvos.server", EMIRHandler.class);
    private ScheduledExecutorService scheduler;
    private EMIRClient client;
    private GLUEInfoProvider infoProvider;

    public EMIRHandler(UVOSServerProperties conf, ThreadScheduler thScheduler, GLUEInfoProvider infoProvider) {
        this.scheduler = thScheduler.getScheduledExecutor();
        this.infoProvider = infoProvider;
        String emirUrl = conf.getValue("emirRegistry");
        if (emirUrl != null) {
            this.client = new EMIRClient(emirUrl, conf.getClientConfiguration());
        }
    }

    public void start() {
        if (this.client == null) {
            logger.debug((Object)"EMIR subsystem won't be started as no EMIR address is defined");
            return;
        }
        Adder adder = new Adder();
        this.scheduler.schedule(adder, 3L, TimeUnit.SECONDS);
    }

    public class Adder
    implements Runnable {
        @Override
        public void run() {
            UVOSEMIRClient emirClient = new UVOSEMIRClient(EMIRHandler.this.client, EMIRHandler.this.infoProvider);
            Date next = emirClient.readd();
            Calendar now = Calendar.getInstance();
            long wait = (next.getTime() - now.getTimeInMillis()) / 2L;
            logger.debug((Object)("Delay for registry update is: " + wait));
            EMIRHandler.this.scheduler.schedule(this, wait, TimeUnit.MILLISECONDS);
        }
    }
}

