/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.mail;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.util.Log;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import javax.net.ssl.SSLSocketFactory;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import pl.edu.icm.unicore.uvos.api.VOApplication;
import pl.edu.icm.unicore.uvos.api.VOApplicationForm;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.VOApplicationException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.db.DBNotification;
import pl.edu.icm.unicore.uvos.mail.VariablesMap;
import pl.edu.icm.unicore.uvos.model.NotifyBean;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;
import xmlbeans.pl.edu.icm.uvos.internal.app.VOApplicationFormConstraintsType;

public class MailSender {
    private Properties props;
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", MailSender.class);
    private static final String CFG_ENABLE = "mailx.enable";
    private static final String CFG_USER = "mailx.smtp.auth.username";
    private static final String CFG_PASSWD = "mailx.smtp.auth.password";
    private static final String CFG_TESTADDR = "mailx.sendTestMessageTo";
    private static final String MAIL_TEMPLATE_PRE = "mailtemplate.";
    private static final String ACT_NA = "newApplication";
    private static final String ACT_PR = "applicationProcessed";
    private static final String NEW_APPLICATION_SUBJECT = "A new application was received";
    private static final String APPLICATION_PROCESSED_SUBJECT = "VO application was processed";
    private static final String NEW_APPLICATION_BODY = "A new application for the form ${FORM_NAME} (id ${FORM_ID}) was received.\nIt is for the VO/group: ${FORM_GROUP}.";
    private static final String APPLICATION_PROCESSED_BODY = "Your VO application has been just processed by the VO service staff.\n\nThe status is: ${APP_STATUS}\nAdditional information: ${APP_ADMIN_NOTES}";
    private static final String DEFAULT_TEMPLATE_SUBJECT = "A VO event occured: ${ACTION}";
    private static final String DEFAULT_TEMPLATE_BODY = "Action ${ACTION} was performed by ${CALLER}.\nAction parameters are:\nSubject: ${SUBJECT}\nGroup: ${GROUP}\n";
    private DBNotification dbN;
    private DB db;
    boolean enable = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailSender(DB db, DBNotification dbN, UVOSServerProperties conf) throws FileNotFoundException, IOException {
        this.db = db;
        this.dbN = dbN;
        if (conf == null) {
            return;
        }
        String configFile = conf.getValue("mailConfig");
        this.props = new Properties();
        BufferedInputStream configBis = new BufferedInputStream(new FileInputStream(configFile));
        try {
            this.props.load(configBis);
        }
        finally {
            configBis.close();
        }
        String templatesFile = conf.getValue("mailTemplates");
        BufferedInputStream templatesBis = new BufferedInputStream(new FileInputStream(templatesFile));
        try {
            this.props.load(templatesBis);
        }
        finally {
            templatesBis.close();
        }
        String enableS = this.props.getProperty(CFG_ENABLE);
        if (enableS == null || !enableS.equals("true")) {
            return;
        }
        this.enable = true;
        IAuthnAndTrustConfiguration sec = conf.getAuthAndTrust();
        SSLSocketFactory sf = SocketFactoryCreator.getSocketFactory((X509Credential)sec.getCredential(), (X509CertChainValidator)sec.getValidator());
        this.props.put("mail.smtp.ssl.socketFactory", sf);
        String tmp = this.props.getProperty(CFG_TESTADDR);
        if (tmp != null) {
            try {
                this.sendMessage("VO service test message", "This message was sent upon VO service startup to verify mail settings.\n\nYou can disable this behaviour by commenting out the mailx.sendTestMessageTo property in the mail settings.", tmp);
            }
            catch (Exception e) {
                log.error((Object)"Sending a test message failed. Please verify mail settings. Please note that the serverwill anyway start up, but mail notification will be DISABLED!", (Throwable)e);
                this.enable = false;
            }
        }
    }

    public void sendNotification(VariablesMap vars) throws InternalException {
        if (!this.enable) {
            return;
        }
        String addr = this.getAddressFor(vars.getAction(), vars.getGroup());
        if (addr == null) {
            return;
        }
        String subject = this.getMsgText(vars.getMap(), vars.getAction(), true);
        String body = this.getMsgText(vars.getMap(), vars.getAction(), false);
        this.sendMessageBg(subject, body, addr);
    }

    public void sendNewApplicationNotification(VOApplication application, VOApplicationForm form) throws VOApplicationException {
        if (!this.enable) {
            return;
        }
        String subject = this.substituteNewApp(NEW_APPLICATION_SUBJECT, application, form);
        String body = this.substituteNewApp(NEW_APPLICATION_BODY, application, form);
        try {
            VOApplicationFormConstraintsType info = VOApplicationFormConstraintsType.Factory.parse((String)form.getConstraints());
            String addr = info.getNotifyAddress();
            if (addr != null && !addr.equals("")) {
                this.sendMessageBg(subject, body, addr);
            }
        }
        catch (XmlException e) {
            log.error((Object)("BUG! Application form can't be parsed: " + (Object)((Object)e)));
            throw new VOApplicationException("BUG! Application form can't be parsed: " + (Object)((Object)e));
        }
    }

    public void sendProcessedApplicationNotification(VOApplication application, VOApplicationForm form) {
        if (!this.enable) {
            return;
        }
        String subject = this.substituteProcessedApp(APPLICATION_PROCESSED_SUBJECT, application, form);
        String body = this.substituteProcessedApp(APPLICATION_PROCESSED_BODY, application, form);
        String addr = application.getEmailAddress();
        if (addr != null && !addr.equals("")) {
            this.sendMessageBg(subject, body, addr);
        }
    }

    private void sendMessageBg(final String subject, final String body, final String to) {
        new Thread(){

            @Override
            public void run() {
                try {
                    MailSender.this.sendMessage(subject, body, to);
                }
                catch (Exception e) {
                    log.warn((Object)("Can't send email with notification: " + e));
                }
            }
        }.start();
    }

    private void sendMessage(String subject, String body, String to) throws AddressException, MessagingException {
        Session session = Session.getInstance((Properties)this.props, (Authenticator)new SimpleAuthenticator());
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom();
        msg.setRecipients(Message.RecipientType.TO, to);
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        msg.setText(body);
        Transport.send((Message)msg);
    }

    private String substituteNewApp(String text, VOApplication application, VOApplicationForm form) {
        text = text.replace("${FORM_ID}", form.getId() + "");
        text = text.replace("${FORM_GROUP}", form.getBaseGroup().toString());
        text = text.replace("${FORM_NAME}", form.getFriendlyName());
        return text;
    }

    private String substituteProcessedApp(String text, VOApplication application, VOApplicationForm form) {
        text = text.replace("${APP_ID}", application.getId() + "");
        text = text.replace("${FORM_GROUP}", form.getBaseGroup().toString());
        text = text.replace("${FORM_NAME}", form.getFriendlyName());
        text = text.replace("${APP_STATUS}", application.getStatus().toString());
        String val = application.getAdminNotes();
        if (val == null) {
            val = "-";
        }
        text = text.replace("${APP_ADMIN_NOTES}", val);
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAddressFor(String action, String group) throws InternalException {
        List<?> notifications;
        SqlSession session = this.db.getSqlSession();
        try {
            notifications = this.dbN.getNotifications(action, session);
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        if (group != null) {
            for (int i = notifications.size() - 1; i >= 0; --i) {
                NotifyBean nb = (NotifyBean)notifications.get(i);
                if (nb.getGroupFilter() == null || group.equals(nb.getGroupFilter())) continue;
                notifications.remove(i);
            }
        }
        if (notifications.size() == 0) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        for (Object o : notifications) {
            ret.append(((NotifyBean)o).getRecipients());
            ret.append(",");
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    private String getTemplate(String operationKey, boolean subject) {
        String suffix = subject ? ".subject" : ".body";
        String key = MAIL_TEMPLATE_PRE + operationKey + suffix;
        String template = this.props.getProperty(key);
        if (template == null) {
            template = operationKey.equals(ACT_NA) ? (subject ? NEW_APPLICATION_SUBJECT : NEW_APPLICATION_BODY) : (operationKey.equals(ACT_PR) ? (subject ? APPLICATION_PROCESSED_SUBJECT : APPLICATION_PROCESSED_BODY) : this.props.getProperty(MAIL_TEMPLATE_PRE + suffix));
        }
        if (template == null) {
            template = subject ? DEFAULT_TEMPLATE_SUBJECT : DEFAULT_TEMPLATE_BODY;
        }
        return template;
    }

    private String getMsgText(Map<String, String> varsMap, String operationKey, boolean subject) {
        String template = this.getTemplate(operationKey, subject);
        for (Map.Entry<String, String> var : varsMap.entrySet()) {
            template = template.replace(var.getKey(), var.getValue());
        }
        return template;
    }

    private class SimpleAuthenticator
    extends Authenticator {
        private SimpleAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(MailSender.this.props.getProperty(MailSender.CFG_USER), MailSender.this.props.getProperty(MailSender.CFG_PASSWD));
        }
    }
}

