/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.engine;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.AttributePermission;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.PermissionDesignator;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthorizationException;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.SecurityException;
import pl.edu.icm.unicore.uvos.api.exceptions.UnsupportedTypeException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.db.DBAuthz;
import pl.edu.icm.unicore.uvos.db.DBEntities;
import pl.edu.icm.unicore.uvos.db.DBEntitiesCache;
import pl.edu.icm.unicore.uvos.db.DBGroupResolver;
import pl.edu.icm.unicore.uvos.db.DBGroups;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.SecurityContext;
import pl.edu.icm.unicore.uvos.engine.SecurityContextImpl;
import pl.edu.icm.unicore.uvos.engine.VirtualSecurityContextImpl;
import pl.edu.icm.unicore.uvos.engine.api.UVOSAuthZInterface;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityHelperFactory;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityTypeHelper;
import pl.edu.icm.unicore.uvos.model.AttributeBean;
import pl.edu.icm.unicore.uvos.model.AuthzBean;
import pl.edu.icm.unicore.uvos.model.EntityBean;
import pl.edu.icm.unicore.uvos.model.GroupBean;
import pl.edu.icm.unicore.uvos.model.IdentityBean;
import pl.edu.icm.unicore.uvos.server.idresolver.Authenticator;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class VOAuthorizationModule
implements UVOSAuthZInterface,
InternalAuthorization {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", VOAuthorizationModule.class);
    private boolean allowX509AsDN;
    private UVOSServerProperties conf;
    private DBGroupResolver groupResolver;
    private DBGroups groups;
    private DBEntities entities;
    private DBEntitiesCache entitiesCache;
    private DBAuthz authz;
    private DB db;

    public VOAuthorizationModule(DBGroupResolver groupResolver, DBGroups groups, DBEntities entities, DBEntitiesCache entitiesCache, UVOSServerProperties conf, DBAuthz authz, DB db) {
        this.db = db;
        this.groupResolver = groupResolver;
        this.groups = groups;
        this.entities = entities;
        this.entitiesCache = entitiesCache;
        this.authz = authz;
        this.conf = conf;
        this.allowX509AsDN = conf.getBooleanValue("saml.allowToUseCertificateAsDN");
        if (this.allowX509AsDN && !this.isTLSEnabled()) {
            log.warn((Object)"Mapping of X.509 certificates to DNs will be fully operable only when TLS  authentication method is enabled. It is strongly advised to turn on this authN mechanism.");
        }
    }

    private boolean isTLSEnabled() {
        String rawOrder = this.conf.getValue("authn.order");
        String[] orderS = rawOrder.split(" ");
        for (int i = 0; i < orderS.length; ++i) {
            if (!"TLS".equals(orderS[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityContext establishSecurityContext(Identity caller) throws IdentityNotKnownException, InternalException, AuthenticationException, InvalidValueException {
        SqlSession sqlMap = this.db.getSqlSession();
        try {
            SecurityContextImpl ctx;
            IdentityBean idB = this.entitiesCache.resolveIdentity(caller, null, sqlMap);
            if (idB.getInactive() != 0) {
                log.debug((Object)("Denying authentication attempt for disabled identity " + caller));
                throw new IdentityNotKnownException(caller);
            }
            String authn = this.entities.getAuthnData(idB.getId(), sqlMap);
            if (caller.getAuthnData() != null || authn != null) {
                IdentityTypeHelper idHelper;
                try {
                    idHelper = IdentityHelperFactory.getHelper((Identity)caller);
                }
                catch (InvalidValueException e) {
                    throw new IdentityNotKnownException(caller);
                }
                idHelper.validateAuthNToken(authn);
            }
            EntityBean eb = this.entitiesCache.getEntity4Identity(idB.getId(), sqlMap);
            SecurityContextImpl securityContextImpl = ctx = new SecurityContextImpl(caller, eb);
            return securityContextImpl;
        }
        finally {
            this.db.releaseSqlSession(sqlMap);
        }
    }

    @Override
    public void authorize(Permissions permMask, GroupBean group, boolean owner, SqlSession sqlMap) throws SecurityException, InternalException, GroupNotKnownException {
        Permissions actualPerms;
        SecurityContext ctx = Authenticator.getCurrentContext();
        if (ctx instanceof VirtualSecurityContextImpl) {
            actualPerms = ((VirtualSecurityContextImpl)ctx).getPerms();
        } else {
            this.checkCtxBean(ctx);
            actualPerms = this.assemblePermissions(group, ctx.getEntity().getId(), owner, sqlMap);
        }
        if ((permMask.getValue() & actualPerms.getValue()) != permMask.getValue()) {
            throw new AuthorizationException("Authorization failed");
        }
    }

    @Override
    public void authorizeRecursive(Permissions permMask, GroupBean group, SqlSession sqlMap) throws SecurityException, InternalException, GroupNotKnownException {
        this.authorize(permMask, group, false, sqlMap);
        List<Integer> subgroups = this.groups.getGroupSubgroups(group.getId(), sqlMap);
        GroupBean g = new GroupBean();
        for (Integer i : subgroups) {
            g.setId(i);
            g.setParent(group.getId());
            this.authorizeRecursive(permMask, g, sqlMap);
        }
    }

    @Override
    public void authorize(Permissions permMask, boolean owner, SqlSession sqlMap) throws SecurityException, InternalException {
        GroupBean nullGroup = new GroupBean();
        nullGroup.setId(-1);
        try {
            this.authorize(permMask, nullGroup, owner, sqlMap);
        }
        catch (GroupNotKnownException e) {
            throw new InternalException("Authorization failed - BUG (group not known)");
        }
    }

    @Override
    public void authorizeIdentityCtl(SqlSession sqlMap) throws SecurityException, InternalException {
        this.authorizeIdentityCtlInternal(sqlMap);
    }

    private Permissions authorizeIdentityCtlInternal(SqlSession sqlMap) throws SecurityException, InternalException {
        Permissions globalPerms;
        SecurityContext ctx = Authenticator.getCurrentContext();
        if (ctx instanceof VirtualSecurityContextImpl) {
            globalPerms = ((VirtualSecurityContextImpl)ctx).getPerms();
        } else {
            this.checkCtxBean(ctx);
            GroupBean gb = new GroupBean();
            gb.setId(-1);
            try {
                globalPerms = this.assemblePermissions(gb, ctx.getEntity().getId(), false, sqlMap);
            }
            catch (GroupNotKnownException e) {
                throw new InternalException("Authorization failed - BUG (root group not known)");
            }
        }
        if (globalPerms.isWrite()) {
            return globalPerms;
        }
        if (!globalPerms.isIdentityCtl()) {
            throw new AuthorizationException("Authorization failed");
        }
        return globalPerms;
    }

    @Override
    public void authorizeIdentityCtl(Identity id, SqlSession sqlMap) throws SecurityException, InternalException, IdentityNotKnownException, InvalidValueException {
        Permissions idGlobalPerms;
        EntityBean eb;
        Permissions globalPerms = this.authorizeIdentityCtlInternal(sqlMap);
        try {
            GroupBean gb = new GroupBean();
            gb.setId(-1);
            eb = this.entitiesCache.getEntity4Identity(id, null, sqlMap);
            idGlobalPerms = this.assemblePermissions(gb, eb.getId(), false, sqlMap);
        }
        catch (GroupNotKnownException e) {
            throw new InternalException("Authorization failed - BUG (root group not known)");
        }
        if ((idGlobalPerms.getValue() | globalPerms.getValue()) > globalPerms.getValue()) {
            throw new AuthorizationException("Authorization failed");
        }
        List<GroupBean> groups = this.groups.getAllGroupsRaw(eb.getId(), null, sqlMap);
        for (GroupBean g : groups) {
            try {
                this.authorize(Permissions.WRITE_P, g, false, sqlMap);
            }
            catch (GroupNotKnownException e) {
                throw new InternalException("Authorization failed - BUG (group not known)");
            }
        }
    }

    @Override
    public boolean isSelf(Identity id, SqlSession sqlMap) throws IdentityNotKnownException, InternalException, SecurityException, InvalidValueException {
        return this.isSelf(id, null, sqlMap);
    }

    @Override
    public boolean isSelf(Identity id, Date when, SqlSession sqlMap) throws IdentityNotKnownException, InternalException, SecurityException, InvalidValueException {
        SecurityContext ctx = Authenticator.getCurrentContext();
        if (ctx instanceof VirtualSecurityContextImpl) {
            return false;
        }
        EntityBean eb = this.entitiesCache.getEntity4Identity(id, when, sqlMap);
        this.checkCtxBean(ctx);
        return ctx.getEntity().getId() == eb.getId();
    }

    @Override
    public Permissions assemblePermissions(GroupBean group, boolean owner, SqlSession sqlMap) throws GroupNotKnownException, InternalException, SecurityException {
        SecurityContext ctx = Authenticator.getCurrentContext();
        if (ctx instanceof VirtualSecurityContextImpl) {
            return ((VirtualSecurityContextImpl)ctx).getPerms();
        }
        this.checkCtxBean(ctx);
        return this.assemblePermissions(group, ctx.getEntity().getId(), owner, sqlMap);
    }

    private Permissions assemblePermissions(GroupBean group, int entityId, boolean owner, SqlSession sqlMap) throws GroupNotKnownException, InternalException {
        GroupBean gb = new GroupBean();
        gb.setId(-1);
        Permissions pGlobal = this.assemblePermissionsI(gb, entityId, owner, sqlMap);
        Permissions pGroup = new Permissions(0);
        if (group.getId() != -1) {
            pGroup = this.assemblePermissionsI(group, entityId, owner, sqlMap);
        }
        Permissions pFinal = new Permissions(pGroup.getValue() | pGlobal.getValue());
        return pFinal;
    }

    private Permissions assemblePermissionsI(GroupBean group, int entityId, boolean owner, SqlSession sqlMap) throws GroupNotKnownException, InternalException {
        List<AttributeBean> attrs;
        List<AuthzBean> policy = this.authz.getGroupAuthZRaw(group, true, sqlMap);
        boolean member = false;
        try {
            attrs = this.entities.getEffectiveAttributes(entityId, group, null, sqlMap);
            if (group.getId() != -1) {
                member = this.groups.isEffectiveMember(entityId, group, null, sqlMap);
            }
        }
        catch (IdentityNotKnownException e) {
            throw new InternalException("Identity not known in security stack ??");
        }
        Permissions actualPerms = new Permissions(0);
        HashMap possesedAttributes = new HashMap();
        for (AttributeBean ab : attrs) {
            String key = ab.getTypeId() + "";
            ArrayList<String> cur = (ArrayList<String>)possesedAttributes.get(key);
            if (cur == null) {
                cur = new ArrayList<String>();
                possesedAttributes.put(key, cur);
            }
            if (ab.getVal() == null) continue;
            cur.add(ab.getVal());
        }
        block3: for (AuthzBean authzB : policy) {
            String special = authzB.getSpecial();
            if (special != null) {
                if ((!special.equals("O") || !owner) && (!special.equals("M") || !member)) continue;
                actualPerms.setValue(actualPerms.getValue() | authzB.getPermission());
                continue;
            }
            String key = authzB.getAttrType() + "";
            List matchingA = (List)possesedAttributes.get(key);
            if (matchingA == null) continue;
            if (authzB.getAttrValue() == null) {
                actualPerms.setValue(actualPerms.getValue() | authzB.getPermission());
                continue;
            }
            for (String s : matchingA) {
                if (!s.equals(authzB.getAttrValue())) continue;
                actualPerms.setValue(actualPerms.getValue() | authzB.getPermission());
                continue block3;
            }
        }
        return actualPerms;
    }

    private void checkCtxBean(SecurityContext ctx) throws SecurityException {
        if (ctx.getEntity() == null) {
            String identity = ctx.getCaller() == null ? "null" : ctx.getCaller().toString();
            log.fatal((Object)("Security context for identity " + identity + " is null. It is a bug."));
            Thread.dumpStack();
            throw new SecurityException("Entity is not known");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive(Identity toCheck) throws IdentityNotKnownException, InternalException, InvalidValueException {
        SqlSession sqlMap = this.db.getSqlSession();
        try {
            IdentityBean ib = this.entitiesCache.resolveIdentity(toCheck, null, sqlMap);
            boolean bl = ib.getInactive() == 0;
            return bl;
        }
        finally {
            this.db.releaseSqlSession(sqlMap);
        }
    }

    @Override
    public Identity mapIfNeededToX509(Identity toCheck) throws InternalException, InvalidValueException, IdentityNotKnownException {
        if (!this.allowX509AsDN) {
            return toCheck;
        }
        if (!toCheck.getType().equals((Object)IdentityType.DN)) {
            return toCheck;
        }
        SqlSession sqlMap = this.db.getSqlSession();
        try {
            this.entitiesCache.resolveIdentity(toCheck, null, sqlMap);
            Identity identity = toCheck;
            return identity;
        }
        catch (IdentityNotKnownException e) {
            String key = X500NameUtils.getComparableForm((String)toCheck.getValue());
            Identity newId = this.entities.getX509BySubject(key, sqlMap);
            if (newId != null) {
                log.debug((Object)("Mapped DN " + toCheck.getValue() + " to an X.509 certificate with the same subject."));
                Identity identity = newId;
                return identity;
            }
            throw e;
        }
        finally {
            this.db.releaseSqlSession(sqlMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Permissions checkPermissions(Group group, Identity whose) throws SecurityException, InternalException, GroupNotKnownException, IdentityNotKnownException, InvalidValueException {
        SqlSession sqlMap = this.db.getSqlSession();
        try {
            boolean self = this.isSelf(whose, sqlMap);
            GroupBean groupB = this.groupResolver.resolveGroup(group, null, sqlMap);
            this.authorize(Permissions.READ_P, groupB, self, sqlMap);
            EntityBean eb = this.entitiesCache.getEntity4Identity(whose, null, sqlMap);
            Permissions permissions = this.assemblePermissions(groupB, eb.getId(), false, sqlMap);
            return permissions;
        }
        finally {
            this.db.releaseSqlSession(sqlMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttributePermission> getGroupAuthZ(Group group, boolean effective) throws SecurityException, InternalException, GroupNotKnownException {
        SqlSession sqlMap = this.db.getSqlSession();
        try {
            GroupBean groupB = this.groupResolver.resolveGroup(group, null, sqlMap);
            this.authorize(Permissions.WRITE_P, groupB, false, sqlMap);
            List<AttributePermission> list = this.authz.getGroupAuthZ(groupB, effective, sqlMap);
            return list;
        }
        finally {
            this.db.releaseSqlSession(sqlMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyPermissions(Group group, PermissionDesignator designator, Permissions permissions) throws SecurityException, InternalException, GroupNotKnownException, UnsupportedTypeException {
        SqlSession sqlMap = this.db.getSqlSession();
        try {
            GroupBean gb = this.groupResolver.resolveGroup(group, null, sqlMap);
            int gid = gb.getId();
            this.authorize(Permissions.WRITE_P, gb, false, sqlMap);
            if (designator.isSpecial()) {
                this.authz.removeAuthZSpecial(designator.getSpecial(), gid, sqlMap);
                if (permissions != null) {
                    this.authz.addAuthZSpecial(designator.getSpecial(), gid, permissions, sqlMap);
                }
            } else {
                this.authz.removeAuthZAttr(designator.getAttribute(), gid, sqlMap);
                if (permissions != null) {
                    this.authz.addAuthZAttr(designator.getAttribute(), gid, permissions, sqlMap);
                }
            }
            sqlMap.commit();
        }
        finally {
            this.db.releaseSqlSession(sqlMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyAuthenticationData(Identity id, Object newToken) throws SecurityException, InternalException, IdentityNotKnownException, InvalidValueException {
        SqlSession sqlMap = this.db.getSqlSession();
        try {
            if (!this.isSelf(id, sqlMap)) {
                this.authorize(Permissions.WRITE_P, true, sqlMap);
            }
            id.setAuthnData(newToken);
            String tokenToDB = null;
            if (newToken != null) {
                IdentityTypeHelper idHelper;
                try {
                    idHelper = IdentityHelperFactory.getHelper((Identity)id);
                }
                catch (InvalidValueException e) {
                    throw new IdentityNotKnownException(id);
                }
                tokenToDB = idHelper.generateAuthNToken();
            }
            this.entities.changeAuthnToken(id, tokenToDB, sqlMap);
            sqlMap.commit();
        }
        finally {
            this.db.releaseSqlSession(sqlMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> getMyIdentities() throws SecurityException, InternalException, IdentityNotKnownException {
        SqlSession sqlMap = this.db.getSqlSession();
        try {
            SecurityContext ctx = Authenticator.getCurrentContext();
            if (ctx instanceof VirtualSecurityContextImpl) {
                List<Identity> list = Collections.singletonList(ctx.getCaller());
                return list;
            }
            this.checkCtxBean(ctx);
            List<Identity> list = this.entities.getAllEquivalents(ctx.getEntity().getId(), null, sqlMap);
            return list;
        }
        finally {
            this.db.releaseSqlSession(sqlMap);
        }
    }
}

