/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.engine;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.util.Log;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import pl.edu.icm.unicore.uvos.api.ApplicationActions;
import pl.edu.icm.unicore.uvos.api.ApplicationStatus;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.VOApplication;
import pl.edu.icm.unicore.uvos.api.VOApplicationForm;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.SecurityException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.api.exceptions.UnsupportedTypeException;
import pl.edu.icm.unicore.uvos.api.exceptions.VOApplicationException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.db.DBApps;
import pl.edu.icm.unicore.uvos.db.DBEntities;
import pl.edu.icm.unicore.uvos.db.DBGroupResolver;
import pl.edu.icm.unicore.uvos.db.DBGroups;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.api.VOApplicationInterface;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityHelperFactory;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityTypeHelper;
import pl.edu.icm.unicore.uvos.idhelpers.X509IdentityHelper;
import pl.edu.icm.unicore.uvos.mail.MailSender;
import pl.edu.icm.unicore.uvos.model.GroupBean;
import pl.edu.icm.unicore.uvos.model.VOApplicationBean;

public class VOApplicationModule
implements VOApplicationInterface {
    private DB db;
    private DBGroupResolver groupResolver;
    private DBEntities entities;
    private DBApps myDb;
    private InternalAuthorization authZ;
    private MailSender mail;
    private DBGroups groups;
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", VOApplicationModule.class);

    public VOApplicationModule(DB db, DBGroupResolver groupResolver, DBEntities entities, DBApps myDb, InternalAuthorization authZ, MailSender mail, DBGroups groups) {
        this.db = db;
        this.myDb = myDb;
        this.authZ = authZ;
        this.mail = mail;
        this.groups = groups;
        this.groupResolver = groupResolver;
        this.entities = entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateApplicationForm(VOApplicationForm applicationDef, boolean update) throws SecurityException, InternalException, VOApplicationException {
        SqlSession session = this.db.getSqlSession();
        try {
            int baseGroup;
            try {
                GroupBean gb;
                if (!update) {
                    gb = this.groupResolver.resolveGroup(applicationDef.getBaseGroup(), null, session);
                } else {
                    gb = this.groupResolver.resolveGroup(applicationDef.getBaseGroup(), null, session);
                    baseGroup = gb.getId();
                    if (baseGroup != (gb = this.myDb.getAppFormGroup(applicationDef.getId(), session)).getId()) {
                        throw new VOApplicationException("Application form update can not change the group of the original application.");
                    }
                }
                this.authZ.authorize(Permissions.WRITE_P, gb, false, session);
                baseGroup = gb.getId();
            }
            catch (GroupNotKnownException e) {
                throw new VOApplicationException("Requested base group is unknown.");
            }
            if (update) {
                this.myDb.updateAppForm(applicationDef, baseGroup, session);
            } else {
                this.myDb.addAppForm(applicationDef, session);
            }
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationForm(int id) throws SecurityException, InternalException, VOApplicationException {
        SqlSession session = this.db.getSqlSession();
        try {
            try {
                GroupBean gb = this.myDb.getAppFormGroup(id, session);
                this.authZ.authorize(Permissions.WRITE_P, gb, false, session);
            }
            catch (GroupNotKnownException e) {
                throw new InternalException("Base group in application form is unknown.");
            }
            this.myDb.removeAppForm(id, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VOApplicationForm> getApplicationForms() throws SecurityException, InternalException {
        SqlSession session = this.db.getSqlSession();
        try {
            List<VOApplicationForm> list = this.myDb.listAppForms(session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    @Override
    public void submitApplication(VOApplication application) throws SecurityException, InternalException, VOApplicationException {
        SqlSession session = this.db.getSqlSession();
        try {
            VOApplicationForm form = this.myDb.resolveAppForm(application.getFormId(), session);
            Identity id = application.getIdentity();
            IdentityTypeHelper helper = null;
            try {
                if (application.isCSR()) {
                    X509IdentityHelper.parseCSR((String)id.getValue());
                } else {
                    helper = IdentityHelperFactory.getHelper((Identity)id);
                }
            }
            catch (Exception e) {
                throw new VOApplicationException("The identity value in application is invalid for the specified type:" + e);
            }
            Identity equivalent = application.getEquivalentIdentity();
            if (equivalent != null) {
                try {
                    if (!this.authZ.isSelf(equivalent, session)) {
                        throw new SecurityException("VO Applications for entry equivalent to the existing one are available only for users authenticated as this existing one.");
                    }
                }
                catch (IdentityNotKnownException e) {
                    throw new VOApplicationException("Requested equivalent identity is not known.");
                }
                catch (InvalidValueException e) {
                    throw new VOApplicationException("Requested equivalent identity is invalid.");
                }
            }
            this.myDb.addApplication(application, helper, session);
            session.commit();
            this.mail.sendNewApplicationNotification(application, form);
        }
        catch (UnsupportedTypeException e) {
            throw new VOApplicationException("Identity type requested in application is not known");
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processApplication(int id, ApplicationActions action, String notes, boolean sendConfirmation, VOApplication properApplication) throws SecurityException, InternalException, VOApplicationException {
        SqlSession session = this.db.getSqlSession();
        try {
            Group base;
            VOApplication app = this.myDb.resolveApplication(id, session);
            GroupBean gb = this.myDb.getAppFormGroup(app.getFormId(), session);
            VOApplicationForm form = this.myDb.resolveAppForm(app.getFormId(), session);
            try {
                base = this.groupResolver.resolveGroupBean(gb, session);
                this.authZ.authorize(Permissions.WRITE_P, gb, false, session);
            }
            catch (GroupNotKnownException e) {
                throw new InternalException("Base group in application form is unknown.");
            }
            if (action.equals((Object)ApplicationActions.ACCEPT_UPDATED)) {
                if (properApplication == null || properApplication.getId() != id) {
                    throw new VOApplicationException("Updated application is invalid (is missing or has a wrong id");
                }
            } else if (properApplication != null) {
                throw new VOApplicationException("If action isn't accept with a update no updated application is permitted.");
            }
            if (action.equals((Object)ApplicationActions.REMOVE)) {
                this.myDb.removeApplication(id, session);
                return;
            }
            if (!app.getStatus().equals((Object)ApplicationStatus.PENDING)) {
                throw new VOApplicationException("Application with id " + app.getId() + " was already processed. " + "It is only possible to REMOVE an already processed application");
            }
            if (action.equals((Object)ApplicationActions.ACCEPT) || action.equals((Object)ApplicationActions.ACCEPT_UPDATED)) {
                this.acceptApplication(app.getIdentity(), app.getEquivalentIdentity(), base);
            }
            this.myDb.updateApplication(id, notes, this.convertStatus(action), session);
            session.commit();
            if (properApplication != null) {
                app = properApplication;
            }
            app.setAdminNotes(notes);
            app.setStatus(this.convertStatus(action));
            this.mail.sendProcessedApplicationNotification(app, form);
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VOApplication> getApplications(Integer formId, String status) throws SecurityException, InternalException, VOApplicationException {
        SqlSession session = this.db.getSqlSession();
        try {
            if (formId != null && formId < 0) {
                formId = null;
            }
            if (formId == null) {
                this.authZ.authorize(Permissions.FULL_READ_P, false, session);
            } else {
                GroupBean gb = this.myDb.getAppFormGroup(formId, session);
                try {
                    this.authZ.authorize(Permissions.FULL_READ_P, gb, false, session);
                }
                catch (GroupNotKnownException e) {
                    throw new VOApplicationException("BUG!! Base group of application form referenced in query is unknown.");
                }
            }
            List<VOApplication> list = this.myDb.getApplications(formId, status, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    private void acceptApplication(Identity toAdd, Identity equivalent, Group base) throws VOApplicationException {
        SqlSession session = this.db.getSqlSession();
        try {
            if (equivalent == null) {
                this.entities.addIdentity(toAdd, true, session);
            } else {
                this.entities.addIdentity(toAdd, equivalent, true, session);
            }
            if (equivalent == null && base != null && !base.getName().equals("/")) {
                this.groups.addToGroup(toAdd, base, session);
            }
            session.commit();
        }
        catch (UVOSException e) {
            throw new VOApplicationException("Can't accept application. Error occured: " + e.toString());
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    private ApplicationStatus convertStatus(ApplicationActions src) {
        if (src.equals((Object)ApplicationActions.ACCEPT)) {
            return ApplicationStatus.ACCEPTED;
        }
        if (src.equals((Object)ApplicationActions.ACCEPT_UPDATED)) {
            return ApplicationStatus.ACCEPTED_UPDATED;
        }
        return ApplicationStatus.REJECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void csrProcessedNotification(String csr, boolean accepted, String certificate, boolean sendNotification) throws SecurityException, InternalException, VOApplicationException {
        PKCS10CertificationRequest toUpdate;
        try {
            toUpdate = X509IdentityHelper.parseCSR((String)csr);
        }
        catch (Exception e1) {
            throw new VOApplicationException("CSR send in request is invalid: " + e1);
        }
        SqlSession session = this.db.getSqlSession();
        try {
            List apps = this.myDb.getCSRApplications(session);
            VOApplicationBean found = null;
            for (Object app : apps) {
                VOApplicationBean b = (VOApplicationBean)app;
                String t = b.getIdentityValue();
                try {
                    PKCS10CertificationRequest test = X509IdentityHelper.parseCSR((String)t);
                    if (!test.equals((Object)toUpdate)) continue;
                    found = b;
                    break;
                }
                catch (Exception e) {
                    log.warn((Object)("Found unparseable CSR among applications (id " + b.getId() + "): " + e));
                }
            }
            if (found == null) {
                throw new VOApplicationException("Requested CSR is not present in the database");
            }
            VOApplication app = this.myDb.resolveApplication(found.getId(), session);
            GroupBean gb = this.myDb.getAppFormGroup(app.getFormId(), session);
            try {
                this.authZ.authorize(Permissions.WRITE_P, gb, false, session);
            }
            catch (GroupNotKnownException e) {
                throw new InternalException("Base group in application form is unknown.");
            }
            if (!app.getStatus().equals((Object)ApplicationStatus.PENDING)) {
                throw new VOApplicationException("Application was already processed");
            }
            if (accepted) {
                X509IdentityHelper x509H;
                if (certificate == null) {
                    throw new VOApplicationException("No certificate was received.");
                }
                try {
                    x509H = new X509IdentityHelper(new Identity(IdentityType.X509CERT, certificate));
                }
                catch (InvalidValueException e) {
                    throw new VOApplicationException("The certificate received can't be parsed: " + (Object)((Object)e));
                }
                String value = certificate;
                if (app.getIdentity().getType().equals((Object)IdentityType.DN)) {
                    value = X500NameUtils.getComparableForm((String)x509H.getCertificate().getSubjectX500Principal().getName());
                } else if (!app.getIdentity().getType().equals((Object)IdentityType.X509CERT)) {
                    throw new VOApplicationException("BUG - CSR was accepted as identity of identity type different thenX509 certificate or DN.");
                }
                this.myDb.updateCSRApplication(found.getId(), ApplicationStatus.valueOf((String)found.getStatus()), false, value, session);
            } else {
                this.myDb.updateCSRApplication(found.getId(), ApplicationStatus.CSR_REJECTED, true, found.getIdentityValue(), session);
                if (sendNotification) {
                    VOApplicationForm form = this.myDb.resolveAppForm(app.getFormId(), session);
                    app.setStatus(ApplicationStatus.CSR_REJECTED);
                    app.setAdminNotes("Certificate signing request which was linked with this application was rejected by the CA. Therefore the application was rejected too.");
                    this.mail.sendProcessedApplicationNotification(app, form);
                }
            }
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }
}

