/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.exceptions.AttributeNotFoundException;
import pl.edu.icm.unicore.uvos.api.exceptions.ElementNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.SecurityException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.db.DBEntities;
import pl.edu.icm.unicore.uvos.db.DBGroupResolver;
import pl.edu.icm.unicore.uvos.db.DBGroups;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.api.UVOSQueryInterface;
import pl.edu.icm.unicore.uvos.model.GroupBean;

public class QueryModule
implements UVOSQueryInterface {
    private DB db;
    private DBGroups groups;
    private DBGroupResolver groupResolver;
    private DBEntities entities;
    private InternalAuthorization authZ;

    public QueryModule(DB db, DBGroups groups, DBGroupResolver groupResolver, DBEntities entities, InternalAuthorization authZ) {
        this.groups = groups;
        this.groupResolver = groupResolver;
        this.entities = entities;
        this.authZ = authZ;
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMember(Identity who, Group group, boolean effective) throws SecurityException, InternalException, IdentityNotKnownException, GroupNotKnownException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.READ_P, this.groupResolver.resolveGroup(group, null, session), this.authZ.isSelf(who, session), session);
            boolean bl = this.groups.isMember(who, effective, group, null, session);
            return bl;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Element> getGroupContent(Group group) throws SecurityException, InternalException, GroupNotKnownException {
        SqlSession session = this.db.getSqlSession();
        try {
            GroupBean gb = this.groupResolver.resolveGroup(group, null, session);
            if (gb.getId() != -1) {
                this.authZ.authorize(Permissions.READ_P, gb, false, session);
            }
            List<Element> list = this.groups.getGroupContent(group, null, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areEquivalent(Identity i1, Identity i2) throws SecurityException, InternalException, IdentityNotKnownException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.IDENTITY_CTL_P, this.authZ.isSelf(i1, session) || this.authZ.isSelf(i2, session), session);
            boolean bl = this.entities.areEquivalent(i1, i2, null, session);
            return bl;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> getAllEquivalents(Identity who) throws SecurityException, InternalException, IdentityNotKnownException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.IDENTITY_CTL_P, this.authZ.isSelf(who, session), session);
            List<Identity> list = this.entities.getAllEquivalents(who, null, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Group> getAllGroups(Identity who, boolean implied) throws SecurityException, InternalException, IdentityNotKnownException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            boolean hasGlobalReadPerm = this.isGlobalRead(this.authZ.isSelf(who, session), session);
            List<Group> list = this.groups.getAllReadableGroups(hasGlobalReadPerm, who, implied, this.authZ, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> getAllIdentities() throws SecurityException, InternalException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.READ_P, false, session);
            List<Identity> list = this.entities.getAllIdentities(null, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attribute> getAttributes(Element owner, String attribute, boolean effective, boolean includeScoped, boolean includeImplied) throws SecurityException, InternalException, ElementNotKnownException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            if (owner.getGroup() == null && owner.getIdentity() == null) {
                throw new InternalException("null element");
            }
            if (attribute != null && attribute.equals("")) {
                attribute = null;
            }
            ArrayList<Attribute> ret = new ArrayList<Attribute>();
            if (owner.getIdentity() == null) {
                this.authZ.authorize(Permissions.READ_P, this.groupResolver.resolveGroup(owner.getGroup(), null, session), false, session);
                if (attribute == null) {
                    List<Attribute> list = this.groups.getAllAttributes(owner.getGroup(), null, session);
                    return list;
                }
                try {
                    ret.add(this.groups.getGroupAttribute(owner.getGroup(), attribute, null, session));
                }
                catch (AttributeNotFoundException e) {
                    // empty catch block
                }
                ArrayList<Attribute> e = ret;
                return e;
            }
            boolean self = this.authZ.isSelf(owner.getIdentity(), session);
            if (owner.getGroup() != null) {
                this.authZ.authorize(Permissions.READ_P, this.groupResolver.resolveGroup(owner.getGroup(), null, session), self, session);
                if (attribute == null) {
                    List<Attribute> list = this.entities.getAllAttributes(owner, effective, null, session);
                    return list;
                }
                try {
                    ret.add(this.entities.getAttribute(owner, attribute, effective, null, session));
                }
                catch (AttributeNotFoundException e) {
                    // empty catch block
                }
                ArrayList<Attribute> arrayList = ret;
                return arrayList;
            }
            List<Attribute> list = this.getIdentityAttributes(owner, attribute, effective, includeScoped, includeImplied, self, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    private List<Attribute> getIdentityAttributes(Element owner, String attribute, boolean effective, boolean includeScoped, boolean includeImplied, boolean self, SqlSession session) throws SecurityException, InternalException, ElementNotKnownException, InvalidValueException {
        if (!includeScoped) {
            this.authZ.authorize(Permissions.READ_P, self, session);
        }
        boolean globalRead = this.isGlobalRead(self, session);
        List<Attribute> ret = this.entities.getIdentityAttributes(owner, attribute, includeScoped, globalRead, effective, includeImplied, self, null, this.authZ, session);
        return DB.cleanupAttributeList(ret);
    }

    private boolean isGlobalRead(boolean self, SqlSession session) throws InternalException, SecurityException {
        GroupBean root = new GroupBean();
        root.setId(-1);
        try {
            Permissions globalP = this.authZ.assemblePermissions(root, self, session);
            if (!globalP.isRead()) {
                return false;
            }
        }
        catch (GroupNotKnownException e) {
            // empty catch block
        }
        return true;
    }
}

