/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.ModificationEvent;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.exceptions.AttributeNotFoundException;
import pl.edu.icm.unicore.uvos.api.exceptions.ElementNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.SecurityException;
import pl.edu.icm.unicore.uvos.api.exceptions.TimeOutOfRangeException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.db.DBEntities;
import pl.edu.icm.unicore.uvos.db.DBGroupResolver;
import pl.edu.icm.unicore.uvos.db.DBGroups;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.api.UVOSQueryHistoryInterface;
import pl.edu.icm.unicore.uvos.model.GroupBean;

public class QueryHistoryModule
implements UVOSQueryHistoryInterface {
    private DB db;
    private DBGroups groups;
    private DBGroupResolver groupResolver;
    private DBEntities entities;
    private InternalAuthorization authZ;

    public QueryHistoryModule(DB db, DBGroups groups, DBGroupResolver groupResolver, DBEntities entities, InternalAuthorization authZ) {
        this.db = db;
        this.groups = groups;
        this.groupResolver = groupResolver;
        this.entities = entities;
        this.authZ = authZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMember(Identity who, Group group, boolean effective, Date when) throws SecurityException, InternalException, IdentityNotKnownException, GroupNotKnownException, TimeOutOfRangeException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.FULL_READ_P, this.authZ.isSelf(who, when, session), session);
            boolean bl = this.groups.isMember(who, effective, group, when, session);
            return bl;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Element> getGroupContent(Group group, Date when) throws SecurityException, InternalException, GroupNotKnownException, TimeOutOfRangeException {
        SqlSession session = this.db.getSqlSession();
        try {
            GroupBean gb = this.groupResolver.resolveGroup(group, when, session);
            if (gb.getId() != -1) {
                this.authZ.authorize(Permissions.FULL_READ_P, false, session);
            }
            List<Element> list = this.groups.getGroupContent(group, when, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areEquivalent(Identity i1, Identity i2, Date when) throws SecurityException, InternalException, IdentityNotKnownException, TimeOutOfRangeException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(new Permissions(6), this.authZ.isSelf(i1, when, session) || this.authZ.isSelf(i2, when, session), session);
            boolean bl = this.entities.areEquivalent(i1, i2, when, session);
            return bl;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> getAllEquivalents(Identity who, Date when) throws SecurityException, InternalException, IdentityNotKnownException, TimeOutOfRangeException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(new Permissions(6), this.authZ.isSelf(who, when, session), session);
            List<Identity> list = this.entities.getAllEquivalents(who, when, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Group> getAllGroups(Identity who, boolean implied, Date when) throws SecurityException, InternalException, IdentityNotKnownException, TimeOutOfRangeException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            boolean self = this.authZ.isSelf(who, when, session);
            this.authZ.authorize(Permissions.FULL_READ_P, self, session);
            List<Group> list = this.groups.getAllGroups(who, implied, when, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> getAllIdentities(Date when) throws SecurityException, InternalException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.FULL_READ_P, false, session);
            List<Identity> list = this.entities.getAllIdentities(when, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attribute> getAttributes(Element owner, String attribute, boolean effective, boolean includeScoped, boolean includeImplied, Date when) throws SecurityException, InternalException, ElementNotKnownException, TimeOutOfRangeException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            if (owner.getGroup() == null && owner.getIdentity() == null) {
                throw new InternalException("null element");
            }
            if (attribute != null && attribute.equals("")) {
                attribute = null;
            }
            ArrayList<Attribute> ret = new ArrayList<Attribute>();
            if (owner.getIdentity() == null) {
                this.authZ.authorize(Permissions.FULL_READ_P, false, session);
                if (attribute == null) {
                    List<Attribute> list = this.groups.getAllAttributes(owner.getGroup(), when, session);
                    return list;
                }
                try {
                    ret.add(this.groups.getGroupAttribute(owner.getGroup(), attribute, when, session));
                }
                catch (AttributeNotFoundException e) {
                    // empty catch block
                }
                ArrayList<Attribute> e = ret;
                return e;
            }
            boolean self = this.authZ.isSelf(owner.getIdentity(), when, session);
            this.authZ.authorize(Permissions.FULL_READ_P, self, session);
            if (owner.getGroup() != null) {
                if (attribute == null) {
                    List<Attribute> list = this.entities.getAllAttributes(owner, effective, when, session);
                    return list;
                }
                try {
                    ret.add(this.entities.getAttribute(owner, attribute, effective, when, session));
                }
                catch (AttributeNotFoundException e) {
                    // empty catch block
                }
                ArrayList<Attribute> arrayList = ret;
                return arrayList;
            }
            List<Attribute> list = this.getIdentityAttributes(owner, attribute, effective, includeScoped, includeImplied, self, when, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    private List<Attribute> getIdentityAttributes(Element owner, String attribute, boolean effective, boolean includeScoped, boolean includeImplied, boolean self, Date when, SqlSession session) throws SecurityException, InternalException, ElementNotKnownException, InvalidValueException, TimeOutOfRangeException {
        List<Attribute> ret = this.entities.getIdentityAttributes(owner, attribute, includeScoped, true, effective, includeImplied, self, when, this.authZ, session);
        return DB.cleanupAttributeList(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModificationEvent> getHistoryEvents(Date from, Date to, int cf, int typeFilter, boolean fillDetails) throws SecurityException, InternalException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.FULL_READ_P, false, session);
            ArrayList<ModificationEvent> ret = new ArrayList<ModificationEvent>();
            ModificationEvent.CATEGORY.IDENTITY.ordinal();
            if ((cf & 1 << ModificationEvent.CATEGORY.IDENTITY.ordinal()) != 0) {
                this.entities.getIdentityEvents(ret, from, to, typeFilter, fillDetails, session);
            }
            if ((cf & 1 << ModificationEvent.CATEGORY.ENTITY.ordinal()) != 0) {
                this.entities.getEntityEvents(ret, from, to, typeFilter, fillDetails, session);
            }
            if ((cf & 1 << ModificationEvent.CATEGORY.GROUP.ordinal()) != 0) {
                this.groups.getGroupEvents(ret, from, to, typeFilter, fillDetails, session);
            }
            if ((cf & 1 << ModificationEvent.CATEGORY.MEMBERSHIP.ordinal()) != 0) {
                this.groups.getMembershipEvents(ret, from, to, typeFilter, fillDetails, session);
            }
            if ((cf & 1 << ModificationEvent.CATEGORY.ATTRIBUTE.ordinal()) != 0) {
                this.entities.getAttributeEvents(ret, from, to, typeFilter, fillDetails, session);
            }
            ArrayList<ModificationEvent> arrayList = ret;
            return arrayList;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }
}

