/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.engine;

import eu.unicore.util.Log;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.db.DBEntitiesCache;
import pl.edu.icm.unicore.uvos.model.EntityBean;

public class PersistentIdManager {
    private static final Logger log = Log.getLogger((String)"unicore.uvos.server", PersistentIdManager.class);
    private static final String PREFIX = "UVOSEntityId:";
    private Set<String> used = new HashSet<String>();
    private Random randomEngine = new Random();
    private DBEntitiesCache entitiesCache;
    private DB db;

    public PersistentIdManager(DBEntitiesCache entitiesCache, DB db) throws InternalException {
        this.entitiesCache = entitiesCache;
        this.db = db;
        this.readIds();
    }

    public synchronized String getNewId() {
        long rand = this.randomEngine.nextLong();
        if (rand < 0L) {
            rand = -rand;
        }
        String id = PREFIX + rand;
        while (this.used.contains(id)) {
            id = PREFIX + ++rand;
        }
        this.used.add(id);
        return id;
    }

    private synchronized void readIds() throws InternalException {
        List<EntityBean> all;
        SqlSession session = this.db.getSqlSession();
        try {
            all = this.entitiesCache.getAllEntities(session);
        }
        catch (InternalException e) {
            log.error((Object)"Can't load list of existing persistent entity ids.");
            throw e;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        for (EntityBean eb : all) {
            this.used.add(eb.getPersistentId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void regenerateAll() throws InternalException {
        log.info((Object)"RECREATING ALL PERSISTENT ENTITY IDs.");
        System.out.println("RECREATING ALL PERSISTENT ENTITY IDs.");
        SqlSession session = this.db.getSqlSession();
        try {
            List<EntityBean> all;
            try {
                all = this.entitiesCache.getAllEntities(session);
            }
            catch (InternalException e) {
                log.error((Object)"Can't load list of existing persistent entity ids.");
                throw e;
            }
            this.used.clear();
            for (EntityBean eb : all) {
                String id = this.getNewId();
                this.entitiesCache.updateEntityPersistentId(eb.getId(), id, session);
            }
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        log.info((Object)"ALL PERSISTENT ENTITY IDs WERE UPDATED.");
        System.out.println("ALL PERSISTENT ENTITY IDs WERE UPDATED.");
    }
}

