/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.engine;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.Notification;
import pl.edu.icm.unicore.uvos.api.Permissions;
import pl.edu.icm.unicore.uvos.api.SupportedNotificationActions;
import pl.edu.icm.unicore.uvos.api.exceptions.AttributeNotFoundException;
import pl.edu.icm.unicore.uvos.api.exceptions.ElementAlreadyExistsException;
import pl.edu.icm.unicore.uvos.api.exceptions.ElementNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotEmptyException;
import pl.edu.icm.unicore.uvos.api.exceptions.GroupNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.IdentityNotKnownException;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.api.exceptions.LabelAlreadyUsedException;
import pl.edu.icm.unicore.uvos.api.exceptions.SecurityException;
import pl.edu.icm.unicore.uvos.api.exceptions.TimeOutOfRangeException;
import pl.edu.icm.unicore.uvos.api.exceptions.UnsupportedTypeException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.db.DBAttributeTypes;
import pl.edu.icm.unicore.uvos.db.DBEntities;
import pl.edu.icm.unicore.uvos.db.DBGroupResolver;
import pl.edu.icm.unicore.uvos.db.DBGroups;
import pl.edu.icm.unicore.uvos.db.DBIdentityTypes;
import pl.edu.icm.unicore.uvos.db.DBNotification;
import pl.edu.icm.unicore.uvos.engine.InternalAuthorization;
import pl.edu.icm.unicore.uvos.engine.api.UVOSManagementInterface;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityHelperFactory;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityTypeHelper;
import pl.edu.icm.unicore.uvos.mail.MailSender;
import pl.edu.icm.unicore.uvos.mail.VariablesMap;
import pl.edu.icm.unicore.uvos.model.GroupBean;
import pl.edu.icm.unicore.uvos.model.NotifyBean;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class ManagementModule
implements UVOSManagementInterface {
    private DBNotification dbNotify;
    private InternalAuthorization authZ;
    private MailSender mail;
    private DBAttributeTypes attributeTypes;
    private DBIdentityTypes identityTypes;
    private UVOSServerProperties configuration;
    private DBGroups groups;
    private DBGroupResolver groupResolver;
    private DBEntities entities;
    private DB db;

    public ManagementModule(DBNotification dbNotify, InternalAuthorization authZ, MailSender mail, DBAttributeTypes attributeTypes, DBIdentityTypes identityTypes, UVOSServerProperties configuration, DBGroups groups, DBGroupResolver groupResolver, DBEntities entities, DB db) {
        this.dbNotify = dbNotify;
        this.authZ = authZ;
        this.mail = mail;
        this.attributeTypes = attributeTypes;
        this.identityTypes = identityTypes;
        this.configuration = configuration;
        this.groups = groups;
        this.groupResolver = groupResolver;
        this.entities = entities;
        this.db = db;
    }

    private void checkGroupName(String name) throws InternalException {
        if (name.contains("/") || name.equals("")) {
            throw new InternalException("Group name is invalid (can't be empty or contain '/' character)");
        }
    }

    private void checkAttrName(AttributeType attr) throws InvalidValueException {
        String name = attr.getName();
        try {
            new URI(name);
        }
        catch (URISyntaxException e) {
            throw new InvalidValueException("Attribute name '" + name + "' is not an URI.");
        }
    }

    private void generateAttributes(Identity whom, SqlSession session) throws InternalException, InvalidValueException, SecurityException, ElementAlreadyExistsException, UnsupportedTypeException, ElementNotKnownException {
        IdentityTypeHelper helper = IdentityHelperFactory.getHelper((Identity)whom);
        List attributes = helper.generateAttributes();
        for (Attribute a : attributes) {
            this.setAttributeInternal(new Element(null, whom), a, true, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group addGroup(Group parent, String name) throws SecurityException, InternalException, GroupNotKnownException, ElementAlreadyExistsException {
        Group ret;
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.WRITE_P, this.groupResolver.resolveGroup(parent, null, session), false, session);
            this.checkGroupName(name);
            ret = this.groups.addGroup(parent, name, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("addGroup").setGroup(ret.toString()));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(Group toRemove, boolean recursive) throws SecurityException, InternalException, GroupNotKnownException, GroupNotEmptyException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorizeRecursive(Permissions.WRITE_P, this.groupResolver.resolveGroup(toRemove.getParent(), null, session), session);
            this.groups.removeGroup(toRemove, recursive, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("removeGroup").setGroup(toRemove.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group copyGroup(Group toCopy, Group newParent, String newName, boolean deleteOriginal) throws SecurityException, InternalException, GroupNotKnownException, ElementAlreadyExistsException, InvalidValueException {
        Group ret;
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.WRITE_P, this.groupResolver.resolveGroup(newParent, null, session), false, session);
            this.authZ.authorizeRecursive(Permissions.WRITE_P, this.groupResolver.resolveGroup(toCopy.getParent(), null, session), session);
            GroupBean srcGb = this.groupResolver.resolveGroup(toCopy, null, session);
            if (newName == null) {
                newName = srcGb.getName();
            }
            ret = this.groups.copyGroup(srcGb, newParent, newName, deleteOriginal, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("copyGroup").setGroup(toCopy.toString()).set("${TARGET}", newParent.toString()).set("${MOVED}", deleteOriginal ? "moved" : "copied"));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIdentity(Identity toAdd) throws SecurityException, InternalException, ElementAlreadyExistsException, UnsupportedTypeException, LabelAlreadyUsedException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorizeIdentityCtl(session);
            this.entities.addIdentity(toAdd, false, session);
            try {
                if (this.configuration.getBooleanValue("generateAttributesFromDN").booleanValue()) {
                    this.generateAttributes(toAdd, session);
                }
            }
            catch (ElementNotKnownException e) {
                throw new InternalException("ElementNotKnown", (Throwable)e);
            }
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("addIdentity").setSubject(toAdd.prettyString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIdentity(Identity toAdd, Identity equivalentIdentity) throws SecurityException, InternalException, ElementAlreadyExistsException, IdentityNotKnownException, UnsupportedTypeException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorizeIdentityCtl(equivalentIdentity, session);
            this.entities.addIdentity(toAdd, equivalentIdentity, false, session);
            try {
                if (this.configuration.getBooleanValue("generateAttributesFromDN").booleanValue()) {
                    this.generateAttributes(toAdd, session);
                }
            }
            catch (ElementNotKnownException e) {
                throw new InternalException("ElementNotKnown", (Throwable)e);
            }
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("addEquivalentIdentity").setSubject(toAdd.prettyString()).set("${EQUIVALENT}", equivalentIdentity.prettyString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdentity(Identity toRemove) throws SecurityException, InternalException, IdentityNotKnownException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorizeIdentityCtl(toRemove, session);
            this.entities.removeIdentity(toRemove, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("removeIdentity").setSubject(toRemove.prettyString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(Element whom, Attribute toAdd, boolean update) throws SecurityException, InternalException, ElementNotKnownException, ElementAlreadyExistsException, UnsupportedTypeException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.setAttributeInternal(whom, toAdd, update, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("setAttribute").setSubject(whom.toString()).setAttriubute(toAdd.toString()));
    }

    private void setAttributeInternal(Element whom, Attribute toAdd, boolean update, SqlSession session) throws SecurityException, InternalException, ElementNotKnownException, ElementAlreadyExistsException, UnsupportedTypeException, InvalidValueException {
        if (whom.getGroup() == null && whom.getIdentity() == null) {
            throw new InternalException("null element");
        }
        this.checkAttrName(toAdd.getType());
        if (whom.getIdentity() == null) {
            this.authZ.authorize(Permissions.WRITE_P, this.groupResolver.resolveGroup(whom.getGroup(), null, session), false, session);
            this.groups.setAttribute(whom.getGroup(), toAdd, update, session);
        } else if (whom.getGroup() != null) {
            this.authZ.authorize(Permissions.WRITE_P, this.groupResolver.resolveGroup(whom.getGroup(), null, session), false, session);
            this.entities.setAttribute(whom, toAdd, update, session);
        } else {
            this.authZ.authorize(Permissions.WRITE_P, false, session);
            this.entities.setAttribute(whom, toAdd, update, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(Element whom, String toRemove) throws SecurityException, InternalException, ElementNotKnownException, UnsupportedTypeException, InvalidValueException {
        if (whom.getGroup() == null && whom.getIdentity() == null) {
            throw new InternalException("null element");
        }
        SqlSession session = this.db.getSqlSession();
        try {
            if (whom.getIdentity() == null) {
                this.authZ.authorize(Permissions.WRITE_P, this.groupResolver.resolveGroup(whom.getGroup(), null, session), false, session);
                this.groups.removeAttribute(whom.getGroup(), toRemove, session);
            } else if (whom.getGroup() != null) {
                this.authZ.authorize(Permissions.WRITE_P, this.groupResolver.resolveGroup(whom.getGroup(), null, session), false, session);
                this.entities.removeAttribute(whom, toRemove, session);
            } else {
                this.authZ.authorize(Permissions.WRITE_P, false, session);
                this.entities.removeAttribute(whom, toRemove, session);
            }
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("removeAttribute").setSubject(whom.toString()).setAttriubute(toRemove.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToGroup(Identity toAdd, Group group) throws SecurityException, InternalException, IdentityNotKnownException, GroupNotKnownException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.WRITE_P, this.groupResolver.resolveGroup(group, null, session), false, session);
            this.groups.addToGroup(toAdd, group, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("addToGroup").setSubject(toAdd.prettyString()).setGroup(group.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromGroup(Identity toRemove, Group group) throws SecurityException, InternalException, IdentityNotKnownException, GroupNotKnownException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.WRITE_P, this.groupResolver.resolveGroup(group, null, session), false, session);
            this.groups.removeFromGroup(toRemove, group, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("removeFromGroup").setSubject(toRemove.prettyString()).setGroup(group.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIdentityLabel(Identity toChange, String label) throws SecurityException, InternalException, IdentityNotKnownException, LabelAlreadyUsedException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorizeIdentityCtl(toChange, session);
            this.entities.setIdentityLabel(toChange, label, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttributeType> getAttributeTypes() throws SecurityException, InternalException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(new Permissions(0), false, session);
            List<AttributeType> list = this.attributeTypes.getAttributeTypes();
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttributeTypes(List<AttributeType> toUpdate, boolean clear) throws SecurityException, InternalException, InvalidValueException {
        List<AttributeType> current = this.attributeTypes.getAttributeTypes();
        ArrayList<AttributeType> common = new ArrayList<AttributeType>();
        ArrayList<AttributeType> newAt = new ArrayList<AttributeType>();
        for (AttributeType a : toUpdate) {
            if (this.containsAtType(current, a.getName())) {
                common.add(a);
                continue;
            }
            newAt.add(a);
        }
        SqlSession session = this.db.getSqlSession();
        try {
            if (common.size() != 0 || clear) {
                this.authZ.authorize(Permissions.WRITE_P, false, session);
            } else {
                this.authZ.authorize(new Permissions(0), false, session);
            }
            if (clear) {
                for (AttributeType at : common) {
                    this.attributeTypes.deleteAttrType(at, session);
                }
            } else {
                for (AttributeType at : common) {
                    this.attributeTypes.updateAttrType(at, session);
                }
                for (AttributeType at : newAt) {
                    this.checkAttrName(at);
                    this.attributeTypes.addAttrType(at, session);
                }
            }
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    private boolean containsAtType(List<AttributeType> list, String name) {
        for (AttributeType at : list) {
            if (!at.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IdentityType> getIdentityTypes() throws SecurityException, InternalException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(new Permissions(0), false, session);
            List<IdentityType> list = this.identityTypes.getIdentityTypes();
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    @Override
    public void disableAttribute(Element whose, String toDisable, String valueToDisable) throws SecurityException, InternalException, ElementNotKnownException, AttributeNotFoundException, InvalidValueException {
        this.switchAttribute(whose, toDisable, valueToDisable, 1);
    }

    @Override
    public void enableAttribute(Element whose, String toEnable, String valueToEnable) throws SecurityException, InternalException, ElementNotKnownException, AttributeNotFoundException, InvalidValueException {
        this.switchAttribute(whose, toEnable, valueToEnable, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchAttribute(Element whose, String toSwitch, String value, int how) throws SecurityException, InternalException, ElementNotKnownException, AttributeNotFoundException, InvalidValueException {
        if (whose.getGroup() == null && whose.getIdentity() == null) {
            throw new InternalException("null element");
        }
        SqlSession session = this.db.getSqlSession();
        try {
            if (whose.getIdentity() == null) {
                this.authZ.authorize(Permissions.FULL_READ_P, this.groupResolver.resolveGroup(whose.getGroup(), null, session), false, session);
                this.groups.disableEnableAttribute(whose.getGroup(), toSwitch, value, how, session);
            } else {
                boolean self = this.authZ.isSelf(whose.getIdentity(), session);
                if (whose.getGroup() != null) {
                    this.authZ.authorize(Permissions.FULL_READ_P, this.groupResolver.resolveGroup(whose.getGroup(), null, session), self, session);
                    this.entities.disableEnableAttribute(whose, toSwitch, value, how, session);
                } else {
                    this.authZ.authorize(Permissions.FULL_READ_P, self, session);
                    this.entities.disableEnableAttribute(whose, toSwitch, value, how, session);
                }
            }
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attribute> getDisabledAttributes(Element whose) throws SecurityException, InternalException, ElementNotKnownException, InvalidValueException {
        if (whose.getGroup() == null && whose.getIdentity() == null) {
            throw new InternalException("null element");
        }
        SqlSession session = this.db.getSqlSession();
        try {
            if (whose.getIdentity() == null) {
                this.authZ.authorize(Permissions.FULL_READ_P, this.groupResolver.resolveGroup(whose.getGroup(), null, session), false, session);
                List<Attribute> list = this.groups.getDisabledAttributes(whose.getGroup(), session);
                return list;
            }
            boolean self = this.authZ.isSelf(whose.getIdentity(), session);
            if (whose.getGroup() != null) {
                this.authZ.authorize(Permissions.FULL_READ_P, this.groupResolver.resolveGroup(whose.getGroup(), null, session), self, session);
                List<Attribute> list = this.entities.getDisabledAttributes(whose, session);
                return list;
            }
            this.authZ.authorize(Permissions.FULL_READ_P, self, session);
            List<Attribute> list = this.entities.getDisabledAttributes(whose, session);
            return list;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeHistoricalData(Date deleteFrom) throws SecurityException, InternalException, TimeOutOfRangeException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorize(Permissions.WRITE_P, false, session);
            this.db.purgeHistory(deleteFrom, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("purgeHistoricalData").set("${DATE}", deleteFrom.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIdentityStatus(Identity toChange, boolean enable) throws SecurityException, InternalException, IdentityNotKnownException, InvalidValueException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.authZ.authorizeIdentityCtl(toChange, session);
            this.entities.setIdentityStatus(toChange, enable, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
        this.mail.sendNotification(new VariablesMap("setIdentityStatus").setSubject(toChange.prettyString()).set("${STATUS}", enable ? "enabled" : "disabled"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotification(String action, String receipents, String groupFilter) throws SecurityException, InternalException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.notifyAuthorize(groupFilter, session);
            if (!SupportedNotificationActions.isSupported((String)action)) {
                throw new InternalException("Action " + action + " is unsupported.");
            }
            this.dbNotify.addNotification(action, groupFilter, receipents, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Notification> getNotifications(String action, String groupFilter) throws SecurityException, InternalException {
        SqlSession session = this.db.getSqlSession();
        try {
            this.notifyAuthorize(groupFilter, session);
            List<?> all = this.dbNotify.getNotifications(action, session);
            ArrayList<Notification> ret = new ArrayList<Notification>();
            for (Object o : all) {
                NotifyBean nb = (NotifyBean)o;
                if (groupFilter != null && nb.getGroupFilter() == null || groupFilter != null && !nb.getGroupFilter().startsWith(groupFilter)) continue;
                ret.add(new Notification(nb.getId(), nb.getGroupFilter(), nb.getRecipients(), nb.getOperation()));
            }
            ArrayList<Notification> arrayList = ret;
            return arrayList;
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotification(int id) throws SecurityException, InternalException {
        SqlSession session = this.db.getSqlSession();
        try {
            String groupFilter = this.dbNotify.getNotificationGroup(id, session);
            this.notifyAuthorize(groupFilter, session);
            this.dbNotify.removeNotification(id, session);
            session.commit();
        }
        finally {
            this.db.releaseSqlSession(session);
        }
    }

    private void notifyAuthorize(String groupFilter, SqlSession session) throws SecurityException, InternalException {
        try {
            this.authZ.authorize(Permissions.WRITE_P, false, session);
        }
        catch (SecurityException e) {
            if (groupFilter != null) {
                try {
                    this.authZ.authorize(Permissions.WRITE_P, this.groupResolver.resolveGroup(new Group(groupFilter), null, session), false, session);
                }
                catch (GroupNotKnownException e1) {
                    throw e;
                }
            }
            throw e;
        }
    }
}

