/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.session.SqlSession;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.db.DB;
import pl.edu.icm.unicore.uvos.engine.PersistentIdManager;
import pl.edu.icm.unicore.uvos.server.ComponentContainer;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class UpdateDB {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                System.out.println("UVOS DB update tool.\nUsage:\n   doUpdate.sh <oldDbVersion> <newDbVersion> [mainUVOSConfigurationFile]\nExample:\n   doUpdate.sh 1.0 1.1");
                return;
            }
            String from = UpdateDB.parseVersion(args[0]);
            String to = UpdateDB.parseVersion(args[1]);
            String updateKey = "from_" + from + "_to_" + to;
            String configFile = "conf/uvosServer.conf";
            if (args.length > 2) {
                configFile = args[2];
            }
            ComponentContainer container = new ComponentContainer(configFile);
            UVOSServerProperties mainConf = container.getComponent(UVOSServerProperties.class);
            DB db = container.getComponent(DB.class);
            String dbProperties = mainConf.getValue("db.datamapPropertiesFile");
            String dbUpdateProperties = mainConf.getValue("db.dbUpdatePropertiesFile");
            Properties dbProp = new Properties();
            dbProp.load(new FileInputStream(dbProperties));
            dbProp.load(new FileInputStream(dbUpdateProperties));
            String dbType = dbProp.getProperty("url");
            dbType = dbType.substring(dbType.indexOf(58) + 1);
            dbType = dbType.substring(0, dbType.indexOf(58));
            System.out.println("Configured DBMS is: " + dbType + ", key is: " + updateKey);
            String updateScript = dbProp.getProperty(dbType);
            if (updateScript == null) {
                System.out.println("Can't find update script name for DBMS");
                return;
            }
            String updateRoot = dbProp.getProperty(updateKey);
            if (updateRoot == null) {
                System.out.println("Can't find updates for the specified versions of DBs");
                return;
            }
            updateScript = updateRoot + File.separator + updateScript;
            if (!new File(updateScript).exists()) {
                System.out.println("ERROR - update script " + updateScript + " dosn't exists!");
                return;
            }
            System.out.println("Update script: " + updateScript);
            try {
                String version = db.checkCurrentVersion();
                System.out.println("Current DB version is " + version);
                if (!version.equals(from)) {
                    System.out.println("DB version is not " + from + ", exiting.");
                    return;
                }
            }
            catch (Exception e) {
                System.out.println("Can't get current DB version");
                e.printStackTrace();
                return;
            }
            SqlSession session = db.getSqlSession();
            ScriptRunner runner = new ScriptRunner(session.getConnection());
            runner.setAutoCommit(false);
            runner.setStopOnError(true);
            if (!UpdateDB.askQuestion()) {
                return;
            }
            try {
                runner.runScript((Reader)new FileReader(updateScript));
            }
            finally {
                db.releaseSqlSession(session);
            }
            if (to.equals("1_2_0")) {
                PersistentIdManager idMan = container.getComponent(PersistentIdManager.class);
                idMan.regenerateAll();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
    }

    private static boolean askQuestion() {
        System.out.println("\n\nDo you really want to proceed with the update?\n\n It is strongly advised to backup the database before (this update utility doesn't do any backup). The UVOS server must be stopped before running this tool too.\n\nARE YOU SURE? [N]");
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        try {
            String answer = r.readLine();
            if (answer != null && answer.equalsIgnoreCase("y")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static String parseVersion(String version) {
        int i;
        String[] vers = version.split("\\.");
        if (vers.length > 3) {
            throw new IllegalArgumentException("To many version components (max is 3)");
        }
        String ret = "";
        for (i = 0; i < vers.length; ++i) {
            try {
                int num = Integer.parseInt(vers[i]);
                ret = ret + num + "_";
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Version component " + (i + 1) + " is not an integer");
            }
        }
        while (i < 3) {
            ret = ret + "0_";
            ++i;
        }
        return ret.substring(0, ret.length() - 1);
    }
}

