/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.db;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import pl.edu.icm.unicore.uvos.api.exceptions.InternalException;
import pl.edu.icm.unicore.uvos.engine.PersistentIdManager;
import pl.edu.icm.unicore.uvos.server.ComponentContainer;
import pl.edu.icm.unicore.uvos.util.UVOSServerProperties;

public class InitDB {
    private static Properties dbProp;
    private static ComponentContainer container;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDB(ScriptRunner runner) throws IOException, SQLException {
        System.out.println("Initialazing DB");
        String script = dbProp.getProperty("createdb.script");
        if (script == null) {
            script = "";
        }
        FileReader reader = new FileReader(script);
        try {
            runner.runScript((Reader)reader);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initData(ScriptRunner runner, String dbConf) throws IOException, SQLException {
        System.out.println("Putting initial data into DB");
        String script = dbProp.getProperty("initdata.script");
        if (script == null) {
            script = "conf/db/initdata.sql";
        }
        FileReader reader = new FileReader(script);
        try {
            runner.runScript((Reader)reader);
        }
        finally {
            reader.close();
        }
        try {
            PersistentIdManager idMan = container.getComponent(PersistentIdManager.class);
            idMan.regenerateAll();
        }
        catch (InternalException e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkDB(ScriptRunner runner) throws IOException, RuntimeSqlException {
        System.out.println("Checking content of DB");
        String script = dbProp.getProperty("checkdb.script");
        if (script == null) {
            script = "conf/db/checkdb.sql";
        }
        FileReader reader = new FileReader(script);
        try {
            runner.runScript((Reader)reader);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearDB(ScriptRunner runner) throws IOException, SQLException {
        System.out.println("Clearing DB");
        String script = dbProp.getProperty("cleardb.script");
        if (script == null) {
            script = "conf/db/cleardb.sql";
        }
        FileReader reader = new FileReader(script);
        try {
            runner.runScript((Reader)reader);
        }
        finally {
            reader.close();
        }
    }

    public static void work(String[] args) throws FileNotFoundException, IOException, SQLException {
        ScriptRunner runner1;
        ScriptRunner runner;
        SqlSession session;
        String dbConf;
        block6: {
            String configFile = "conf/uvosServer.conf";
            if (args.length > 0) {
                configFile = args[0];
            }
            boolean batchMode = args.length > 1 && args[1].equals("-b");
            container = new ComponentContainer(configFile);
            UVOSServerProperties mainConf = container.getComponent(UVOSServerProperties.class);
            String dbProperties = mainConf.getValue("db.datamapPropertiesFile");
            dbConf = mainConf.getValue("db.mapconfigFile");
            dbProp = new Properties();
            dbProp.load(new FileInputStream(dbProperties));
            FileReader reader = new FileReader(dbConf);
            SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
            SqlSessionFactory factory = builder.build((Reader)reader);
            session = factory.openSession();
            SqlSession session1 = factory.openSession();
            runner = new ScriptRunner(session.getConnection());
            runner.setAutoCommit(true);
            runner.setStopOnError(true);
            runner1 = new ScriptRunner(session1.getConnection());
            runner1.setAutoCommit(true);
            runner1.setStopOnError(false);
            if (batchMode) {
                PrintWriter nullPrinter = new PrintWriter(new NullWriter());
                runner.setErrorLogWriter(nullPrinter);
                runner.setLogWriter(nullPrinter);
                runner1.setErrorLogWriter(nullPrinter);
                runner1.setLogWriter(nullPrinter);
            }
            try {
                InitDB.checkDB(runner);
            }
            catch (RuntimeSqlException e) {
                if (batchMode || InitDB.askQuestion()) break block6;
                return;
            }
        }
        InitDB.clearDB(runner1);
        String driver = dbProp.getProperty("driver");
        if (driver.equals("com.mysql.jdbc.Driver")) {
            runner.setDelimiter("#");
        }
        InitDB.initDB(runner);
        runner.setDelimiter(";");
        InitDB.initData(runner, dbConf);
        if ("org.hsqldb.jdbcDriver".equals(driver)) {
            String cmd = "SHUTDOWN;";
            StringReader sr = new StringReader(cmd);
            runner.runScript((Reader)sr);
            sr.close();
        }
        session.close();
    }

    public static void main(String[] args) {
        try {
            InitDB.work(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean askQuestion() {
        System.out.println("\n\nIt seems that your database is initialized.\nProceeding will REMOVE the whole actual content.\n\nARE YOU SURE? [N]");
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        try {
            String answer = r.readLine();
            if (answer != null && answer.equalsIgnoreCase("y")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }
    }
}

